/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.propertyeditor.client;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCInvocationException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.registry.DataTypeNotFoundException;
import com.adobe.idp.dsc.registry.PropertyEditorNotFoundException;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent;
import com.adobe.idp.dsc.registry.propertyeditor.PropertyEditorRegistry;
import com.adobe.idp.dsc.util.HashMapClassLoader;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorRegistryClient
implements PropertyEditorRegistry {
    protected ServiceClientFactory m_serviceClientFactory;
    protected Map m_classLoaderCache;
    protected Map<String, Map> m_clientLibAsMap;
    protected boolean m_verifyCachedEntries;

    public PropertyEditorRegistryClient(ServiceClientFactory clientServiceFactory) {
        this(clientServiceFactory, true);
    }

    public PropertyEditorRegistryClient(ServiceClientFactory clientServiceFactory, boolean verifyCache) {
        this.m_serviceClientFactory = clientServiceFactory;
        this.m_verifyCachedEntries = verifyCache;
    }

    public PropertyEditorComponent getPropertyEditor(String aEditorId, int aMajorVersion, int aMinorVersion) throws PropertyEditorNotFoundException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(3);
            input.put("id", aEditorId);
            input.put("major-version", new Integer(aMajorVersion));
            input.put("minor-version", new Integer(aMinorVersion));
            InvocationResponse response = this.invoke("getPropertyEditor", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof PropertyEditorComponent)) continue;
                return (PropertyEditorComponent)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof PropertyEditorNotFoundException) {
                throw (PropertyEditorNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public PropertyEditorComponent getHeadPropertyEditor(String aEditorId) throws PropertyEditorNotFoundException {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("id", aEditorId);
            InvocationResponse response = this.invoke("getHeadPropertyEditor", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof PropertyEditorComponent)) continue;
                return (PropertyEditorComponent)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof PropertyEditorNotFoundException) {
                throw (PropertyEditorNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Map getClientLibAsMap(String aEditorId, int aMajorVersion, int aMinorVersion) throws PropertyEditorNotFoundException {
        Map rv;
        StringBuffer _key = new StringBuffer(aEditorId);
        _key.append('.');
        _key.append(Integer.toString(aMajorVersion));
        _key.append('.');
        _key.append(Integer.toString(aMinorVersion));
        _key.append('.');
        _key.append(System.identityHashCode(this));
        if (this.m_clientLibAsMap == null) {
            this.m_clientLibAsMap = new HashMap<String, Map>();
        }
        if ((rv = this.m_clientLibAsMap.get(_key.toString())) != null) {
            return rv;
        }
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(3);
            input.put("id", aEditorId);
            input.put("major-version", new Integer(aMajorVersion));
            input.put("minor-version", new Integer(aMinorVersion));
            InvocationResponse response = this.invoke("getClientLibAsMap", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Map)) continue;
                rv = (Map)returnValue[i];
                this.m_clientLibAsMap.put(_key.toString(), rv);
                return rv;
            }
            return rv;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof PropertyEditorNotFoundException) {
                throw (PropertyEditorNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public PropertyEditorComponent getPropertyEditorForHeadDataType(String aDataTypeId) throws DataTypeNotFoundException {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("id", aDataTypeId);
            InvocationResponse response = this.invoke("getPropertyEditorForHeadDataType", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof PropertyEditorComponent)) continue;
                return (PropertyEditorComponent)returnValue[i];
            }
            return null;
        }
        catch (DataTypeNotFoundException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof DataTypeNotFoundException) {
                throw (DataTypeNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public PropertyEditorComponent getPropertyEditorForDataType(String aDataTypeId, int aMajorVersion, int aMinorVersion, int aMicroVersion) throws DataTypeNotFoundException {
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(1);
            input.put("id", aDataTypeId);
            input.put("major-version", new Integer(aMajorVersion));
            input.put("minor-version", new Integer(aMinorVersion));
            input.put("micro-version", new Integer(aMicroVersion));
            InvocationResponse response = this.invoke("getPropertyEditorForDataType", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof PropertyEditorComponent)) continue;
                return (PropertyEditorComponent)returnValue[i];
            }
            return null;
        }
        catch (DataTypeNotFoundException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof DataTypeNotFoundException) {
                throw (DataTypeNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ClassLoader getClientClassLoader(ClassLoader aParent, String aPropertyEditorId) throws RegistryException {
        PropertyEditorComponent _propertyEditor = this.getHeadPropertyEditor(aPropertyEditorId);
        StringBuffer _key = new StringBuffer(aPropertyEditorId);
        _key.append('.');
        _key.append(Integer.toString(_propertyEditor.getMajorVersion()));
        _key.append('.');
        _key.append(Integer.toString(_propertyEditor.getMinorVersion()));
        _key.append('.');
        _key.append(System.identityHashCode(aParent));
        HashMapClassLoader _cl = null;
        if (this.m_classLoaderCache == null) {
            this.m_classLoaderCache = new HashMap();
        } else {
            _cl = (HashMapClassLoader)this.m_classLoaderCache.get(_key.toString());
        }
        if (_cl != null && this.m_verifyCachedEntries && _propertyEditor.getUpdateTime().getTime() > _cl.getCreateTime().getTime()) {
            _cl = null;
        }
        if (_cl == null) {
            Map _map = this.getClientLibAsMap(aPropertyEditorId, _propertyEditor.getMajorVersion(), _propertyEditor.getMinorVersion());
            _cl = new HashMapClassLoader(_map, aParent);
            this.m_classLoaderCache.put(_key.toString(), _cl);
        }
        return _cl;
    }

    public ClassLoader getClientClassLoader(ClassLoader aParent, String aPropertyEditorId, int aMajorVersion, int aMinorVersion) throws RegistryException {
        PropertyEditorComponent _propertyEditor;
        StringBuffer _key = new StringBuffer(aPropertyEditorId);
        _key.append('.');
        _key.append(Integer.toString(aMajorVersion));
        _key.append('.');
        _key.append(Integer.toString(aMinorVersion));
        _key.append('.');
        _key.append(System.identityHashCode(aParent));
        HashMapClassLoader _cl = null;
        if (this.m_classLoaderCache == null) {
            this.m_classLoaderCache = new HashMap();
        } else {
            _cl = (HashMapClassLoader)this.m_classLoaderCache.get(_key.toString());
        }
        if (_cl != null && this.m_verifyCachedEntries && (_propertyEditor = this.getPropertyEditor(aPropertyEditorId, aMajorVersion, aMinorVersion)).getUpdateTime().getTime() > _cl.getCreateTime().getTime()) {
            _cl = null;
        }
        if (_cl == null) {
            Map _map = this.getClientLibAsMap(aPropertyEditorId, aMajorVersion, aMinorVersion);
            _cl = new HashMapClassLoader(_map, aParent);
            this.m_classLoaderCache.put(_key.toString(), _cl);
        }
        return _cl;
    }

    private InvocationResponse invoke(String operationName, HashMap input) throws DSCException {
        InvocationRequest request = this.m_serviceClientFactory.createInvocationRequest("system.property_editor_registry", operationName, input, true);
        return this.m_serviceClientFactory.getServiceClient().invoke(request);
    }
}

