/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.infomodel.impl;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfigurationWrapper;
import com.adobe.idp.dsc.registry.infomodel.ServicePoolConfiguration;
import com.adobe.idp.dsc.registry.infomodel.impl.ServiceConfigurationImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.ServicePoolConfigurationImpl;
import com.adobe.idp.dsc.registry.service.ServicePoolConfigurationException;
import com.adobe.idp.dsc.util.DOMUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ServiceConfigurationWrapperImpl
implements ServiceConfigurationWrapper,
Serializable {
    private static final String INSTANCE_PER_REQUEST_STRATEGY_VALUE = "instance_per_invocation";
    private static final String POOLED_INSTANCE_STRATEGY_VALUE = "pooled_instance";
    private static final String SINGLE_INSTANCE_STRATEGY_VALUE = "single_instance";
    private static final long serialVersionUID = 1969355792039804702L;
    private ServicePoolConfiguration m_poolConfig = null;
    private ServiceConfiguration m_serviceConfiguration = null;
    private String m_wrapperDescriptor = null;
    public static final String EMPTY_CONTENT = "";
    public static final String MAX_ASYNCH_INSTANCES_ELEMENT_NAME = "max-asynch-instances";
    public static final String MAX_WAIT_ELEMENT_NAME = "max-wait";
    public static final String MAX_INSTANCES_ELEMENT_NAME = "max-instances";
    public static final String POOL_ELEMENT_NAME = "pool";
    public static final String INITIAL_INSTANCES_ELEMENT_NAME = "initial-instances";
    public static final String REQUEST_PROCESSING_STRATEGY_ELEMENT_NAME = "request-processing-strategy";

    public void setDescriptor(String descriptor) {
        this.m_wrapperDescriptor = descriptor;
    }

    public void setServiceConfiguration(ServiceConfiguration serviceConfig, boolean isUpdate) {
        this.m_serviceConfiguration = serviceConfig;
        ((ServiceConfigurationImpl)this.m_serviceConfiguration).setServiceConfigurationWrapper(this);
        if (serviceConfig.getPoolConfiguration() != null) {
            this.setPoolConfiguration(serviceConfig.getPoolConfiguration());
        }
        this.buildWrapperDescriptor(isUpdate);
        ((ServiceConfigurationImpl)this.m_serviceConfiguration).setPoolConfiguration(this.m_poolConfig);
        ((ServiceConfigurationImpl)this.m_serviceConfiguration).setDescriptor(this.m_wrapperDescriptor);
    }

    private Document buildWrapperDescriptor(boolean isUpdate) {
        Document _descriptorAsDOM = null;
        try {
            Element _rootElement = null;
            Element _serviceElement = null;
            Element _serviceWrapperElement = null;
            if (this.m_wrapperDescriptor != null) {
                _descriptorAsDOM = DOMUtil.parseDocumentFromStream(new ByteArrayInputStream(TextUtil.trim(this.getDescriptor()).getBytes("UTF-8")));
                Element _configWrapper = DOMUtil.getFirstChildElement(_descriptorAsDOM);
                Element _poolConfig = DOMUtil.getFirstChildElement(_configWrapper);
                if (_poolConfig != null && _poolConfig.getNodeName().equals("service-pool-config") && this.m_serviceConfiguration.getDescriptor() != null) {
                    Document _serviceDescriptor = DOMUtil.parseDocumentFromStream(new ByteArrayInputStream(TextUtil.trim(this.m_serviceConfiguration.getDescriptor()).getBytes("UTF-8")));
                    Element _serviceDescriptorElement = (Element)_descriptorAsDOM.importNode(_serviceDescriptor.getDocumentElement(), true);
                    _configWrapper.removeChild(_poolConfig);
                    _configWrapper.appendChild(_serviceDescriptorElement);
                    _configWrapper.appendChild(_poolConfig);
                }
                if (isUpdate) {
                    Element _invocationPattern = DOMUtil.getChildElement(_configWrapper, "request-processing-strategy-config");
                    if (_invocationPattern == null) {
                        _invocationPattern = DOMUtil.createElement(_configWrapper, "request-processing-strategy-config");
                        _configWrapper.appendChild(_invocationPattern);
                    }
                    DOMUtil.setNodeText(_invocationPattern, ServiceConfigurationWrapperImpl.getInvocationStrategyValueForId(this.m_serviceConfiguration.getRequestProcessingStrategy()));
                }
            } else if (this.m_serviceConfiguration.getDescriptor() != null) {
                _descriptorAsDOM = DOMUtil.parseDocumentFromStream(new ByteArrayInputStream(TextUtil.trim(this.m_serviceConfiguration.getDescriptor()).getBytes("UTF-8")));
            }
            if (_descriptorAsDOM == null) {
                _descriptorAsDOM = DOMUtil.newDocument();
            }
            if ((_rootElement = _descriptorAsDOM.getDocumentElement()) != null && _rootElement.getNodeName().equals("service-config")) {
                _serviceWrapperElement = _rootElement;
                _serviceElement = DOMUtil.getFirstChildElement(_serviceWrapperElement);
                if (this.m_serviceConfiguration.getDescriptor() != null) {
                    String _descriptorToUpdateWith = ServiceConfigurationWrapperImpl.removeConfigurationWrapper(this.m_serviceConfiguration.getDescriptor());
                    Document _serviceDoc = DOMUtil.parseDocumentFromStream(new ByteArrayInputStream(TextUtil.trim(_descriptorToUpdateWith).getBytes("UTF-8")));
                    Element _newServiceElement = DOMUtil.getFirstChildElement(_serviceDoc);
                    Element _newImportedServiceElement = (Element)_descriptorAsDOM.importNode(_newServiceElement, true);
                    if (_serviceElement != null && !_serviceElement.getNodeName().equals("service-pool-config") && !_serviceElement.getNodeName().equals("request-processing-strategy-config")) {
                        _serviceWrapperElement.replaceChild(_newImportedServiceElement, _serviceElement);
                    } else {
                        _serviceWrapperElement.insertBefore(_newImportedServiceElement, _serviceElement);
                    }
                    _serviceElement = _newImportedServiceElement;
                }
            } else {
                _serviceElement = _rootElement;
                _descriptorAsDOM = this.wrapperServiceConfiguration(_serviceElement);
                _serviceWrapperElement = DOMUtil.getChildElement(_descriptorAsDOM, "service-config");
                _serviceElement = DOMUtil.getChildElement(_serviceWrapperElement, "service");
            }
            Element _invocationPattern = null;
            if (_serviceElement != null) {
                _invocationPattern = DOMUtil.getChildElement(_serviceElement, REQUEST_PROCESSING_STRATEGY_ELEMENT_NAME);
            }
            String invocationStrategy = ServiceConfigurationWrapperImpl.getInvocationStrategyValueForId(this.m_serviceConfiguration.getRequestProcessingStrategy());
            if (_invocationPattern != null && !isUpdate) {
                invocationStrategy = DOMUtil.getTextForNode(_invocationPattern);
            }
            if (_serviceElement != null) {
                Element _poolElement = DOMUtil.getChildElement(_serviceElement, POOL_ELEMENT_NAME);
                if (invocationStrategy.compareToIgnoreCase(POOLED_INSTANCE_STRATEGY_VALUE) == 0 || _poolElement != null) {
                    Element _poolConfigElement = DOMUtil.getChildElement(_serviceWrapperElement, "service-pool-config");
                    if (_poolConfigElement == null && !isUpdate) {
                        this.loadPoolConfigurationFromServiceDescriptor(_descriptorAsDOM, _serviceElement);
                    } else if (this.m_poolConfig == null) {
                        if (isUpdate) {
                            this.updateWrapperPoolConfiguration(_serviceWrapperElement);
                        } else {
                            this.loadPoolConfigurationFromWrapperDescriptor(_descriptorAsDOM, _serviceWrapperElement);
                        }
                    }
                }
                if (_invocationPattern != null) {
                    if (isUpdate) {
                        this.updateInvocationStrategy(_serviceElement);
                    } else {
                        this.loadInvocationStrategy(_serviceElement);
                    }
                }
            }
            if (_serviceWrapperElement != null) {
                Element _poolConfigElement = DOMUtil.getChildElement(_serviceWrapperElement, "service-pool-config");
                if (this.m_poolConfig == null && _poolConfigElement != null) {
                    this.loadPoolConfigurationFromWrapperDescriptor(_descriptorAsDOM, _serviceWrapperElement);
                } else {
                    this.updateWrapperPoolConfiguration(_serviceWrapperElement);
                }
                if (_invocationPattern == null) {
                    if (isUpdate) {
                        this.updateInvocationStrategy(_serviceWrapperElement);
                    } else {
                        this.loadInvocationStrategy(_serviceWrapperElement);
                    }
                }
            }
            this.m_wrapperDescriptor = DOMUtil.toString(_descriptorAsDOM);
        }
        catch (ParserConfigurationException e) {
            throw new ServicePoolConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ServicePoolConfigurationException(e);
        }
        catch (IOException e) {
            throw new ServicePoolConfigurationException(e);
        }
        return _descriptorAsDOM;
    }

    private Document wrapperServiceConfiguration(Element serviceElement) throws ParserConfigurationException {
        Document _doc = DOMUtil.newDocument();
        Element _serviceConfigurationWrapper = _doc.createElement("service-config");
        if (serviceElement != null) {
            Node _importedService = _doc.importNode(serviceElement, true);
            _serviceConfigurationWrapper.appendChild(_importedService);
        }
        _doc.appendChild(_serviceConfigurationWrapper);
        return _doc;
    }

    private void updateInvocationStrategy(Element element) {
        Element invocationStrategy = DOMUtil.getChildElement(element, REQUEST_PROCESSING_STRATEGY_ELEMENT_NAME);
        if (invocationStrategy == null) {
            invocationStrategy = DOMUtil.createElement(element, REQUEST_PROCESSING_STRATEGY_ELEMENT_NAME);
            element.appendChild(invocationStrategy);
        }
        DOMUtil.setNodeText(invocationStrategy, ServiceConfigurationWrapperImpl.getInvocationStrategyValueForId(this.m_serviceConfiguration.getRequestProcessingStrategy()));
    }

    private void loadInvocationStrategy(Element element) {
        Element invocationStrategy = DOMUtil.getChildElement(element, REQUEST_PROCESSING_STRATEGY_ELEMENT_NAME);
        String strategy = TextUtil.trim(DOMUtil.getTextForNode(invocationStrategy));
        if (strategy == null) {
            strategy = INSTANCE_PER_REQUEST_STRATEGY_VALUE;
        }
        ((ServiceConfigurationImpl)this.m_serviceConfiguration).setRequestProcessingStrategy(ServiceConfigurationWrapperImpl.getInvocationStrategyIdForValue(strategy));
    }

    private void updateWrapperPoolConfiguration(Element serviceWrapper) {
        if (this.m_poolConfig != null) {
            Element _initialInstances;
            Element _configWrapperPoolElement = DOMUtil.getChildElement(serviceWrapper, "service-pool-config");
            if (_configWrapperPoolElement == null) {
                _configWrapperPoolElement = DOMUtil.createElement(serviceWrapper, "service-pool-config");
                serviceWrapper.appendChild(_configWrapperPoolElement);
            }
            if ((_initialInstances = DOMUtil.getChildElement(_configWrapperPoolElement, INITIAL_INSTANCES_ELEMENT_NAME)) == null) {
                _initialInstances = DOMUtil.createElement(_configWrapperPoolElement, INITIAL_INSTANCES_ELEMENT_NAME);
                _configWrapperPoolElement.appendChild(_initialInstances);
            }
            DOMUtil.setNodeText(_initialInstances, Integer.toString(this.m_poolConfig.getInitialInstances()));
            Element _maxInstances = DOMUtil.getChildElement(_configWrapperPoolElement, MAX_INSTANCES_ELEMENT_NAME);
            if (_maxInstances == null) {
                _maxInstances = DOMUtil.createElement(_configWrapperPoolElement, MAX_INSTANCES_ELEMENT_NAME);
                _configWrapperPoolElement.appendChild(_maxInstances);
            }
            DOMUtil.setNodeText(_maxInstances, Integer.toString(this.m_poolConfig.getMaxInstances()));
            Element _maxAsynchInstances = DOMUtil.getChildElement(_configWrapperPoolElement, MAX_ASYNCH_INSTANCES_ELEMENT_NAME);
            if (_maxAsynchInstances == null) {
                _maxAsynchInstances = DOMUtil.createElement(_configWrapperPoolElement, MAX_ASYNCH_INSTANCES_ELEMENT_NAME);
                _configWrapperPoolElement.appendChild(_maxAsynchInstances);
            }
            DOMUtil.setNodeText(_maxAsynchInstances, Integer.toString(this.m_poolConfig.getMaxAsynchronousInstances()));
            Element _maxWait = DOMUtil.getChildElement(_configWrapperPoolElement, MAX_WAIT_ELEMENT_NAME);
            if (_maxWait == null) {
                _maxWait = DOMUtil.createElement(_configWrapperPoolElement, MAX_WAIT_ELEMENT_NAME);
                _configWrapperPoolElement.appendChild(_maxWait);
            }
            DOMUtil.setNodeText(_maxWait, Long.toString(this.m_poolConfig.getMaxWait()));
        }
    }

    public void loadPoolConfigurationFromWrapperDescriptor(Document descriptorDOM, Element serviceWrapperElement) {
        if (serviceWrapperElement != null) {
            Element _pool = DOMUtil.getChildElement(serviceWrapperElement, "service-pool-config");
            this.extractPoolConfiguration(descriptorDOM, serviceWrapperElement, _pool);
        }
    }

    private void loadPoolConfigurationFromServiceDescriptor(Document descriptorDOM, Element serviceElement) {
        if (serviceElement != null) {
            Element _pool = DOMUtil.getChildElement(serviceElement, POOL_ELEMENT_NAME);
            this.extractPoolConfiguration(descriptorDOM, serviceElement, _pool);
        }
    }

    private void extractPoolConfiguration(Document descriptorDOM, Element serviceElement, Element _pool) {
        Element _initialInstances = DOMUtil.getChildElement(_pool, INITIAL_INSTANCES_ELEMENT_NAME);
        int _initialInstancesIntVal = 0;
        if (_initialInstances == null) {
            _initialInstances = descriptorDOM.createElement(INITIAL_INSTANCES_ELEMENT_NAME);
            _pool.appendChild(_initialInstances);
        } else {
            String _initialInstancesVal = TextUtil.trim(DOMUtil.getTextForNode(_initialInstances));
            if (_initialInstancesVal != null && (_initialInstancesIntVal = Integer.parseInt(_initialInstancesVal)) < 0) {
                _initialInstancesIntVal = 0;
            }
        }
        DOMUtil.setNodeText(_initialInstances, Integer.toString(_initialInstancesIntVal));
        Element _maxInstances = DOMUtil.getChildElement(_pool, MAX_INSTANCES_ELEMENT_NAME);
        int _maxInstancesIntVal = 0;
        if (_maxInstances == null) {
            _maxInstances = descriptorDOM.createElement(MAX_INSTANCES_ELEMENT_NAME);
            _pool.appendChild(_initialInstances);
        } else {
            String _maxInstancesVal = TextUtil.trim(DOMUtil.getTextForNode(_maxInstances));
            if (_maxInstancesVal != null && (_maxInstancesIntVal = Integer.parseInt(_maxInstancesVal)) < 0) {
                _maxInstancesIntVal = 0;
            }
        }
        DOMUtil.setNodeText(_maxInstances, Integer.toString(_maxInstancesIntVal));
        Element _maxAsynchInstances = DOMUtil.getChildElement(_pool, MAX_ASYNCH_INSTANCES_ELEMENT_NAME);
        int _maxAsynchInstancesIntVal = 0;
        if (_maxAsynchInstances == null) {
            _maxAsynchInstances = DOMUtil.createElement(serviceElement, MAX_ASYNCH_INSTANCES_ELEMENT_NAME);
            _pool.appendChild(_maxAsynchInstances);
        } else {
            String _maxAsynchInstancesVal = TextUtil.trim(DOMUtil.getTextForNode(_maxAsynchInstances));
            if (_maxAsynchInstancesVal != null && (_maxAsynchInstancesIntVal = Integer.parseInt(_maxAsynchInstancesVal)) < 0) {
                _maxAsynchInstancesIntVal = 0;
            }
        }
        DOMUtil.setNodeText(_maxAsynchInstances, Integer.toString(_maxAsynchInstancesIntVal));
        Element _maxWait = DOMUtil.getChildElement(_pool, MAX_WAIT_ELEMENT_NAME);
        long _maxWaitTimeIntVal = 0L;
        if (_maxWait == null) {
            _maxWait = DOMUtil.createElement(serviceElement, MAX_WAIT_ELEMENT_NAME);
            _pool.appendChild(_maxWait);
        } else {
            String _maxWaitVal = TextUtil.trim(DOMUtil.getTextForNode(_maxWait));
            if (_maxWaitVal != null && (_maxWaitTimeIntVal = Long.parseLong(_maxWaitVal)) < 0L) {
                _maxWaitTimeIntVal = 0L;
            }
        }
        DOMUtil.setNodeText(_maxWait, Long.toString(_maxWaitTimeIntVal));
        if (this.m_poolConfig == null) {
            this.m_poolConfig = new ServicePoolConfigurationImpl();
        }
        ((ServicePoolConfigurationImpl)this.m_poolConfig).setInitialInstances(_initialInstancesIntVal);
        ((ServicePoolConfigurationImpl)this.m_poolConfig).setMaxInstances(_maxInstancesIntVal);
        ((ServicePoolConfigurationImpl)this.m_poolConfig).setMaxAsynchronousInstances(_maxAsynchInstancesIntVal);
        ((ServicePoolConfigurationImpl)this.m_poolConfig).setMaxWait(_maxWaitTimeIntVal);
        ((ServiceConfigurationImpl)this.m_serviceConfiguration).setPoolConfiguration(this.m_poolConfig);
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.m_serviceConfiguration;
    }

    protected void setPoolConfiguration(ServicePoolConfiguration poolConfig) {
        this.m_poolConfig = poolConfig;
    }

    public ServicePoolConfiguration getPoolConfiguration() {
        return this.m_poolConfig;
    }

    public static String removeConfigurationWrapper(String descriptor) {
        String _unwrappedDescriptorString = descriptor;
        if ((descriptor = TextUtil.trim(descriptor)) != null) {
            try {
                Element _unwrappedDescriptor = null;
                Document _descriptorAsDOM = DOMUtil.parseDocumentFromStream(new ByteArrayInputStream(descriptor.getBytes("UTF-8")));
                Element _serviceConfig = DOMUtil.getChildElement(_descriptorAsDOM, "service-config");
                if (_serviceConfig != null) {
                    _unwrappedDescriptor = DOMUtil.getFirstChildElement(_serviceConfig);
                    _unwrappedDescriptorString = _unwrappedDescriptor != null ? DOMUtil.toString(_unwrappedDescriptor) : descriptor;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _unwrappedDescriptorString;
    }

    public String getServiceDescriptor() {
        Document _descriptorAsDOM = null;
        String _descriptor = null;
        try {
            if (this.getDescriptor() != null) {
                _descriptorAsDOM = DOMUtil.parseDocumentFromStream(new ByteArrayInputStream(this.getDescriptor().getBytes("UTF-8")));
                Element _serviceConfig = DOMUtil.getChildElement(_descriptorAsDOM, "service-config");
                Element _originalDescriptor = null;
                _originalDescriptor = _serviceConfig != null ? DOMUtil.getFirstChildElement(_serviceConfig) : _serviceConfig;
                if (_originalDescriptor != null && !_originalDescriptor.getNodeName().equals("service-pool-config")) {
                    _descriptor = DOMUtil.toString(_originalDescriptor);
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new ServicePoolConfigurationException(e);
        }
        catch (SAXException e) {
            throw new ServicePoolConfigurationException(e);
        }
        catch (IOException e) {
            throw new ServicePoolConfigurationException(e);
        }
        return _descriptor;
    }

    public String getDescriptor() {
        return this.m_wrapperDescriptor;
    }

    public static String getInvocationStrategyValueForId(int invocationStrategy) {
        switch (invocationStrategy) {
            case 0: {
                return SINGLE_INSTANCE_STRATEGY_VALUE;
            }
            case 1: {
                return INSTANCE_PER_REQUEST_STRATEGY_VALUE;
            }
            case 2: {
                return POOLED_INSTANCE_STRATEGY_VALUE;
            }
        }
        throw new DSCRuntimeException("ServiceConfigurationWrapperImpl:getInvocationStrategyValueForId:invalid request processing enum value:" + invocationStrategy);
    }

    public static int getInvocationStrategyIdForValue(String invocationStrategy) {
        if (invocationStrategy.toLowerCase().equals(SINGLE_INSTANCE_STRATEGY_VALUE)) {
            return 0;
        }
        if (invocationStrategy.toLowerCase().equals(INSTANCE_PER_REQUEST_STRATEGY_VALUE)) {
            return 1;
        }
        if (invocationStrategy.toLowerCase().equals(POOLED_INSTANCE_STRATEGY_VALUE)) {
            return 2;
        }
        throw new DSCRuntimeException("ServiceConfigurationWrapperImpl:getInvocationStrategyIdForValue:invalid request processing enum id:" + invocationStrategy);
    }
}

