/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.infomodel.impl;

import com.adobe.idp.dsc.registry.ConfigParameterNotFoundException;
import com.adobe.idp.dsc.registry.OperationNotFoundException;
import com.adobe.idp.dsc.registry.infomodel.ConfigParameter;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import com.adobe.idp.dsc.registry.infomodel.Operation;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfigurationWrapper;
import com.adobe.idp.dsc.registry.infomodel.ServicePoolConfiguration;
import com.adobe.idp.dsc.registry.infomodel.impl.OperationImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.ServicePoolConfigurationImpl;
import com.adobe.idp.dsc.util.IOUtil;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.idp.dsc.util.UUIDGenerator;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class ServiceConfigurationImpl
implements ServiceConfiguration,
Serializable,
Cloneable {
    static final long serialVersionUID = -8734233915363369255L;
    protected String m_serviceName;
    protected String m_title;
    protected String m_hint;
    protected String[] m_supportedConnectorIds;
    protected static final String[] EMPTY_CONNECTOR_IDS = new String[0];
    protected boolean m_orchestrateable = true;
    protected short m_majorVersion;
    protected short m_minorVersion;
    protected short m_accessLevel;
    protected byte[] m_smallIcon;
    protected byte[] m_largeIcon;
    protected String m_description;
    protected String m_specificationId;
    protected String m_specificationVersion;
    protected String m_componentId;
    protected String m_componentVersion;
    protected boolean m_startWithComponent;
    protected String m_descriptor;
    protected Map m_attributes;
    protected ListOrderedMap m_operations;
    protected int m_state;
    protected ConfigParameter[] m_configParams;
    protected static final ConfigParameter[] EMPTY_CONFIG_PARAMETERS = new ConfigParameter[0];
    protected Endpoint[] m_Endpoints;
    protected String m_type;
    protected String m_lockedByUser;
    protected String m_runAsConfiguration;
    protected String m_uuid;
    protected Date m_createTime;
    protected Date m_updateTime;
    protected String[] m_specificationIds;
    protected boolean m_monitor = false;
    protected String m_serviceUuid;
    protected int invocationHandlingStrategy = 1;
    protected int m_maxInstances = 0;
    protected int m_initialInstances = 0;
    protected long m_maxWait = 0L;
    protected int m_maxAsynchronousInstances = 0;
    protected ServicePoolConfiguration m_servicePoolConfiguration;
    protected boolean m_auditingEnabled = false;
    protected boolean m_isPojo = false;
    private ServiceConfigurationWrapper m_serviceConfigurationWrapper = null;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public boolean isPojo() {
        return this.m_isPojo;
    }

    public void setIsPojo(boolean aValue) {
        this.m_isPojo = aValue;
    }

    public void setServiceUuid(String aServiceUuid) {
        this.m_serviceUuid = aServiceUuid;
    }

    public String getServiceUuid() {
        return this.m_serviceUuid;
    }

    public void setDescriptor(String aDescriptor) {
        this.m_descriptor = aDescriptor;
    }

    public String getDescriptor() {
        return this.m_descriptor;
    }

    public void setServiceId(String aName) {
        this.m_serviceName = aName;
    }

    public String getServiceId() {
        return this.m_serviceName;
    }

    public void setTitle(String aTitle) {
        this.m_title = aTitle;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setHint(String aHint) {
        this.m_hint = aHint;
    }

    public String getHint() {
        return this.m_hint;
    }

    public void setSupportedConnectorIds(String[] aConnectors) {
        this.m_supportedConnectorIds = aConnectors;
    }

    public String[] getSupportedConnectorIds() {
        return this.m_supportedConnectorIds;
    }

    public void setOrchestrateable(boolean aValue) {
        this.m_orchestrateable = aValue;
    }

    public boolean getOrchestrateable() {
        return this.m_orchestrateable;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setMajorVersion(short majorVersion) {
        this.m_majorVersion = majorVersion;
    }

    public short getMajorVersion() {
        return this.m_majorVersion;
    }

    public void setMinorVersion(short minorVersion) {
        this.m_minorVersion = minorVersion;
    }

    public short getMinorVersion() {
        return this.m_minorVersion;
    }

    public void setAccessLevel(short accessLevel) {
        this.m_accessLevel = accessLevel;
    }

    public short getAccessLevel() {
        return this.m_accessLevel;
    }

    public void setSmallIcon(byte[] smallIcon) {
        this.m_smallIcon = smallIcon;
    }

    public byte[] getSmallIcon() {
        return this.m_smallIcon;
    }

    public void setLargeIcon(byte[] largeIcon) {
        this.m_largeIcon = largeIcon;
    }

    public byte[] getLargeIcon() {
        return this.m_largeIcon;
    }

    public void setState(int aState) {
        this.m_state = aState;
    }

    public int getState() {
        return this.m_state;
    }

    public void setComponentId(String aComponentId) {
        this.m_componentId = aComponentId;
    }

    public String getComponentId() {
        return this.m_componentId;
    }

    public void setComponentVersion(String aComponentVersion) {
        this.m_componentVersion = aComponentVersion;
    }

    public String getComponentVersion() {
        return this.m_componentVersion;
    }

    public void setStartWithComponent(boolean aVal) {
        this.m_startWithComponent = aVal;
    }

    public boolean getStartWithComponent() {
        return this.m_startWithComponent;
    }

    public void setAttributes(Map aAttrs) {
        this.m_attributes = aAttrs;
    }

    public Map getAttributes() {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap();
        }
        return this.m_attributes;
    }

    public void addOperation(Operation aOperation) {
        OperationImpl _operation = (OperationImpl)aOperation;
        ListOrderedMap _operationsMap = this.getOperationsMap();
        _operationsMap.put((Object)aOperation.getName(), (Object)aOperation);
        _operation.setServiceConfiguration(this);
    }

    public Operation getOperation(String aName) throws OperationNotFoundException {
        ListOrderedMap _operationsMap = this.getOperationsMap();
        Operation _operation = (Operation)_operationsMap.get((Object)aName);
        if (_operation == null) {
            throw new OperationNotFoundException(this.getServiceId(), aName);
        }
        return _operation;
    }

    public Operation[] getOperations() {
        ListOrderedMap _operationsMap = this.getOperationsMap();
        Operation[] _operations = new Operation[_operationsMap.size()];
        _operationsMap.values().toArray(_operations);
        return _operations;
    }

    public void setOperations(Operation[] aOperations) {
        this.m_operations = null;
        if (aOperations == null) {
            return;
        }
        for (int i = 0; i < aOperations.length; ++i) {
            this.addOperation(aOperations[i]);
        }
    }

    private ListOrderedMap getOperationsMap() {
        if (this.m_operations == null) {
            this.m_operations = new ListOrderedMap();
        }
        return this.m_operations;
    }

    public void setConfigParameters(ConfigParameter[] aConfigParams) {
        this.m_configParams = aConfigParams;
    }

    public ConfigParameter[] getConfigParameters() {
        if (this.m_configParams == null) {
            return EMPTY_CONFIG_PARAMETERS;
        }
        return this.m_configParams;
    }

    public ConfigParameter getConfigParameter(String aParamName) throws ConfigParameterNotFoundException {
        ConfigParameter[] _params = this.getConfigParameters();
        for (int i = 0; i < _params.length; ++i) {
            if (!_params[i].getName().equals(aParamName)) continue;
            return _params[i];
        }
        throw new ConfigParameterNotFoundException(this.getServiceId(), aParamName);
    }

    public void setType(String aType) {
        this.m_type = aType;
    }

    public String getType() {
        return this.m_type;
    }

    public void setLockedByUser(String aUser) {
        this.m_lockedByUser = aUser;
    }

    public String getLockedByUser() {
        return this.m_lockedByUser;
    }

    public boolean hasRunAsConfiguration() {
        return !TextUtil.isEmpty(this.m_runAsConfiguration);
    }

    public void setRunAsConfiguration(String aRunAsConfiguration) {
        this.m_runAsConfiguration = aRunAsConfiguration;
    }

    public String getRunAsConfiguration() {
        return this.m_runAsConfiguration;
    }

    public String getUuid() {
        if (this.m_uuid == null) {
            this.m_uuid = new UUIDGenerator().nextUUID();
        }
        return this.m_uuid;
    }

    public void setUuid(String aUuid) {
        if (this.m_uuid == null) {
            this.m_uuid = aUuid;
        }
    }

    public boolean isOrchestration() {
        boolean _isOrchestration = this.getType() != null && this.getType().equals("WKF");
        return _isOrchestration;
    }

    public boolean isLocked() {
        return !TextUtil.isEmpty(this.m_lockedByUser);
    }

    public boolean isActive() {
        return this.getState() == 2 || this.getState() == 1;
    }

    public boolean isStopped() {
        return this.getState() == 1;
    }

    public boolean isRunning() {
        return this.getState() == 2;
    }

    public void setUpdateTime(Date aTime) {
        this.m_updateTime = aTime;
    }

    public Date getUpdateTime() {
        return this.m_updateTime;
    }

    public void setCreateTime(Date aCreateTime) {
        this.m_createTime = aCreateTime;
    }

    public Date getCreateTime() {
        return this.m_createTime;
    }

    public void setSpecificationIds(String[] aSpecificationIds) {
        this.m_specificationIds = aSpecificationIds;
    }

    public String[] getSpecificationIds() {
        if (this.m_specificationIds == null) {
            return EMPTY_STRING_ARRAY;
        }
        return this.m_specificationIds;
    }

    public void setMonitoringEnabled(boolean aValue) {
        this.m_monitor = aValue;
    }

    public boolean isMonitoringEnabled() {
        return this.m_monitor;
    }

    public Object clone() {
        byte[] _buff = IOUtil.writeObject2ByteArray(this);
        return IOUtil.readObjectFromByteArray(_buff, Thread.currentThread().getContextClassLoader());
    }

    public int getRequestProcessingStrategy() {
        return this.invocationHandlingStrategy;
    }

    public void setRequestProcessingStrategy(int strategy) {
        this.invocationHandlingStrategy = strategy;
    }

    public void setAuditingEnabled(boolean aValue) {
        this.m_auditingEnabled = aValue;
    }

    public boolean isAuditingEnabled() {
        return this.m_auditingEnabled;
    }

    public void setPoolConfiguration(ServicePoolConfiguration configuration) {
        this.m_servicePoolConfiguration = configuration;
        if (this.m_servicePoolConfiguration != null) {
            ((ServicePoolConfigurationImpl)this.m_servicePoolConfiguration).setServiceConfiguration(this);
        }
    }

    public ServicePoolConfiguration getPoolConfiguration() {
        return this.m_servicePoolConfiguration;
    }

    public ServiceConfigurationWrapper getServiceConfigurationWrapper() {
        return this.m_serviceConfigurationWrapper;
    }

    public void setServiceConfigurationWrapper(ServiceConfigurationWrapper wrapper) {
        this.m_serviceConfigurationWrapper = wrapper;
    }
}

