/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.infomodel.impl;

import com.adobe.idp.dsc.registry.InputParameterNotFoundException;
import com.adobe.idp.dsc.registry.OutputParameterNotFoundException;
import com.adobe.idp.dsc.registry.infomodel.Fault;
import com.adobe.idp.dsc.registry.infomodel.InputParameter;
import com.adobe.idp.dsc.registry.infomodel.Operation;
import com.adobe.idp.dsc.registry.infomodel.OutputParameter;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.infomodel.layout.Layout;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class OperationImpl
implements Operation,
Serializable {
    static final long serialVersionUID = -2886018342284425001L;
    protected String m_name;
    protected String m_title;
    protected String m_hint;
    protected boolean m_orchestrateable = true;
    protected boolean m_anonymousAccess;
    protected String[] m_supportedConnectorIds;
    protected Map m_attrs;
    protected ServiceConfiguration m_owningService;
    protected InputParameter[] m_inputDescriptors;
    protected OutputParameter[] m_outputDescriptors;
    protected String m_description;
    protected String m_txType;
    protected String m_txPropagation;
    protected short m_accessLevel;
    protected boolean m_longLived;
    protected int m_txTimeout = -1;
    protected byte[] m_smallIcon;
    protected byte[] m_largeIcon;
    protected Layout m_layout;
    protected Fault[] m_faults;
    protected static final InputParameter[] EMPTY_INPUT_PARAMETER_ARRAY = new InputParameter[0];
    protected static final OutputParameter[] EMPTY_OUTPUT_PARAMETER_ARRAY = new OutputParameter[0];
    protected static final Fault[] EMPTY_FAULT_ARRAY = new Fault[0];

    public void setServiceConfiguration(ServiceConfiguration aOwner) {
        this.m_owningService = aOwner;
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.m_owningService;
    }

    public String getServiceId() {
        ServiceConfiguration _ds = this.getServiceConfiguration();
        if (_ds == null) {
            return null;
        }
        return _ds.getServiceId();
    }

    public void setName(String aName) {
        this.m_name = aName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setTitle(String aTitle) {
        this.m_title = aTitle;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setHint(String aHint) {
        this.m_hint = aHint;
    }

    public String getHint() {
        return this.m_hint;
    }

    public void setOrchestrateable(boolean aValue) {
        this.m_orchestrateable = aValue;
    }

    public boolean isOrchestrateable() {
        return this.m_orchestrateable;
    }

    public void setAnonymousAccess(boolean aValue) {
        this.m_anonymousAccess = aValue;
    }

    public boolean isAnonymousAccess() {
        return this.m_anonymousAccess;
    }

    public void setSupportedConnectorIds(String[] aSupportedConnectors) {
        this.m_supportedConnectorIds = aSupportedConnectors;
    }

    public String[] getSupportedConnectorIds() {
        return this.m_supportedConnectorIds;
    }

    public void setLongLived(boolean longLived) {
        this.m_longLived = longLived;
    }

    public boolean getLongLived() {
        return this.m_longLived;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setAccessLevel(short accessLevel) {
        this.m_accessLevel = accessLevel;
    }

    public short getAccessLevel() {
        return this.m_accessLevel;
    }

    public void setAttributes(Map aAttributes) {
        this.m_attrs = aAttributes;
    }

    public Map getAttributes() {
        if (this.m_attrs == null) {
            this.m_attrs = new HashMap();
        }
        return this.m_attrs;
    }

    public void setInputParameters(InputParameter[] aInputParameters) {
        this.m_inputDescriptors = aInputParameters;
    }

    public InputParameter getInputParameter(String aName) throws InputParameterNotFoundException {
        if (aName == null || this.m_inputDescriptors == null || this.m_inputDescriptors.length == 0) {
            throw new InputParameterNotFoundException(this.getServiceId(), this.getName(), aName);
        }
        for (int i = 0; i < this.m_inputDescriptors.length; ++i) {
            InputParameter _input = this.m_inputDescriptors[i];
            if (!_input.getName().equals(aName)) continue;
            return _input;
        }
        throw new InputParameterNotFoundException(this.getServiceId(), this.getName(), aName);
    }

    public InputParameter[] getInputParameters() {
        if (this.m_inputDescriptors == null) {
            return EMPTY_INPUT_PARAMETER_ARRAY;
        }
        return this.m_inputDescriptors;
    }

    public OutputParameter getOutputParameter(String aName) throws OutputParameterNotFoundException {
        if (aName == null || this.m_outputDescriptors == null || this.m_outputDescriptors.length == 0) {
            throw new OutputParameterNotFoundException(this.getServiceId(), this.getName(), aName);
        }
        for (int i = 0; i < this.m_outputDescriptors.length; ++i) {
            OutputParameter _output = this.m_outputDescriptors[i];
            if (!_output.getName().equals(aName)) continue;
            return _output;
        }
        throw new OutputParameterNotFoundException(this.getServiceId(), this.getName(), aName);
    }

    public void setOutputParameters(OutputParameter[] aOutputParameters) {
        this.m_outputDescriptors = aOutputParameters;
    }

    public OutputParameter[] getOutputParameters() {
        if (this.m_outputDescriptors == null) {
            return EMPTY_OUTPUT_PARAMETER_ARRAY;
        }
        return this.m_outputDescriptors;
    }

    public void setTransactionType(String aTxType) {
        if (aTxType != null) {
            aTxType = aTxType.toUpperCase();
        }
        this.m_txType = aTxType;
    }

    public String getTransactionType() {
        if (TextUtil.isEmpty(this.m_txType)) {
            return "CONTAINER";
        }
        return this.m_txType;
    }

    public void setTransactionPropagation(String aTxPropagation) {
        if (aTxPropagation != null) {
            aTxPropagation = aTxPropagation.toUpperCase();
        }
        this.m_txPropagation = aTxPropagation;
    }

    public String getTransactionPropagation() {
        if (TextUtil.isEmpty(this.m_txPropagation)) {
            return "SUPPORTS";
        }
        return this.m_txPropagation;
    }

    public void setTransactionTimeout(int aTimeout) {
        this.m_txTimeout = aTimeout;
    }

    public int getTransactionTimeout() {
        return this.m_txTimeout;
    }

    public byte[] getSmallIcon() {
        return this.m_smallIcon;
    }

    public void setSmallIcon(byte[] smallIcon) {
        this.m_smallIcon = smallIcon;
    }

    public byte[] getLargeIcon() {
        return this.m_largeIcon;
    }

    public void setLargeIcon(byte[] largeIcon) {
        this.m_largeIcon = largeIcon;
    }

    public void setLayout(Layout aLayout) {
        this.m_layout = aLayout;
    }

    public Layout getLayout() {
        return this.m_layout;
    }

    public void setFaults(Fault[] aFaults) {
        this.m_faults = aFaults;
    }

    public Fault[] getFaults() {
        if (this.m_faults == null) {
            return EMPTY_FAULT_ARRAY;
        }
        return this.m_faults;
    }
}

