/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.infomodel.impl;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.registry.infomodel.DataType;
import com.adobe.idp.dsc.registry.infomodel.PropertyEditor;
import com.adobe.idp.dsc.registry.infomodel.impl.PropertyEditorImpl;
import com.adobe.idp.dsc.util.DOMUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class DataTypeImpl
implements DataType,
Serializable {
    static final long serialVersionUID = 5716993558806901116L;
    protected long m_oid;
    protected long m_archiveId;
    protected String m_id;
    protected String m_title;
    protected int m_majorVersion;
    protected int m_minorVersion;
    protected String m_javaClass;
    protected String m_description;
    protected String m_hint;
    protected String m_componentId;
    protected String m_componentVersion;
    protected String m_descriptor;
    protected boolean m_isStandard;
    protected boolean m_isCollection;
    protected boolean m_isMap;
    protected Date m_createTime;
    protected Date m_updateTime;
    protected PropertyEditor m_editor;
    protected boolean m_updateDescriptor = false;
    private static final String ELM_DATA_TYPE = "data-type";
    private static final String ATTR_DATA_TYPE_ID = "id";
    private static final String ATTR_DATA_TYPE_TITLE = "title";
    private static final String ATTR_DATA_TYPE_STANDARD = "standard";
    private static final String ATTR_DATA_TYPE_JAVA_CLASS = "java-class";
    private static final String ELM_DATA_TYPE_DESCRIPTION = "description";
    private static final String ELM_DATA_TYPE_HINT = "hint";
    private static final String ELM_PROPERTY_EDITOR = "property-editor";
    private static final String ATTR_PROPERTY_EDITOR_ID = "editor-id";
    private static final String ELM_PARAMETER = "parameter";
    private static final String ATTR_PARAMETER_NAME = "name";
    private static final String ATTR_PARAMETER_VALUE = "value";

    public DataTypeImpl() {
    }

    public DataTypeImpl(Element aDescriptor) {
        this.processDescriptor(aDescriptor);
    }

    public void setId(String aId) {
        this.m_id = aId;
        this.m_updateDescriptor = true;
    }

    public String getId() {
        return this.m_id;
    }

    public void setMajorVersion(int aMajorVersion) {
        this.m_majorVersion = aMajorVersion;
        this.m_updateDescriptor = true;
    }

    public int getMajorVersion() {
        return this.m_majorVersion;
    }

    public void setMinorVersion(int aMinorVersion) {
        this.m_minorVersion = aMinorVersion;
        this.m_updateDescriptor = true;
    }

    public int getMinorVersion() {
        return this.m_minorVersion;
    }

    public void setStandard(boolean aVal) {
        this.m_isStandard = aVal;
        this.m_updateDescriptor = true;
    }

    public boolean isStandard() {
        return this.m_isStandard;
    }

    public void setClassName(String aClass) {
        this.m_javaClass = aClass;
        this.m_updateDescriptor = true;
    }

    public String getClassName() {
        if (TextUtil.isEmpty(this.m_javaClass)) {
            return this.m_id;
        }
        return this.m_javaClass;
    }

    public void setTitle(String aTitle) {
        this.m_title = aTitle;
        this.m_updateDescriptor = true;
    }

    public String getTitle() {
        if (TextUtil.isEmpty(this.m_title)) {
            return this.getId();
        }
        return this.m_title;
    }

    public void setDescription(String aDesc) {
        this.m_description = aDesc;
        this.m_updateDescriptor = true;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setHint(String aHint) {
        this.m_hint = aHint;
        this.m_updateDescriptor = true;
    }

    public String getHint() {
        return this.m_hint;
    }

    public String getComponentId() {
        return this.m_componentId;
    }

    public void setComponentId(String aComponentId) {
        this.m_componentId = aComponentId;
    }

    public void setComponentVersion(String aVersion) {
        this.m_componentVersion = aVersion;
    }

    public String getComponentVersion() {
        return this.m_componentVersion;
    }

    public void setDescriptor(String aDescriptor) {
        try {
            Document _doc = DOMUtil.parseDocumentFromString(aDescriptor);
            if (_doc != null && _doc.getDocumentElement() != null) {
                this.processDescriptor(_doc.getDocumentElement());
            }
        }
        catch (ParserConfigurationException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (SAXException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public String getDescriptor() {
        if (this.m_updateDescriptor) {
            try {
                Document doc = null;
                Element rootElm = null;
                if (TextUtil.isEmpty(this.m_descriptor)) {
                    doc = DOMUtil.newDocument();
                    rootElm = doc.createElement(ELM_DATA_TYPE);
                    doc.appendChild(rootElm);
                } else {
                    doc = DOMUtil.parseDocumentFromString(this.m_descriptor);
                    rootElm = doc.getDocumentElement();
                }
                rootElm.setAttribute(ATTR_DATA_TYPE_ID, this.getId());
                rootElm.setAttribute(ATTR_DATA_TYPE_TITLE, this.getTitle());
                rootElm.setAttribute(ATTR_DATA_TYPE_STANDARD, Boolean.toString(this.isStandard()));
                rootElm.setAttribute(ATTR_DATA_TYPE_JAVA_CLASS, this.getClassName());
                Element childElm = DOMUtil.getChildElement(rootElm, ELM_DATA_TYPE_DESCRIPTION);
                if (childElm == null) {
                    childElm = doc.createElement(ELM_DATA_TYPE_DESCRIPTION);
                    rootElm.appendChild(childElm);
                }
                DOMUtil.setNodeText(childElm, this.getDescription());
                childElm = DOMUtil.getChildElement(rootElm, ELM_DATA_TYPE_HINT);
                if (childElm == null) {
                    childElm = doc.createElement(ELM_DATA_TYPE_HINT);
                    rootElm.appendChild(childElm);
                }
                DOMUtil.setNodeText(childElm, this.getHint());
                childElm = DOMUtil.getChildElement(rootElm, ELM_PROPERTY_EDITOR);
                if (childElm != null) {
                    rootElm.removeChild(childElm);
                }
                if (this.getPropertyEditor() != null && !TextUtil.isEmpty(this.getPropertyEditor().getEditorId())) {
                    childElm = doc.createElement(ELM_PROPERTY_EDITOR);
                    childElm.setAttribute(ATTR_PROPERTY_EDITOR_ID, this.getPropertyEditor().getEditorId());
                    Map _params = this.getPropertyEditor().getParameters();
                    for (String _key : _params.keySet()) {
                        String _val = (String)_params.get(_key);
                        Element paramElm = doc.createElement(ELM_PARAMETER);
                        paramElm.setAttribute(ATTR_PARAMETER_NAME, _key);
                        paramElm.setAttribute(ATTR_PARAMETER_VALUE, _val);
                        childElm.appendChild(paramElm);
                    }
                    rootElm.appendChild(childElm);
                }
                this.m_descriptor = DOMUtil.toString(doc);
                this.m_updateDescriptor = false;
            }
            catch (ParserConfigurationException ex) {
                throw new DSCRuntimeException(ex);
            }
            catch (SAXException ex) {
                throw new DSCRuntimeException(ex);
            }
        }
        return this.m_descriptor;
    }

    public void setOid(long aOid) {
        this.m_oid = aOid;
    }

    public long getOid() {
        return this.m_oid;
    }

    public void setArchiveId(long aId) {
        this.m_archiveId = aId;
    }

    public long getArchiveId() {
        return this.m_archiveId;
    }

    public void setMap(boolean aVal) {
        this.m_isMap = aVal;
    }

    public boolean isMap() {
        return this.m_isMap;
    }

    public void setList(boolean aVal) {
        this.m_isCollection = aVal;
    }

    public boolean isList() {
        return this.m_isCollection;
    }

    protected void processDescriptor(Element aDescriptor) {
        this.m_id = DOMUtil.getRequiredTextForAttr(aDescriptor, ATTR_DATA_TYPE_ID).trim();
        this.m_title = TextUtil.trim(aDescriptor.getAttribute(ATTR_DATA_TYPE_TITLE));
        this.m_description = DOMUtil.getTextForChild(aDescriptor, ELM_DATA_TYPE_DESCRIPTION);
        this.m_hint = DOMUtil.getTextForChild(aDescriptor, ELM_DATA_TYPE_HINT);
        this.m_isStandard = DOMUtil.getBooleanForAttr(aDescriptor, ATTR_DATA_TYPE_STANDARD);
        this.m_javaClass = TextUtil.trim(aDescriptor.getAttribute(ATTR_DATA_TYPE_JAVA_CLASS));
        Element _editorElm = DOMUtil.getChildElement(aDescriptor, ELM_PROPERTY_EDITOR);
        PropertyEditorImpl _editor = new PropertyEditorImpl();
        if (_editorElm != null) {
            _editor.setEditorId(TextUtil.trim(DOMUtil.getRequiredTextForAttr(_editorElm, ATTR_PROPERTY_EDITOR_ID)));
            Element[] _propertyEditorParamElms = DOMUtil.getChildElements(_editorElm, ELM_PARAMETER);
            if (_propertyEditorParamElms != null && _propertyEditorParamElms.length > 0) {
                HashMap<String, String> _propertyEditorParams = new HashMap<String, String>();
                for (Element _propertyEditorParamElm : _propertyEditorParamElms) {
                    String _name = TextUtil.trim(_propertyEditorParamElm.getAttribute(ATTR_PARAMETER_NAME));
                    String _value = _propertyEditorParamElm.getAttribute(ATTR_PARAMETER_VALUE);
                    if (TextUtil.isEmpty(_name)) continue;
                    _propertyEditorParams.put(_name, _value);
                }
                _editor.setParameters(_propertyEditorParams);
            }
        }
        this.m_editor = _editor;
        this.m_descriptor = DOMUtil.toString(aDescriptor);
        this.m_updateDescriptor = false;
    }

    public void setUpdateTime(Date aTime) {
        this.m_updateTime = aTime;
    }

    public Date getUpdateTime() {
        return this.m_updateTime;
    }

    public void setCreateTime(Date aTime) {
        this.m_createTime = aTime;
    }

    public Date getCreateTime() {
        return this.m_createTime;
    }

    public PropertyEditor getPropertyEditor() {
        return this.m_editor;
    }

    public void setPropertyEditor(PropertyEditor aEditor) {
        this.m_editor = aEditor;
        this.m_updateDescriptor = true;
    }
}

