/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.infomodel.impl;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.component.impl.DefaultPOJODescriptorImpl;
import com.adobe.idp.dsc.component.impl.DefaultPOJOInvokerImpl;
import com.adobe.idp.dsc.registry.infomodel.Component;
import com.adobe.idp.dsc.registry.infomodel.DataType;
import com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent;
import com.adobe.idp.dsc.registry.infomodel.impl.CompositeEditorComponentImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.DataTypeImpl;
import com.adobe.idp.dsc.registry.infomodel.impl.PropertyEditorComponentImpl;
import com.adobe.idp.dsc.util.DOMUtil;
import com.adobe.idp.dsc.util.IOUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ComponentImpl
implements Component,
Serializable,
Cloneable {
    static final long serialVersionUID = -2304216441929499210L;
    public static final String COMPONENT_XML = "component.xml";
    protected static final String SUPPORTS_EXPORT_ELM = "supports-export";
    protected static final String SERVICES_ELM = "services";
    protected static final String SERVICE_ELM = "service";
    protected static final String NAME_ATTR = "name";
    public static final Logger log = Logger.getLogger(ComponentImpl.class.getName());
    protected long m_oid;
    protected String m_componentId;
    protected String m_bootstrapClass;
    protected String m_lifeCycleClass;
    protected String m_serviceLifeCycleClass;
    protected String m_loadClass;
    protected String m_descriptorClass;
    protected String m_invokerClass;
    protected String m_version;
    protected String m_classPath;
    protected String m_serviceDeployerClass;
    protected String m_descriptor;
    protected transient Document m_descriptorDOM = null;
    protected int m_state = -1;
    protected static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    protected PropertyEditorComponent[] m_editorComponents;
    protected DataType[] m_dataTypes;
    protected Object[][] m_staticImports = null;
    protected Object[][] m_exports = null;
    protected Object[][] m_dynamicImports = null;
    protected boolean m_dynamic_import = false;
    protected String m_classLoadPolicy = null;
    protected String m_searchOrder = null;
    protected long m_archiveId;
    protected Date m_updateTime;
    protected Date m_createTime;
    protected String m_serviceFactoryClass;
    protected String m_serviceFactoryAccessorMethod;
    protected String m_clientClassPath;

    public ComponentImpl() {
    }

    public ComponentImpl(String componentDescriptor) {
        this.setDescriptor(componentDescriptor);
    }

    public void setOid(long aValue) {
        this.m_oid = aValue;
    }

    public long getOid() {
        return this.m_oid;
    }

    public String getComponentId() {
        return this.m_componentId;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setDescriptor(String aDescriptor) {
        this.m_descriptor = aDescriptor;
        this.processDescriptor();
    }

    public String getDescriptor() {
        return this.m_descriptor;
    }

    public void setClassPath(String aClassPath) {
        this.m_classPath = aClassPath;
    }

    public String getClassPath() {
        return this.m_classPath;
    }

    public int getState() {
        return this.m_state;
    }

    public void setState(int aState) {
        this.m_state = aState;
    }

    public String getBootstrapClass() {
        return this.m_bootstrapClass;
    }

    public String getLifeCycleClass() {
        return this.m_lifeCycleClass;
    }

    public String getServiceDeployerClass() {
        return this.m_serviceDeployerClass;
    }

    public String getServiceLifeCycleClass() {
        return this.m_serviceLifeCycleClass;
    }

    public String getDescriptorClass() {
        if (TextUtil.isEmpty(this.m_descriptorClass)) {
            this.m_descriptorClass = DefaultPOJODescriptorImpl.class.getName();
        }
        return this.m_descriptorClass;
    }

    public String getInvokerClass() {
        if (TextUtil.isEmpty(this.m_invokerClass)) {
            this.m_invokerClass = DefaultPOJOInvokerImpl.class.getName();
        }
        return this.m_invokerClass;
    }

    public Document getComponentDescriptor() {
        if (this.m_descriptorDOM == null) {
            try {
                this.m_descriptorDOM = DOMUtil.parseDocumentFromString(this.m_descriptor);
            }
            catch (Exception ex) {
                throw new DSCRuntimeException(ex);
            }
        }
        return this.m_descriptorDOM;
    }

    public Element getServiceDescriptor(String aServiceName) {
        Document _compDesc = this.getComponentDescriptor();
        Element _servicesElm = DOMUtil.getChildElement(_compDesc.getDocumentElement(), SERVICES_ELM);
        Element _serviceElm = null;
        if (_servicesElm != null && !TextUtil.isEmpty(aServiceName)) {
            Element[] _serviceElms = DOMUtil.getChildElements(_servicesElm, SERVICE_ELM);
            for (int i = 0; i < _serviceElms.length; ++i) {
                String _name = DOMUtil.getTextForNode(_serviceElms[i].getAttributeNode(NAME_ATTR));
                if (!_name.equals(aServiceName)) continue;
                _serviceElm = _serviceElms[i];
                break;
            }
        }
        return _serviceElm;
    }

    public Element[] getServiceDescriptors() {
        Document _compDesc = this.getComponentDescriptor();
        Element _servicesElm = DOMUtil.getChildElement(_compDesc.getDocumentElement(), SERVICES_ELM);
        if (_servicesElm != null) {
            return DOMUtil.getChildElements(_servicesElm, SERVICE_ELM);
        }
        return EMPTY_ELEMENT_ARRAY;
    }

    private void processDescriptor() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "processing descriptor for component " + this.m_componentId);
        }
        try {
            Element[] _datatypeElms;
            Date _initTime = new Date(System.currentTimeMillis());
            Document _doc = this.getComponentDescriptor();
            Element _root = _doc.getDocumentElement();
            this.m_componentId = DOMUtil.getRequiredTextForChild(_root, "component-id").trim();
            this.m_version = DOMUtil.getRequiredTextForChild(_root, "version").trim();
            this.m_bootstrapClass = TextUtil.trim(DOMUtil.getTextForChild(_root, "bootstrap-class"));
            this.m_lifeCycleClass = TextUtil.trim(DOMUtil.getTextForChild(_root, "lifecycle-class"));
            this.m_loadClass = TextUtil.trim(DOMUtil.getTextForChild(_root, "load-class"));
            this.m_descriptorClass = TextUtil.trim(DOMUtil.getTextForChild(_root, "descriptor-class"));
            this.m_invokerClass = TextUtil.trim(DOMUtil.getTextForChild(_root, "invoker-class"));
            this.m_serviceLifeCycleClass = TextUtil.trim(DOMUtil.getTextForChild(_root, "service-lifecycle-class"));
            this.m_serviceDeployerClass = TextUtil.trim(DOMUtil.getTextForChild(_root, "service-deployer-class"));
            this.m_classPath = TextUtil.trim(DOMUtil.getTextForChild(_root, "class-path"));
            this.m_clientClassPath = DOMUtil.toString(DOMUtil.getChildElement(_root, "client-class-path"));
            Element _serviceFactory = DOMUtil.getChildElement(_root, "service-factory-class");
            if (_serviceFactory != null) {
                this.m_serviceFactoryAccessorMethod = DOMUtil.getAttributeValue(_serviceFactory, "static-singleton-accessor-method");
                this.m_serviceFactoryClass = TextUtil.trim(DOMUtil.getTextForNode(_serviceFactory));
            }
            ArrayList<PropertyEditorComponentImpl> _editors = new ArrayList<PropertyEditorComponentImpl>();
            Element editorsElm = DOMUtil.getChildElement(_root, "editors");
            if (editorsElm != null) {
                Element[] compositeEditorElms;
                Element[] editors = DOMUtil.getChildElements(editorsElm, "editor");
                if (editors.length > 0) {
                    for (int i = 0; i < editors.length; ++i) {
                        Element _editor = editors[i];
                        PropertyEditorComponentImpl _comp = null;
                        _comp = new PropertyEditorComponentImpl();
                        _comp.setId(TextUtil.trim(DOMUtil.getAttributeValue(_editor, "id")));
                        _comp.setDescription(DOMUtil.getTextForChild(_editor, "description"));
                        _comp.setSerializerClass(TextUtil.trim(DOMUtil.getTextForChild(_editor, "serializer-class")));
                        _comp.setConverterClass(TextUtil.trim(DOMUtil.getTextForChild(_editor, "converter-class")));
                        _comp.setConfigurationType(TextUtil.trim(DOMUtil.getTextForChild(_editor, "configuration-type")));
                        Element[] _implementationElms = DOMUtil.getChildElements(_editor, "ui-component-class");
                        HashMap<String, String> _implementationClasses = new HashMap<String, String>(_implementationElms.length);
                        for (int x = 0; x < _implementationElms.length; ++x) {
                            String _type = TextUtil.trim(DOMUtil.getAttributeValue(_implementationElms[x], "type"));
                            String _class = TextUtil.trim(DOMUtil.getTextForNode(_implementationElms[x]));
                            if (TextUtil.isEmpty(_type) || TextUtil.isEmpty(_class)) continue;
                            _implementationClasses.put(_type, _class);
                        }
                        _comp.setUIComponentClasses(_implementationClasses);
                        _comp.setDescriptor(DOMUtil.toString(_root));
                        _comp.setComponentId(this.getComponentId());
                        _comp.setComponentVersion(this.getVersion());
                        _comp.setArchiveId(this.getArchiveId());
                        _comp.setUpdateTime(_initTime);
                        _editors.add(_comp);
                    }
                }
                if ((compositeEditorElms = DOMUtil.getChildElements(editorsElm, "composite-editor")).length > 0) {
                    for (int i = 0; i < compositeEditorElms.length; ++i) {
                        Element compositeEditorElm = compositeEditorElms[i];
                        CompositeEditorComponentImpl _comp = null;
                        _comp = new CompositeEditorComponentImpl();
                        _comp.setComponentId(this.getComponentId());
                        _comp.setComponentVersion(this.getVersion());
                        _comp.setArchiveId(this.getArchiveId());
                        _comp.setId(TextUtil.trim(DOMUtil.getAttributeValue(_root, "id")));
                        _comp.setDescription(DOMUtil.getTextForChild(compositeEditorElm, "description"));
                        _comp.setConverterClass(TextUtil.trim(DOMUtil.getTextForChild(compositeEditorElm, "converter-class")));
                        _comp.setCompositeType(TextUtil.trim(DOMUtil.getTextForChild(compositeEditorElm, "composite-type")));
                        _comp.setDescriptor(DOMUtil.toString(compositeEditorElm));
                        _comp.setUpdateTime(_initTime);
                        _editors.add(_comp);
                    }
                }
            }
            this.m_editorComponents = new PropertyEditorComponent[_editors.size()];
            _editors.toArray(this.m_editorComponents);
            ArrayList<DataTypeImpl> _dataTypes = new ArrayList<DataTypeImpl>();
            Element _dataTypesElm = DOMUtil.getChildElement(_root, "data-types");
            if (_dataTypesElm != null && (_datatypeElms = DOMUtil.getChildElements(_dataTypesElm, "data-type")).length > 0) {
                for (int i = 0; i < _datatypeElms.length; ++i) {
                    Element _datatypeElm = _datatypeElms[i];
                    DataTypeImpl _dt = null;
                    _dt = new DataTypeImpl(_datatypeElm);
                    _dt.setComponentId(this.getComponentId());
                    _dt.setComponentVersion(this.getVersion());
                    _dt.setArchiveId(this.getArchiveId());
                    _dt.setUpdateTime(_initTime);
                    _dataTypes.add(_dt);
                }
            }
            this.m_dataTypes = new DataType[_dataTypes.size()];
            _dataTypes.toArray(this.m_dataTypes);
            this.m_staticImports = this.loadLibraryDependencies(_doc, "import-packages");
            if (this.m_staticImports == null && log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "I M P O R T     P A C K A G E S     A R E    N U L L   F O R " + this.m_componentId);
            }
            this.m_dynamicImports = this.loadLibraryDependencies(_doc, "dynamic-import-packages");
            if (this.m_dynamicImports == null && log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "D Y N - E X P O R T     P A C K A G E S     A R E    N U L L  F O R " + this.m_componentId);
            }
            this.m_exports = this.loadLibraryDependencies(_doc, "export-packages");
            if (this.m_exports == null && log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "E X P O R T     P A C K A G E S     A R E    N U L L   F O R " + this.m_componentId);
            }
            this.m_searchOrder = DOMUtil.getTextForChild(_root, "search-order");
            if (this.m_searchOrder == null) {
                this.m_searchOrder = "PARENT_FIRST";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }

    private Object[][] loadLibraryDependencies(Document _doc, String libraryType) {
        Object[][] _importLibs = null;
        boolean hasChild = DOMUtil.hasChild(_doc.getDocumentElement(), libraryType);
        if (hasChild) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "F O U N D    C H I L D   " + libraryType);
            }
            Element _import = DOMUtil.getChildElement(_doc.getDocumentElement(), libraryType);
            Element[] _packages = DOMUtil.getChildElements(_import, "package");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "F O U N D    P A C K A G E S     C O U N T     = " + _packages.length);
            }
            if (_packages != null && _packages.length > 0) {
                _importLibs = new Object[_packages.length][_packages.length * 4];
                int j = 0;
                int k = 0;
                for (int i = 0; i < _packages.length; ++i) {
                    Element _package = _packages[i];
                    String _packageName = DOMUtil.getTextForNode(_package);
                    String _packageVersion = DOMUtil.getAttributeValue(_package, "version");
                    if (_packageVersion == null || _packageVersion.trim().length() == 0) {
                        _packageVersion = "1.0";
                    }
                    String isOptional = DOMUtil.getAttributeValue(_package, "isOptional");
                    _importLibs[j][k] = _packageName;
                    _importLibs[j][k + 1] = _packageVersion;
                    if (isOptional == null) {
                        isOptional = "false";
                    } else if (isOptional.trim().length() == 0) {
                        isOptional = "true";
                    }
                    _importLibs[j][k + 2] = isOptional;
                    ++j;
                    k = 0;
                }
            }
        }
        return _importLibs;
    }

    public Object[][] getImports() {
        return this.m_staticImports;
    }

    public Object[][] getDynamicImports() {
        return this.m_dynamicImports;
    }

    public Object[][] getExports() {
        return this.m_exports;
    }

    public String getSearchOrder() {
        return this.m_searchOrder;
    }

    public boolean getSupportsExport() {
        Document componentDescriptor = this.getComponentDescriptor();
        Element supportsExportElement = DOMUtil.getChildElement(componentDescriptor.getDocumentElement(), SUPPORTS_EXPORT_ELM);
        if (supportsExportElement == null) {
            return true;
        }
        return Boolean.parseBoolean(DOMUtil.getTextForNode(supportsExportElement));
    }

    public long getArchiveId() {
        return this.m_archiveId;
    }

    public void setArchiveId(long aId) {
        this.m_archiveId = aId;
    }

    public PropertyEditorComponent[] getPropertyEditors() {
        return this.m_editorComponents;
    }

    public DataType[] getDataTypes() {
        return this.m_dataTypes;
    }

    public void setUpdateTime(Date aTime) {
        this.m_updateTime = aTime;
    }

    public Date getUpdateTime() {
        return this.m_updateTime;
    }

    public void setCreateTime(Date aCreateTime) {
        this.m_createTime = aCreateTime;
    }

    public Date getCreateTime() {
        return this.m_createTime;
    }

    public String getLoadClass() {
        return this.m_loadClass;
    }

    public void setLoadClass(String aLoadClass) {
        this.m_loadClass = aLoadClass;
    }

    public Object clone() {
        byte[] _buff = IOUtil.writeObject2ByteArray(this);
        return IOUtil.readObjectFromByteArray(_buff);
    }

    public String getServiceFactoryClass() {
        return this.m_serviceFactoryClass;
    }

    public String getServiceFactoryAccessorMethod() {
        return this.m_serviceFactoryAccessorMethod;
    }

    public String getClientClassPathAsString() {
        return this.m_clientClassPath;
    }
}

