/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.endpoint.client;

import com.adobe.idp.dsc.DSCInvocationException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.filter.PagingFilter;
import com.adobe.idp.dsc.registry.EndpointCategoryInUseException;
import com.adobe.idp.dsc.registry.EndpointCategoryNotFoundException;
import com.adobe.idp.dsc.registry.EndpointNotFoundException;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.endpoint.CreateEndpointCategoryInfo;
import com.adobe.idp.dsc.registry.endpoint.CreateEndpointInfo;
import com.adobe.idp.dsc.registry.endpoint.EndpointRegistry;
import com.adobe.idp.dsc.registry.endpoint.EndpointStoreException;
import com.adobe.idp.dsc.registry.endpoint.ModifyEndpointCategoryInfo;
import com.adobe.idp.dsc.registry.endpoint.ModifyEndpointInfo;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import com.adobe.idp.dsc.registry.infomodel.EndpointCategory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class EndpointRegistryClient
implements EndpointRegistry {
    private ServiceClientFactory m_serviceClientFactory;
    private static final String m_serviceName = "system.endpoint_registry";

    public EndpointRegistryClient(ServiceClientFactory clientServiceFactory) {
        if (clientServiceFactory == null) {
            throw new IllegalArgumentException("clientServiceFacory can not be null");
        }
        this.m_serviceClientFactory = clientServiceFactory;
    }

    public List getEndpoints(PagingFilter aFilter) {
        try {
            Object obj;
            HashMap<String, PagingFilter> input = new HashMap<String, PagingFilter>(1);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("getEndpoints", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof List) {
                return (List)obj;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public EndpointCategory createEndpointCategory(CreateEndpointCategoryInfo aInfo) throws RegistryException {
        try {
            Object obj;
            HashMap<String, CreateEndpointCategoryInfo> input = new HashMap<String, CreateEndpointCategoryInfo>(1);
            input.put("category-info", aInfo);
            InvocationResponse response = this.invoke("createEndpointCategory", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof EndpointCategory) {
                return (EndpointCategory)obj;
            }
            return null;
        }
        catch (RegistryException ex) {
            throw ex;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getEndpointCategories(PagingFilter aFilter) {
        try {
            Object obj;
            HashMap<String, PagingFilter> input = new HashMap<String, PagingFilter>(1);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("getEndpointCategories", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof List) {
                return (List)obj;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public EndpointCategory getEndpointCategory(String aId) throws EndpointCategoryNotFoundException {
        try {
            Object obj;
            HashMap<String, String> input = new HashMap<String, String>();
            input.put("id", aId);
            InvocationResponse response = this.invoke("getEndpointCategory", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof EndpointCategory) {
                return (EndpointCategory)obj;
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof EndpointCategoryNotFoundException) {
                throw (EndpointCategoryNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (EndpointCategoryNotFoundException ex) {
            throw ex;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void removeEndpointCategory(EndpointCategory aCategory) throws EndpointCategoryInUseException {
        try {
            HashMap<String, EndpointCategory> input = new HashMap<String, EndpointCategory>();
            input.put("category", aCategory);
            this.invoke("removeEndpointCategory", input);
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof EndpointCategoryInUseException) {
                throw (EndpointCategoryInUseException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (EndpointCategoryInUseException ex) {
            throw ex;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public EndpointCategory modifyEndpointCategory(ModifyEndpointCategoryInfo aInfo) throws RegistryException {
        try {
            Object obj;
            HashMap<String, ModifyEndpointCategoryInfo> input = new HashMap<String, ModifyEndpointCategoryInfo>();
            input.put("category-info", aInfo);
            InvocationResponse response = this.invoke("modifyEndpointCategory", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof EndpointCategory) {
                return (EndpointCategory)obj;
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (RegistryException ex) {
            throw ex;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getEndpointsByCategory(List aCategories, PagingFilter aFilter) {
        try {
            Object obj;
            HashMap<String, Object> input = new HashMap<String, Object>(2);
            input.put("categories", aCategories);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("getEndpointsByCategory", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof List) {
                return (List)obj;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getConnectorEndpoints(String aConnectorName, List aCategories, PagingFilter aFilter) {
        try {
            Object obj;
            HashMap<String, Object> input = new HashMap<String, Object>(2);
            input.put("connector-name", aConnectorName);
            input.put("categories", aCategories);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("getConnectorEndpoints", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof List) {
                return (List)obj;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getServiceEndpoints(String aServiceId, List aCategories, PagingFilter aFilter) {
        try {
            Object obj;
            HashMap<String, Object> input = new HashMap<String, Object>(2);
            input.put("service-id", aServiceId);
            input.put("categories", aCategories);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("getServiceEndpoints", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof List) {
                return (List)obj;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Endpoint getEndpoint(long aEndpointId) throws EndpointNotFoundException {
        try {
            Object obj;
            HashMap<String, Long> input = new HashMap<String, Long>(2);
            input.put("endpoint-id", new Long(aEndpointId));
            InvocationResponse response = this.invoke("getEndpoint", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof Endpoint) {
                return (Endpoint)obj;
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof EndpointNotFoundException) {
                throw (EndpointNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (EndpointNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Endpoint createEndpoint(CreateEndpointInfo aInfo) throws RegistryException {
        try {
            Object obj;
            HashMap<String, CreateEndpointInfo> input = new HashMap<String, CreateEndpointInfo>(1);
            input.put("endpoint-info", aInfo);
            InvocationResponse response = this.invoke("createEndpoint", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof Endpoint) {
                return (Endpoint)obj;
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DSCRuntimeException(e);
        }
    }

    public Endpoint modifyEndpoint(ModifyEndpointInfo aInfo) throws RegistryException {
        try {
            Object obj;
            HashMap<String, ModifyEndpointInfo> input = new HashMap<String, ModifyEndpointInfo>(1);
            input.put("endpoint-info", aInfo);
            InvocationResponse response = this.invoke("modifyEndpoint", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof Endpoint) {
                return (Endpoint)obj;
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void remove(Endpoint aEndpoint) {
        try {
            HashMap<String, Endpoint> input = new HashMap<String, Endpoint>(1);
            input.put("endpoint", aEndpoint);
            this.invoke("remove", input);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new EndpointStoreException(ex);
        }
    }

    public Endpoint enable(Endpoint aEndpoint) throws EndpointNotFoundException {
        try {
            Object obj;
            HashMap<String, Endpoint> input = new HashMap<String, Endpoint>(1);
            input.put("endpoint", aEndpoint);
            InvocationResponse response = this.invoke("enable", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof Endpoint) {
                return (Endpoint)obj;
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof EndpointNotFoundException) {
                throw (EndpointNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (EndpointNotFoundException e) {
            throw e;
        }
        catch (DSCRuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new EndpointStoreException(ex);
        }
    }

    public Endpoint disable(Endpoint aEndpoint) throws EndpointNotFoundException {
        try {
            Object obj;
            HashMap<String, Endpoint> input = new HashMap<String, Endpoint>(1);
            input.put("endpoint", aEndpoint);
            InvocationResponse response = this.invoke("disable", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof Endpoint) {
                return (Endpoint)obj;
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof EndpointNotFoundException) {
                throw (EndpointNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (EndpointNotFoundException e) {
            throw e;
        }
        catch (DSCRuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new EndpointStoreException(ex);
        }
    }

    public List getEndpointsBySearchFilter(PagingFilter aFilter) {
        try {
            Object obj;
            HashMap<String, PagingFilter> input = new HashMap<String, PagingFilter>(1);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("getEndpointsBySearchFilter", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof List) {
                return (List)obj;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List adminGetEndpointsBySearchFilter(PagingFilter aFilter) {
        try {
            Object obj;
            HashMap<String, PagingFilter> input = new HashMap<String, PagingFilter>(1);
            input.put("filter", aFilter);
            InvocationResponse response = this.invoke("adminGetEndpointsBySearchFilter", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof List) {
                return (List)obj;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    private InvocationResponse invoke(String operationName, HashMap input) throws Exception {
        InvocationRequest request = this.m_serviceClientFactory.createInvocationRequest(m_serviceName, operationName, input, true);
        return this.m_serviceClientFactory.getServiceClient().invoke(request);
    }

    public List getServiceConnectorEndpoints(String aServiceId, String aOperationName, String aConnectorId, PagingFilter aPagingFilter) {
        try {
            Object obj;
            HashMap<String, Object> input = new HashMap<String, Object>(4);
            input.put("service-id", aServiceId);
            input.put("operation-name", aOperationName);
            input.put("connector-id", aConnectorId);
            input.put("filter", aPagingFilter);
            InvocationResponse response = this.invoke("getServiceConnectorEndpoints", input);
            Iterator iterator = response.getOutputParameters().values().iterator();
            if (iterator.hasNext() && (obj = iterator.next()) instanceof List) {
                return (List)obj;
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }
}

