/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.endpoint;

import com.adobe.idp.dsc.filter.PagingFilter;
import com.adobe.idp.dsc.registry.EndpointCategoryInUseException;
import com.adobe.idp.dsc.registry.EndpointCategoryNotFoundException;
import com.adobe.idp.dsc.registry.EndpointNotFoundException;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.endpoint.CreateEndpointCategoryInfo;
import com.adobe.idp.dsc.registry.endpoint.CreateEndpointInfo;
import com.adobe.idp.dsc.registry.endpoint.ModifyEndpointCategoryInfo;
import com.adobe.idp.dsc.registry.endpoint.ModifyEndpointInfo;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import com.adobe.idp.dsc.registry.infomodel.EndpointCategory;
import java.util.List;

public interface EndpointRegistry {
    public static final String SERVICE_ID = "system.endpoint_registry";
    public static final String ENDPOINT_UPDATE_EVENT = "onEndpointUpdate";
    public static final String ENDPOINT_CREATE_EVENT = "onEndpointCreate";
    public static final String ENDPOINT_DELETE_EVENT = "onEndpointDelete";
    public static final String ENDPOINT_PARAMETER = "endpoint";
    public static final String OLD_ENDPOINT_PARAMETER = "oldEndpoint";

    public EndpointCategory createEndpointCategory(CreateEndpointCategoryInfo var1) throws RegistryException;

    public List getEndpointCategories(PagingFilter var1);

    public EndpointCategory getEndpointCategory(String var1) throws EndpointCategoryNotFoundException;

    public void removeEndpointCategory(EndpointCategory var1) throws EndpointCategoryNotFoundException, EndpointCategoryInUseException;

    public EndpointCategory modifyEndpointCategory(ModifyEndpointCategoryInfo var1) throws RegistryException;

    public List getEndpoints(PagingFilter var1);

    public List getEndpointsByCategory(List var1, PagingFilter var2);

    public List getConnectorEndpoints(String var1, List var2, PagingFilter var3);

    public List getServiceEndpoints(String var1, List var2, PagingFilter var3);

    public List getServiceConnectorEndpoints(String var1, String var2, String var3, PagingFilter var4);

    public List getEndpointsBySearchFilter(PagingFilter var1);

    public Endpoint getEndpoint(long var1) throws EndpointNotFoundException;

    public Endpoint createEndpoint(CreateEndpointInfo var1) throws RegistryException;

    public Endpoint modifyEndpoint(ModifyEndpointInfo var1) throws RegistryException;

    public void remove(Endpoint var1) throws EndpointNotFoundException;

    public Endpoint enable(Endpoint var1) throws EndpointNotFoundException;

    public Endpoint disable(Endpoint var1) throws EndpointNotFoundException;

    public List adminGetEndpointsBySearchFilter(PagingFilter var1);
}

