/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.datatype.client;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCInvocationException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.registry.DataTypeNotFoundException;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.datatype.DataTypeRegistry;
import com.adobe.idp.dsc.registry.infomodel.DataType;
import com.adobe.idp.dsc.registry.infomodel.impl.ComponentImpl;
import com.adobe.idp.dsc.util.HashMapClassLoader;
import com.adobe.idp.dsc.util.IOUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataTypeRegistryClient
implements DataTypeRegistry {
    private ServiceClientFactory m_serviceClientFactory;
    private HashMap m_classLoaderCache;
    private static Map m_systemTypes;
    private boolean m_verifyCache;

    public DataTypeRegistryClient(ServiceClientFactory clientServiceFactory) {
        this(clientServiceFactory, true);
    }

    public DataTypeRegistryClient(ServiceClientFactory clientServiceFactory, boolean verifyCache) {
        this.m_serviceClientFactory = clientServiceFactory;
        this.m_verifyCache = verifyCache;
    }

    private static Map getSystemTypes() {
        if (m_systemTypes == null) {
            HashMap<String, DataType> _systemTypes = new HashMap<String, DataType>();
            try {
                ComponentImpl _systemComp = new ComponentImpl(new String(IOUtil.readByteArrayFromStream(DataTypeRegistryClient.class.getClassLoader().getResourceAsStream("com/adobe/idp/dsc/system/component.xml"))));
                DataType[] _dataTypes = _systemComp.getDataTypes();
                for (int i = 0; i < _dataTypes.length; ++i) {
                    DataType _dt = _dataTypes[i];
                    _systemTypes.put(_dt.getId(), _dt);
                }
                m_systemTypes = _systemTypes;
            }
            catch (IOException ex) {
                throw new DSCRuntimeException(ex);
            }
        }
        return m_systemTypes;
    }

    private static DataType getSystemType(String aId) {
        return (DataType)DataTypeRegistryClient.getSystemTypes().get(aId);
    }

    public void setServiceClientFactory(ServiceClientFactory aFactory) {
        this.m_serviceClientFactory = aFactory;
    }

    public List findDataTypesWithLikeId(String aId) {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("id", aId);
            InvocationResponse response = this.invoke("findDataTypesWithLikeId", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getDataTypes() {
        try {
            InvocationResponse response = this.invoke("getDataTypes", null);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getStandardDataTypes() {
        try {
            InvocationResponse response = this.invoke("getStandardDataTypes", null);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public DataType getDataType(String aId, int aMajorVersion, int aMinorVersion) throws DataTypeNotFoundException {
        DataType _dt = DataTypeRegistryClient.getSystemType(aId);
        if (_dt != null) {
            return _dt;
        }
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(3);
            input.put("id", aId);
            input.put("major-version", new Integer(aMajorVersion));
            input.put("minor-version", new Integer(aMinorVersion));
            InvocationResponse response = this.invoke("getDataType", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof DataType)) continue;
                return (DataType)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof DataTypeNotFoundException) {
                throw (DataTypeNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public DataType getHeadDataType(String aId) throws DataTypeNotFoundException {
        DataType _dt = DataTypeRegistryClient.getSystemType(aId);
        if (_dt != null) {
            return _dt;
        }
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("id", aId);
            InvocationResponse response = this.invoke("getHeadDataType", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof DataType)) continue;
                return (DataType)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof DataTypeNotFoundException) {
                throw (DataTypeNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Map getClientLibAsMap(String aDataTypeId, int aMajorVersion, int aMinorVersion) throws DataTypeNotFoundException {
        DataType _dt = DataTypeRegistryClient.getSystemType(aDataTypeId);
        if (_dt != null) {
            return Collections.EMPTY_MAP;
        }
        try {
            HashMap<String, Object> input = new HashMap<String, Object>(3);
            input.put("id", aDataTypeId);
            input.put("major-version", new Integer(aMajorVersion));
            input.put("minor-version", new Integer(aMinorVersion));
            InvocationResponse response = this.invoke("getClientLibAsMap", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Map)) continue;
                return (Map)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof DataTypeNotFoundException) {
                throw (DataTypeNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ClassLoader getClientClassLoader(ClassLoader aParent, String aDataTypeId) throws RegistryException {
        DataType _dt = this.getHeadDataType(aDataTypeId);
        StringBuffer _key = new StringBuffer(aDataTypeId);
        _key.append('.');
        _key.append(Integer.toString(_dt.getMajorVersion()));
        _key.append('.');
        _key.append(Integer.toString(_dt.getMinorVersion()));
        _key.append('.');
        _key.append(System.identityHashCode(aParent));
        HashMapClassLoader _cl = null;
        if (this.m_classLoaderCache == null) {
            this.m_classLoaderCache = new HashMap();
        } else {
            _cl = (HashMapClassLoader)this.m_classLoaderCache.get(_key.toString());
        }
        if (_cl != null && this.m_verifyCache && _dt.getUpdateTime().getTime() > _cl.getCreateTime().getTime()) {
            _cl = null;
        }
        if (_cl == null) {
            Map _map = this.getClientLibAsMap(aDataTypeId, _dt.getMajorVersion(), _dt.getMinorVersion());
            _cl = new HashMapClassLoader(_map, aParent);
            this.m_classLoaderCache.put(_key.toString(), _cl);
        }
        return _cl;
    }

    public ClassLoader getClientClassLoader(ClassLoader aParent, String aDataTypeId, int aMajorVersion, int aMinorVersion) throws RegistryException {
        DataType _dt;
        StringBuffer _key = new StringBuffer(aDataTypeId);
        _key.append('.');
        _key.append(Integer.toString(aMajorVersion));
        _key.append('.');
        _key.append(Integer.toString(aMinorVersion));
        _key.append('.');
        _key.append(System.identityHashCode(aParent));
        HashMapClassLoader _cl = null;
        if (this.m_classLoaderCache == null) {
            this.m_classLoaderCache = new HashMap();
        } else {
            _cl = (HashMapClassLoader)this.m_classLoaderCache.get(_key.toString());
        }
        if (_cl != null && this.m_verifyCache && (_dt = this.getDataType(aDataTypeId, aMajorVersion, aMinorVersion)).getUpdateTime().getTime() > _cl.getCreateTime().getTime()) {
            _cl = null;
        }
        if (_cl == null) {
            Map _map = this.getClientLibAsMap(aDataTypeId, aMajorVersion, aMinorVersion);
            _cl = new HashMapClassLoader(_map, aParent);
            this.m_classLoaderCache.put(_key.toString(), _cl);
        }
        return _cl;
    }

    private InvocationResponse invoke(String operationName, HashMap input) throws DSCException {
        InvocationRequest request = this.m_serviceClientFactory.createInvocationRequest("system.data_type_registry", operationName, input, true);
        return this.m_serviceClientFactory.getServiceClient().invoke(request);
    }
}

