/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.connector.client;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.registry.ConnectorNotFoundException;
import com.adobe.idp.dsc.registry.DuplicateConnectorException;
import com.adobe.idp.dsc.registry.connector.ConnectorRegistry;
import com.adobe.idp.dsc.registry.infomodel.Connector;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import java.util.HashMap;
import java.util.List;

public class ConnectorRegistryClient
implements ConnectorRegistry {
    private ServiceClientFactory m_serviceClientFactory;

    public ConnectorRegistryClient(ServiceClientFactory clientServiceFactory) {
        this.m_serviceClientFactory = clientServiceFactory;
    }

    public List getConnectors() {
        try {
            HashMap input = new HashMap(0);
            InvocationResponse response = this.invoke("getConnectors", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Connector getConnector(String aConnectorId) throws ConnectorNotFoundException {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("connector-id", aConnectorId);
            InvocationResponse response = this.invoke("getConnector", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Connector)) continue;
                return (Connector)returnValue[i];
            }
            return null;
        }
        catch (ConnectorNotFoundException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Endpoint getEndpointDefinition(String aConnectorId) {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("connector-id", aConnectorId);
            InvocationResponse response = this.invoke("getEndpointDefinition", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Endpoint)) continue;
                return (Endpoint)returnValue[i];
            }
            return null;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Connector create(Connector aConnector) throws DuplicateConnectorException, DSCRuntimeException {
        try {
            HashMap<String, Connector> input = new HashMap<String, Connector>(1);
            input.put("connector", aConnector);
            InvocationResponse response = this.invoke("create", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            if (returnValue[0] instanceof Connector) {
                return (Connector)returnValue[0];
            }
            return null;
        }
        catch (DuplicateConnectorException e) {
            throw e;
        }
        catch (DSCRuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void remove(Connector aConnector) throws ConnectorNotFoundException {
        try {
            HashMap<String, Connector> input = new HashMap<String, Connector>(1);
            input.put("connector", aConnector);
            InvocationResponse invocationResponse = this.invoke("remove", input);
        }
        catch (ConnectorNotFoundException e) {
            throw e;
        }
        catch (DSCRuntimeException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    private InvocationResponse invoke(String operationName, HashMap input) throws Exception {
        InvocationRequest request = this.m_serviceClientFactory.createInvocationRequest("system.connector_registry", operationName, input, true);
        return this.m_serviceClientFactory.getServiceClient().invoke(request);
    }
}

