/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.registry.component.client;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCInvocationException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.registry.ComponentNotFoundException;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.component.ComponentRegistry;
import com.adobe.idp.dsc.registry.component.ModifyComponentInfo;
import com.adobe.idp.dsc.registry.infomodel.Component;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class ComponentRegistryClient
implements ComponentRegistry {
    private ServiceClientFactory m_serviceClientFactory;

    public ComponentRegistryClient(ServiceClientFactory clientServiceFactory) {
        this.m_serviceClientFactory = clientServiceFactory;
    }

    public List getComponents() {
        try {
            InvocationResponse response = this.invoke("getComponents", null);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public List getComponents(String aComponentId) {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("component-id", aComponentId);
            InvocationResponse response = this.invoke("getComponentsWithId", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof List)) continue;
                return (List)returnValue[i];
            }
            return null;
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Component getComponent(String aComponentId, String aVersion) throws ComponentNotFoundException {
        try {
            HashMap<String, String> input = new HashMap<String, String>(1);
            input.put("component-id", aComponentId);
            input.put("version", aVersion);
            InvocationResponse response = this.invoke("getComponent", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Component)) continue;
                return (Component)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ComponentNotFoundException) {
                throw (ComponentNotFoundException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Component install(Document componentArchiveDocument) throws RegistryException {
        try {
            HashMap<String, Document> input = new HashMap<String, Document>(1);
            input.put("document", componentArchiveDocument);
            InvocationResponse response = this.invoke("installWithDocument", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Component)) continue;
                return (Component)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Component install(byte[] componentArchiveByteArray) throws RegistryException {
        try {
            HashMap<String, byte[]> input = new HashMap<String, byte[]>(1);
            input.put("bytes", componentArchiveByteArray);
            InvocationResponse response = this.invoke("installWithByteArray", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Component)) continue;
                return (Component)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Component modify(ModifyComponentInfo aInfo) throws RegistryException {
        try {
            HashMap<String, ModifyComponentInfo> input = new HashMap<String, ModifyComponentInfo>(1);
            input.put("component-info", aInfo);
            InvocationResponse response = this.invoke("modify", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Component)) continue;
                return (Component)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Component start(Component aComponent) throws RegistryException {
        try {
            HashMap<String, Component> input = new HashMap<String, Component>(1);
            input.put("component", aComponent);
            InvocationResponse response = this.invoke("start", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Component)) continue;
                return (Component)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Component start(Component aComponent, boolean aOverrideEndpointCreation) throws RegistryException {
        try {
            HashMap<String, Serializable> input = new HashMap<String, Serializable>(2);
            input.put("component", aComponent);
            input.put("override-endpoint-creation", Boolean.valueOf(aOverrideEndpointCreation));
            InvocationResponse response = this.invoke("start", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Component)) continue;
                return (Component)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Component stop(Component aComponent) throws RegistryException {
        try {
            HashMap<String, Component> input = new HashMap<String, Component>(1);
            input.put("component", aComponent);
            InvocationResponse response = this.invoke("stop", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Component)) continue;
                return (Component)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public Component load(Component aComponent) throws RegistryException {
        try {
            HashMap<String, Component> input = new HashMap<String, Component>(1);
            input.put("component", aComponent);
            InvocationResponse response = this.invoke("load", input);
            Object[] returnValue = response.getOutputParameters().values().toArray();
            for (int i = 0; i < returnValue.length; ++i) {
                if (!(returnValue[i] instanceof Component)) continue;
                return (Component)returnValue[i];
            }
            return null;
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void uninstall(Component aComponent) throws RegistryException {
        try {
            HashMap<String, Component> input = new HashMap<String, Component>(1);
            input.put("component", aComponent);
            this.invoke("uninstall", input);
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void forceUninstall(Component aComponent) throws RegistryException {
        try {
            HashMap<String, Component> input = new HashMap<String, Component>(1);
            input.put("component", aComponent);
            this.invoke("forceUninstall", input);
        }
        catch (DSCInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof RegistryException) {
                throw (RegistryException)cause;
            }
            throw new DSCRuntimeException(cause);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public void clearCache() {
        try {
            this.invoke("clearCache", null);
        }
        catch (DSCException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    private InvocationResponse invoke(String operationName, HashMap input) throws DSCException {
        InvocationRequest request = this.m_serviceClientFactory.createInvocationRequest("system.component_registry", operationName, input, true);
        return this.m_serviceClientFactory.getServiceClient().invoke(request);
    }
}

