/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.scheduler.scan.impl;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.provider.service.scheduler.ServiceInput;
import com.adobe.idp.dsc.provider.service.scheduler.ServiceOutput;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import com.adobe.idp.dsc.registry.infomodel.InputParameterMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class JobConfigurationReader
implements ServiceInput,
ServiceOutput {
    public static final String SINGLE_PROCESS_VAR_TYPE = "single";
    public static final String LIST_PROCESS_VAR_TYPE = "java.util.List";
    public static final String MAP_PROCESS_VAR_TYPE = "java.util.Map";
    public static final String STRING_PROCESS_VAR_TYPE = "java.lang.String";
    public static final String XML_DATA_TYPE = "xml";
    public static final String DOCUMENT_DATA_TYPE = "com.adobe.idp.Document";
    private HashMap m_inputMap = new HashMap();
    private HashMap m_outputMap = new HashMap();

    protected void readJobConfiguration(Endpoint aEndpoint) {
        try {
            InputParameterMapping[] _inputParameterMapping = aEndpoint.getInputParameterMappings();
            boolean _isVariable = false;
            String _filterPattern = null;
            String _parameterType = null;
            Object _parameterContainedType = null;
            String _parameterName = null;
            Object _parameterValue = null;
            InputParameterMapping _currentInputParameterMapping = null;
            for (int _i = 0; _i < _inputParameterMapping.length; ++_i) {
                _currentInputParameterMapping = _inputParameterMapping[_i];
                _parameterName = _currentInputParameterMapping.getInputParameterName();
                _parameterType = _currentInputParameterMapping.getType();
                _isVariable = _currentInputParameterMapping.getMappingType().equals("variable");
                if (_isVariable) {
                    _filterPattern = _currentInputParameterMapping.getMappingValue();
                    if (_parameterType.equals(LIST_PROCESS_VAR_TYPE)) {
                        this.m_inputMap.put(_parameterName, this.getDocumentList(_filterPattern));
                        continue;
                    }
                    if (_parameterType.equals(MAP_PROCESS_VAR_TYPE)) {
                        this.m_inputMap.put(_parameterName, this.getDocumentMap(_filterPattern));
                        continue;
                    }
                    this.m_inputMap.put(_parameterName, this.getDocument(_filterPattern));
                    continue;
                }
                this.m_inputMap.put(_parameterName, _currentInputParameterMapping.getMappingValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not parse", e);
        }
    }

    public void setInputs(String parameter, Object value) {
        this.m_inputMap.put(parameter, value);
    }

    public Map getInputs() {
        return this.m_inputMap;
    }

    public Map getOutputs() {
        return this.m_outputMap;
    }

    protected abstract List getDocumentList(String var1);

    protected abstract Map getDocumentMap(String var1);

    protected abstract Document getDocument(String var1);

    protected abstract List getXMList(String var1);

    protected abstract Map getXmlMap(String var1);

    protected abstract String getXml(String var1);

    protected abstract String getString(String var1);
}

