/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.scheduler.scan.impl;

import com.adobe.idp.Document;
import com.adobe.idp.DocumentManagerClient;
import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.provider.service.scheduler.impl.SchedulerRuntimeException;
import com.adobe.idp.dsc.provider.service.scheduler.impl.SchedulerUtils;
import com.adobe.idp.dsc.provider.service.scheduler.scan.impl.FileFilter;
import com.adobe.idp.dsc.provider.service.scheduler.scan.impl.JobConfigurationReader;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import com.adobe.logging.AdobeLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FileSystemConfigurationReader
extends JobConfigurationReader {
    private static AdobeLogger logger = AdobeLogger.getAdobeLogger(FileSystemConfigurationReader.class);
    private static final String PATTERN_SEPARATED_CHAR = ";";
    File m_inputFile;

    private FileSystemConfigurationReader() {
    }

    public FileSystemConfigurationReader(Endpoint aFileEndpoint, File inputFile) {
        this.m_inputFile = inputFile;
        this.readJobConfiguration(aFileEndpoint);
    }

    protected List getDocumentList(String pattern) {
        return this.getDocumentListFromFiles(pattern);
    }

    protected Map getDocumentMap(String pattern) {
        return this.getDocumentMapFromFiles(pattern);
    }

    protected Document getDocument(String pattern) {
        return this.getDocumentFromFiles(pattern);
    }

    protected List getXMList(String pattern) {
        return this.getXmlListFromFiles(pattern);
    }

    protected Map getXmlMap(String pattern) {
        return this.getXmlMapFromFiles(pattern);
    }

    protected String getXml(String pattern) {
        return this.getXmlFromFiles(pattern);
    }

    private ArrayList getDocumentListFromFiles(String pattern) {
        File currentFile = null;
        Document currentDocument = null;
        ArrayList<Document> documentList = null;
        File[] filteredFileList = this.getFilteredFiles(pattern);
        if (filteredFileList != null && filteredFileList.length > 0) {
            documentList = new ArrayList<Document>();
            logger.debug("Document List .......");
            try {
                for (int j = 0; j < filteredFileList.length; ++j) {
                    currentFile = filteredFileList[j];
                    currentDocument = DocumentManagerClient.createDocumentFromFileByLinking(currentFile);
                    documentList.add(currentDocument);
                    logger.debug("document----- " + documentList.toString());
                }
            }
            catch (Throwable _t) {
                DSCError _error = new DSCError(602, new Object[]{currentFile});
                throw new SchedulerRuntimeException(_error, _t, null, currentFile);
            }
        } else {
            logger.debug("JobAgent : createJobsForProcessing ----- no files are found for conversion to documents in " + currentFile.getAbsolutePath());
        }
        return documentList;
    }

    private Map getDocumentMapFromFiles(String pattern) {
        File currentFile = null;
        Document currentDocument = null;
        HashMap<String, Document> documentMap = null;
        File[] filteredFileList = this.getFilteredFiles(pattern);
        if (filteredFileList != null && filteredFileList.length > 0) {
            documentMap = new HashMap<String, Document>();
            logger.debug("Document map .............");
            try {
                for (int j = 0; j < filteredFileList.length; ++j) {
                    currentFile = filteredFileList[j];
                    currentDocument = DocumentManagerClient.createDocumentFromFileByLinking(currentFile);
                    documentMap.put(currentFile.getName(), currentDocument);
                    logger.debug(" document ---- " + currentFile.getName() + " :  " + currentDocument.toString());
                }
            }
            catch (Throwable _t) {
                DSCError _error = new DSCError(602, new Object[]{currentFile});
                throw new SchedulerRuntimeException(_error, _t, null, currentFile);
            }
        }
        return documentMap;
    }

    private Document getDocumentFromFiles(String pattern) {
        Document sourceDoc = null;
        File[] filteredFileList = this.getFilteredFiles(pattern);
        if (filteredFileList != null && filteredFileList.length > 0) {
            try {
                logger.debug("Document single .....");
                sourceDoc = DocumentManagerClient.createDocumentFromFileByLinking(filteredFileList[0]);
                logger.debug("document------- " + sourceDoc.toString());
            }
            catch (Throwable _t) {
                DSCError _error = new DSCError(602, new Object[]{filteredFileList[0]});
                throw new SchedulerRuntimeException(_error, _t, null, filteredFileList[0]);
            }
        }
        return sourceDoc;
    }

    private ArrayList getXmlListFromFiles(String pattern) {
        File currentFile = null;
        String currentXml = null;
        ArrayList<String> xmlList = null;
        File[] filteredFileList = this.getXmlFilteredFiles(pattern);
        if (filteredFileList != null && filteredFileList.length > 0) {
            xmlList = new ArrayList<String>();
            logger.debug("Xml List .......");
            for (int j = 0; j < filteredFileList.length; ++j) {
                try {
                    currentFile = filteredFileList[j];
                    currentXml = SchedulerUtils.readFile(currentFile);
                    xmlList.add(currentXml);
                    logger.debug("xml--------" + currentXml);
                    continue;
                }
                catch (Throwable _t) {
                    DSCError _error = new DSCError(602, new Object[]{filteredFileList[0]});
                    throw new SchedulerRuntimeException(_error, _t, null, filteredFileList[j]);
                }
            }
        }
        return xmlList;
    }

    private Map getXmlMapFromFiles(String pattern) {
        File currentFile = null;
        String currentXml = null;
        HashMap<String, String> xmlMap = null;
        File[] filteredFileList = this.getXmlFilteredFiles(pattern);
        if (filteredFileList != null && filteredFileList.length > 0) {
            xmlMap = new HashMap<String, String>();
            logger.debug("Xml map ............");
            for (int j = 0; j < filteredFileList.length; ++j) {
                try {
                    currentFile = filteredFileList[j];
                    currentXml = SchedulerUtils.readFile(currentFile);
                    logger.debug("xml-----------" + currentFile.getName() + " : " + currentXml);
                    xmlMap.put(currentFile.getName(), currentXml);
                    continue;
                }
                catch (Throwable _t) {
                    DSCError _error = new DSCError(602, new Object[]{filteredFileList[0]});
                    throw new SchedulerRuntimeException(_error, _t, null, filteredFileList[j]);
                }
            }
        }
        return xmlMap;
    }

    private String getXmlFromFiles(String pattern) {
        String sourceXml = null;
        File[] filteredFileList = this.getXmlFilteredFiles(pattern);
        logger.debug("Xml single ............");
        if (filteredFileList != null && filteredFileList.length > 0) {
            try {
                sourceXml = SchedulerUtils.readFile(filteredFileList[0]);
                logger.debug("xml-------- " + sourceXml);
            }
            catch (Throwable _t) {
                DSCError _error = new DSCError(602, new Object[]{filteredFileList[0]});
                throw new SchedulerRuntimeException(_error, _t, null, filteredFileList[0]);
            }
        }
        return sourceXml;
    }

    private File[] getFilteredFiles(String pattern) {
        File[] currentFileList = null;
        if (this.m_inputFile != null) {
            currentFileList = FileSystemConfigurationReader.searchFileForPattern(this.m_inputFile, pattern);
        }
        return currentFileList;
    }

    private File[] getXmlFilteredFiles(String pattern) {
        File[] currentFileList = null;
        if (this.m_inputFile != null) {
            currentFileList = FileSystemConfigurationReader.searchFileForPattern(this.m_inputFile, pattern);
            File[] parentFolderFilteredList = FileSystemConfigurationReader.searchFileForPattern(this.m_inputFile.getParentFile().getParentFile(), pattern);
            if (parentFolderFilteredList != null && parentFolderFilteredList.length > 0) {
                if (currentFileList != null && currentFileList.length > 0) {
                    File[] newArray = new File[currentFileList.length + parentFolderFilteredList.length];
                    System.arraycopy(currentFileList, 0, newArray, 0, currentFileList.length);
                    System.arraycopy(parentFolderFilteredList, 0, newArray, currentFileList.length, parentFolderFilteredList.length);
                    currentFileList = newArray;
                } else {
                    currentFileList = parentFolderFilteredList;
                }
            }
        }
        return currentFileList;
    }

    public static Document[] getDocumentsForPattern(File aFileToSearch, String aFilePattern) {
        Document[] _docArray = null;
        File[] _fileArray = FileSystemConfigurationReader.searchFileForPattern(aFileToSearch, aFilePattern);
        if (_fileArray != null && _fileArray.length > 0) {
            Document _currentDoc = null;
            _docArray = new Document[_fileArray.length];
            for (int _i = 0; _i < _fileArray.length; ++_i) {
                _docArray[_i] = _currentDoc = DocumentManagerClient.createDocumentFromFileByLinking(_fileArray[_i]);
            }
        }
        return _docArray;
    }

    public static File[] searchFileForPattern(File fileToSearch, String pattern) {
        File[] filteredFileList = null;
        FileFilter fileFilter = new FileFilter();
        fileFilter.clearExcludeList();
        fileFilter.clearIncludeList();
        if (pattern != null && pattern.length() > 0) {
            String[] patternsArr = FileSystemConfigurationReader.getPatternArray(pattern);
            fileFilter.addIncludeList(patternsArr);
            if (fileToSearch.isDirectory()) {
                filteredFileList = fileToSearch.listFiles(fileFilter);
            } else if (fileFilter.accept(fileToSearch.getParentFile(), fileToSearch.getName())) {
                filteredFileList = new File[]{fileToSearch};
            }
        }
        return filteredFileList;
    }

    public static String[] getPatternArray(String patternString) {
        String[] patternArray = null;
        if (patternString != null) {
            StringTokenizer st = new StringTokenizer(patternString, PATTERN_SEPARATED_CHAR);
            int numToken = st.countTokens();
            patternArray = new String[numToken];
            for (int i = 0; i < numToken; ++i) {
                patternArray[i] = st.nextToken();
            }
        }
        return patternArray;
    }

    public String getString(String pattern) {
        return "";
    }
}

