/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.scheduler.scan.impl;

import com.adobe.idp.dsc.provider.service.scheduler.PathMatcher;
import com.adobe.idp.dsc.provider.service.scheduler.ProviderFileNameFilter;
import com.adobe.logging.AdobeLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileFilter
implements ProviderFileNameFilter {
    private static AdobeLogger log = AdobeLogger.getAdobeLogger(FileFilter.class);
    private List includeList;
    private List excludeList;

    public void addInclude(String pattern) {
        if (this.includeList == null) {
            this.includeList = new ArrayList();
        }
        this.includeList.add(PathMatcher.escapeSpecialCharacterInRegularExpression(pattern));
    }

    public void addExclude(String pattern) {
        if (this.excludeList == null) {
            this.excludeList = new ArrayList();
        }
        this.excludeList.add(PathMatcher.escapeSpecialCharacterInRegularExpression(pattern));
    }

    public void addIncludeList(String[] patternList) {
        if (patternList != null && patternList.length > 0) {
            for (int i = 0; i < patternList.length; ++i) {
                this.addInclude(patternList[i]);
            }
        }
    }

    public void addExcludeList(String[] patternList) {
        if (patternList != null && patternList.length > 0) {
            for (int i = 0; i < patternList.length; ++i) {
                this.addExclude(patternList[i]);
            }
        }
    }

    public void clearIncludeList() {
        if (this.includeList != null) {
            this.includeList.clear();
        }
    }

    public void clearExcludeList() {
        if (this.excludeList != null) {
            this.excludeList.clear();
        }
    }

    public boolean accept(File dir, String filename) {
        String pattern;
        Iterator iterator;
        String str = filename;
        str = filename.replace('\\', '/');
        if (str.startsWith("/")) {
            str = str.substring(1);
        }
        boolean match = false;
        if (this.includeList == null) {
            match = true;
        } else {
            iterator = this.includeList.iterator();
            while (iterator.hasNext() && !match) {
                pattern = (String)iterator.next();
                match = PathMatcher.match(pattern, str);
            }
        }
        log.debug("File name: %1 includeMatch: %2", (Object)str, (Object)new Boolean(match));
        if (match && this.excludeList != null) {
            iterator = this.excludeList.iterator();
            while (iterator.hasNext() && match) {
                pattern = (String)iterator.next();
                match = !PathMatcher.match(pattern, str);
            }
        }
        log.debug("File name: %1 Match: %2", (Object)str, (Object)new Boolean(match));
        return match;
    }

    public static void main(String[] args) {
        FileFilter fileFilter = new FileFilter();
        fileFilter.addInclude("*.*");
        File dir = new File("C:/devtools/jboss-3.2.6/lib");
        File[] files = dir.listFiles(fileFilter);
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getAbsolutePath();
            log.debug(name);
        }
    }
}

