/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.scheduler.scan.impl;

import com.adobe.idp.DocumentManagerClient;
import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.FaultCallBackInfo;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.ResponseCallBackInfo;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.provider.ProviderRuntimeException;
import com.adobe.idp.dsc.provider.service.scheduler.ConfigurationHandler;
import com.adobe.idp.dsc.provider.service.scheduler.impl.SchedulerRuntimeException;
import com.adobe.idp.dsc.provider.service.scheduler.scan.ScanJob;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import com.adobe.logging.AdobeLogger;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractScanJob
implements ScanJob {
    private static AdobeLogger logger = AdobeLogger.getAdobeLogger(AbstractScanJob.class);
    protected Endpoint m_endpoint;
    protected ConfigurationHandler m_configHandler;

    public void execute(HashMap aInputMap) throws ProviderRuntimeException {
        Object aEndpoint = null;
        try {
            this.doInitialize(aInputMap);
            this.m_endpoint = this.getEndpointFromInput(aInputMap);
            Object[] _inputList = this.fetchInputs();
            this.processInputs(_inputList);
        }
        catch (SchedulerRuntimeException aSRE) {
            this.handleFailure(aSRE, aSRE.getObjectInProcess());
        }
        catch (Throwable t) {
            this.handleFailure(t, null);
        }
    }

    public abstract void doInitialize(HashMap var1) throws ProviderRuntimeException;

    public abstract Endpoint getEndpointFromInput(HashMap var1) throws ProviderRuntimeException;

    public abstract Object[] fetchInputs() throws ProviderRuntimeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInputs(Object[] aInputList) throws SchedulerRuntimeException {
        if (aInputList != null && aInputList.length > 0) {
            for (int _i = 0; _i < aInputList.length; ++_i) {
                try {
                    DocumentManagerClient.startInvocationScopedDisposal();
                    Map _inputMap = this.createInputParamMap(aInputList[_i]);
                    Object _response = this.invokeJob(aInputList[_i], _inputMap);
                    this.handleSuccess(_response, aInputList[_i]);
                    continue;
                }
                catch (SchedulerRuntimeException aSRE) {
                    this.handleFailure(aSRE, aSRE.getObjectInProcess());
                    continue;
                }
                catch (Throwable t) {
                    this.handleFailure(t, null);
                    continue;
                }
                finally {
                    DocumentManagerClient.endInvocationScopedDisposal();
                }
            }
        }
    }

    public abstract Map createInputParamMap(Object var1) throws SchedulerRuntimeException;

    public abstract boolean isAsynch();

    public abstract ResponseCallBackInfo getResponseCallbackInfo(Object var1);

    public abstract FaultCallBackInfo getFaultCallbackInfo(Object var1);

    public abstract Map getClientParams(Object var1);

    public Object invokeJob(Object aInputObject, Map aInputParamMap) throws SchedulerRuntimeException {
        InvocationRequest _request = null;
        String _serviceName = this.m_endpoint.getServiceId();
        String _operationName = this.m_endpoint.getOperationName();
        InvocationResponse _response = null;
        try {
            if (_serviceName != null && _serviceName.length() > 0 && _operationName != null && _operationName.length() > 0) {
                ServiceClientFactory _scFactory = this.getServiceClientFactory();
                _request = _scFactory.createInvocationRequest(_serviceName, _operationName, aInputParamMap, !this.isAsynch());
                _request.setClientParameters(this.getClientParams(aInputObject));
                _request.setFaultCallback(this.getFaultCallbackInfo(aInputObject));
                _request.setResponseCallback(this.getResponseCallbackInfo(aInputObject));
                logger.debug("Creating request for : operation  ---------" + _serviceName + "  :  " + _operationName);
                logger.debug("Input params are ---------");
                Object[] inputValues = aInputParamMap.values().toArray();
                for (int j = 0; j < inputValues.length; ++j) {
                    if (inputValues[j] == null) continue;
                    logger.debug(inputValues[j].toString());
                }
                _response = _scFactory.getServiceClient().invoke(_request);
            }
        }
        catch (Throwable e) {
            DSCError _fe = new DSCError(600, new Object[]{this.m_endpoint.getName()});
            SchedulerRuntimeException _sre = new SchedulerRuntimeException(_fe, e, this.m_endpoint, aInputObject);
            this.handleFailure(_sre, _sre.getObjectInProcess());
        }
        return _response;
    }

    public abstract void handleSuccess(Object var1, Object var2) throws ProviderRuntimeException;

    public abstract void handleFailure(Throwable var1, Object var2) throws ProviderRuntimeException;

    public abstract ServiceClientFactory getServiceClientFactory();
}

