/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.scheduler.impl;

import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClient;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.provider.ProviderRuntimeException;
import com.adobe.idp.dsc.registry.infomodel.ConfigParameter;
import com.adobe.idp.dsc.registry.infomodel.impl.ConfigParameterImpl;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.idp.dsc.util.CoercionUtil;
import com.adobe.idp.um.api.UMLocalUtils;
import com.adobe.logging.AdobeLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class SchedulerUtils {
    private static AdobeLogger _logger = AdobeLogger.getAdobeLogger(SchedulerUtils.class);
    private static final int READ_BUFFER_SIZE = 1024;

    public static final String[] constructProjectPath(String pathString, int index, boolean dropFirstComponent) {
        ArrayList<String> a = new ArrayList<String>();
        if (index < pathString.length() && pathString.charAt(index) == '/') {
            ++index;
        }
        while (true) {
            String s;
            int index2;
            if ((index2 = pathString.indexOf(47, index)) < 0) {
                s = pathString.substring(index);
                if (s.length() <= 0) break;
                a.add(s);
                break;
            }
            s = pathString.substring(index, index2);
            if (s.length() > 0) {
                a.add(s);
            }
            index = index2 + 1;
        }
        if (dropFirstComponent && a.size() > 0) {
            a.remove(0);
        }
        return a.toArray(new String[a.size()]);
    }

    public static String toString(String[] pathArray, int index) {
        return SchedulerUtils.toString(pathArray, index, true);
    }

    public static String toString(String[] pathArray, int index, boolean dropFirstSlash) {
        StringBuffer result = new StringBuffer();
        if (pathArray != null) {
            for (int i = index; i < pathArray.length; ++i) {
                result.append('/');
                result.append(pathArray[i]);
            }
            if (dropFirstSlash) {
                result.deleteCharAt(0);
            }
        }
        return result.toString();
    }

    public static HashMap queryStringToParamList(String paramString) {
        String parameterName = null;
        String parameterValue = null;
        HashMap<String, String> parameterList = new HashMap<String, String>();
        StringTokenizer tokens = new StringTokenizer(paramString, "&");
        while (tokens.hasMoreTokens()) {
            String value = tokens.nextToken();
            int seperatorIndex = value.indexOf("=");
            if (seperatorIndex > 0) {
                parameterName = value.substring(0, seperatorIndex);
                parameterValue = value.substring(seperatorIndex + 1);
            }
            if (parameterName == null || parameterName.length() <= 0 || parameterValue == null || parameterValue.length() <= 0) continue;
            parameterList.put(parameterName, parameterValue);
            System.out.println(parameterName + " : " + parameterValue);
        }
        return parameterList;
    }

    public static ConfigParameter[] getCommonEndpointConfigParameter() {
        ConfigParameter[] _configParamArr = new ConfigParameter[4];
        int _i = 0;
        ConfigParameterImpl _configParam0 = new ConfigParameterImpl();
        _configParam0.setName("cronExpression");
        _configParam0.setRequired(true);
        _configParam0.setTextValue(null);
        _configParam0.setType("java.lang.String");
        _configParamArr[_i] = _configParam0;
        ++_i;
        ConfigParameterImpl _configParam1 = new ConfigParameterImpl();
        _configParam1.setName("repeatCount");
        _configParam1.setRequired(true);
        _configParam1.setTextValue("-1");
        _configParam1.setType("int");
        _configParamArr[_i] = _configParam1;
        ++_i;
        ConfigParameterImpl _configParam2 = new ConfigParameterImpl();
        _configParam2.setName("repeatInterval");
        _configParam2.setRequired(true);
        _configParam2.setTextValue("5000");
        _configParam2.setType("long");
        _configParamArr[_i] = _configParam2;
        ++_i;
        ConfigParameterImpl _configParam3 = new ConfigParameterImpl();
        _configParam3.setName("startDelay");
        _configParam3.setRequired(true);
        _configParam3.setTextValue("0");
        _configParam3.setType("long");
        _configParamArr[_i] = _configParam3;
        ++_i;
        return _configParamArr;
    }

    public static ConfigParameter[] getSchedulerEndpointConfigParameter() {
        return SchedulerUtils.getCommonEndpointConfigParameter();
    }

    public static Object convertFromConfigParameterArrayToJavaObject(Class aJavaClass, ConfigParameter[] aConfigParamArr) {
        ConfigParameter _cfgParam = null;
        Object _object = null;
        if (aConfigParamArr != null) {
            try {
                _object = ClassHelper.instanciateClass(aJavaClass, null);
                for (int _i = 0; _i < aConfigParamArr.length; ++_i) {
                    _cfgParam = aConfigParamArr[_i];
                    String _name = _cfgParam.getName();
                    String _type = _cfgParam.getType();
                    String _methodName = "set" + _name.substring(0, 1).toUpperCase() + _name.substring(1);
                    _logger.debug("Class : Method name -----" + aJavaClass.getName() + "  :  " + _methodName);
                    Method _m = ClassHelper.getMethod(_methodName, aJavaClass);
                    Object[] _args = new Object[]{_cfgParam.getTextValue()};
                    if (_type.equals("int")) {
                        _args[0] = CoercionUtil.toInteger(_args[0]);
                    } else if (_type.equals("long")) {
                        _args[0] = CoercionUtil.toLong(_args[0]);
                    } else if (_type.equals("boolean")) {
                        _args[0] = CoercionUtil.toBoolean(_args[0]);
                    }
                    _m.invoke(_object, _args);
                }
            }
            catch (Throwable _throw) {
                throw new RuntimeException(_throw);
            }
        }
        return _object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InvocationResponse callService(String aServiceName, String aOperationName, Map aInputParams, String aUsername, String aPassword) {
        InvocationResponse _response = null;
        try {
            ServiceClientFactory _sf = ServiceClientFactory.createInstance();
            ServiceClient _sc = _sf.getServiceClient();
            _logger.info("-----------------------------------------------------------------------");
            _logger.info("Service to be called is " + aServiceName);
            _logger.info("Service operation to be called is " + aOperationName);
            if (aInputParams != null) {
                _logger.info("Service operation parameters are " + aInputParams);
            }
            InvocationRequest _request = _sf.createInvocationRequest(aServiceName, aOperationName, aInputParams, true);
            _response = _sc.invoke(_request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return _response;
    }

    public static InvocationResponse callSchedulerService(String aOperationName, Map aInputParams) {
        InvocationResponse _response = null;
        try {
            ServiceClientFactory _sf = ServiceClientFactory.createInstance(UMLocalUtils.getSystemContext());
            ServiceClient _sc = _sf.getServiceClient();
            if (aInputParams != null) {
                _logger.info("Service operation parameters are " + aInputParams);
            }
            InvocationRequest _request = _sf.createInvocationRequest("IDPSchedulerService", aOperationName, aInputParams, true);
            _response = _sc.invoke(_request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return _response;
    }

    public static InvocationResponse callJobManagerService(String aOperationName, Map aInputParams) {
        InvocationResponse _response = null;
        try {
            ServiceClientFactory _sf = ServiceClientFactory.createInstance();
            ServiceClient _sc = _sf.getServiceClient();
            if (aInputParams != null) {
                _logger.info("Service operation parameters are " + aInputParams);
            }
            InvocationRequest _request = _sf.createInvocationRequest("JobManager", aOperationName, aInputParams, true);
            _response = _sc.invoke(_request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return _response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readFile(String parentFolder, String filename) {
        Properties fileProperties = new Properties();
        FileInputStream istream = null;
        File inputFile = new File(parentFolder, filename);
        if (inputFile != null) {
            try {
                if (!inputFile.exists()) {
                    _logger.debug("Created a new log file");
                    inputFile.createNewFile();
                }
                if ((istream = new FileInputStream(inputFile.getAbsolutePath())) != null) {
                    fileProperties.load(istream);
                }
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
                _logger.debug("File not found");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                _logger.debug("could not load the properties");
            }
            finally {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (IOException e) {
                        _logger.debug("Error closing file " + inputFile, e);
                    }
                }
            }
        }
        return fileProperties;
    }

    public static String readFile(File inputfile) throws IOException {
        String string;
        FileReader reader = null;
        StringWriter writer = null;
        try {
            int length;
            reader = new FileReader(inputfile);
            writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((length = ((Reader)reader).read(buffer, 0, buffer.length)) != -1) {
                ((Writer)writer).write(buffer, 0, length);
            }
            string = ((Object)writer).toString();
        }
        catch (Throwable _t) {
            try {
                DSCError _err = new DSCError(603, new Object[]{inputfile.getAbsolutePath()});
                throw new ProviderRuntimeException(_err, _t);
            }
            catch (Throwable throwable) {
                SchedulerUtils.close(reader);
                SchedulerUtils.close(writer);
                throw throwable;
            }
        }
        SchedulerUtils.close(reader);
        SchedulerUtils.close(writer);
        return string;
    }

    public static void close(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public static void close(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }
}

