/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.scheduler.impl;

import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.provider.ProviderRuntimeException;
import com.adobe.idp.dsc.provider.service.scheduler.ConfigurationHandler;
import com.adobe.idp.dsc.provider.service.scheduler.EndpointManager;
import com.adobe.idp.dsc.provider.service.scheduler.impl.SchedulerEndpointConfigProperties;
import com.adobe.idp.dsc.provider.service.scheduler.impl.SchedulerUtils;
import com.adobe.idp.dsc.registry.endpoint.EndpointRegistry;
import com.adobe.idp.dsc.registry.endpoint.ModifyEndpointInfo;
import com.adobe.idp.dsc.registry.infomodel.ConfigParameter;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import java.util.Date;
import java.util.HashMap;
import org.quartz.SimpleTrigger;

public abstract class AbstractEndpointManager
implements EndpointManager {
    private ConfigurationHandler m_configHandler;

    public AbstractEndpointManager(ConfigurationHandler aConfigHandler) {
        this.m_configHandler = aConfigHandler;
    }

    public void onEndpointCreation(Endpoint aEndpoint) throws ProviderRuntimeException {
        if (aEndpoint.isEnabled()) {
            this.OnEnableEndpoint(aEndpoint);
        }
    }

    public void onEndpointDeletion(Endpoint aEndpoint) throws ProviderRuntimeException {
        HashMap<String, String> _paramMap = new HashMap<String, String>();
        _paramMap.put("jobName", this.getJobName(aEndpoint));
        _paramMap.put("groupName", this.getGroupName(aEndpoint));
        SchedulerUtils.callSchedulerService("deleteJob", _paramMap);
    }

    public void OnEnableEndpoint(Endpoint aEndpoint) throws ProviderRuntimeException {
        if (aEndpoint == null) {
            throw new IllegalArgumentException("Illegal endpoint");
        }
        Object _jobData = this.createJobDetail(aEndpoint);
        Object _trigger = null;
        _trigger = this.createTrigger(aEndpoint);
        HashMap<String, Object> _scheduleJobMap = new HashMap<String, Object>();
        _scheduleJobMap.put("jobData", _jobData);
        _scheduleJobMap.put("trigger", _trigger);
        Object _scheduledTrigger = null;
        InvocationResponse _response = SchedulerUtils.callSchedulerService("scheduleJob", _scheduleJobMap);
        if (_response != null) {
            _scheduledTrigger = _response.getOutputParameter("trigger");
        }
        if (_scheduledTrigger == null) {
            throw new RuntimeException("Could not rschedule");
        }
    }

    public void OnDisableEndpoint(Endpoint aEndpoint) throws ProviderRuntimeException {
        HashMap<String, String> _paramMap = new HashMap<String, String>();
        _paramMap.put("triggerName", this.getTriggerName(aEndpoint));
        _paramMap.put("triggerGroupName", this.getGroupName(aEndpoint));
        InvocationResponse _response = SchedulerUtils.callSchedulerService("unscheduleJob", _paramMap);
        boolean _isSuccessful = false;
        if (_response != null) {
            _isSuccessful = (Boolean)_response.getOutputParameter("success");
        }
        if (!_isSuccessful) {
            throw new RuntimeException("Could not disable the endpoint");
        }
    }

    public void onEndpointUpdating(Endpoint aOldEndpoint, Endpoint aNewEndpoint) throws ProviderRuntimeException {
        if (this.isStateChanged(aOldEndpoint, aNewEndpoint)) {
            if (aNewEndpoint.isEnabled()) {
                this.OnEnableEndpoint(aNewEndpoint);
            } else {
                this.OnDisableEndpoint(aNewEndpoint);
            }
        } else if (this.isTriggerUpdated(aOldEndpoint, aNewEndpoint) && aNewEndpoint.isEnabled()) {
            this.onTriggerUpdated(aNewEndpoint);
        }
    }

    private boolean isTriggerUpdated(Endpoint aOldEndpoint, Endpoint aNewEndpoint) {
        String oldCronValue = "";
        String newCronValue = "";
        String oldIntervalValue = "";
        String newIntervalValue = "";
        ConfigParameter[] oldConfigParams = aOldEndpoint.getConfigParameters();
        boolean found = false;
        for (int i = 0; i < oldConfigParams.length; ++i) {
            if (oldConfigParams[i].getName().equalsIgnoreCase("cronExpression")) {
                oldCronValue = oldConfigParams[i].getTextValue();
                if (oldCronValue == null) {
                    oldCronValue = "";
                }
                if (found) break;
                found = true;
            }
            if (!oldConfigParams[i].getName().equalsIgnoreCase("repeatInterval")) continue;
            oldIntervalValue = oldConfigParams[i].getTextValue();
            if (oldIntervalValue == null) {
                oldIntervalValue = "";
            }
            if (found) break;
            found = true;
        }
        ConfigParameter[] newConfigParams = aNewEndpoint.getConfigParameters();
        found = false;
        for (int j = 0; j < newConfigParams.length; ++j) {
            if (newConfigParams[j].getName().equalsIgnoreCase("cronExpression")) {
                newCronValue = newConfigParams[j].getTextValue();
                if (newCronValue == null) {
                    newCronValue = "";
                }
                if (found) break;
                found = true;
            }
            if (!newConfigParams[j].getName().equalsIgnoreCase("repeatInterval")) continue;
            newIntervalValue = newConfigParams[j].getTextValue();
            if (newIntervalValue == null) {
                newIntervalValue = "";
            }
            if (found) break;
            found = true;
        }
        boolean updatedCron = !oldCronValue.equals(newCronValue);
        boolean updatedInterval = !oldIntervalValue.equals(newIntervalValue);
        return updatedCron || updatedInterval;
    }

    private boolean isStateChanged(Endpoint aOldEndpoint, Endpoint aNewEndpoint) {
        return aOldEndpoint.isEnabled() != aNewEndpoint.isEnabled();
    }

    private void onTriggerUpdated(Endpoint aEndpoint) {
        Object _newTrigger = this.createTrigger(aEndpoint);
        HashMap<String, Object> _paramMap = new HashMap<String, Object>();
        _paramMap.put("jobName", this.getJobName(aEndpoint));
        _paramMap.put("jobGroupName", this.getGroupName(aEndpoint));
        _paramMap.put("triggerName", this.getTriggerName(aEndpoint));
        _paramMap.put("groupName", this.getGroupName(aEndpoint));
        _paramMap.put("trigger", _newTrigger);
        InvocationResponse _response = SchedulerUtils.callSchedulerService("rescheduleJob", _paramMap);
        Date _date = null;
        if (_response != null) {
            _date = (Date)_response.getOutputParameter("date");
        }
        if (_date == null) {
            throw new RuntimeException("Could not reschedule");
        }
    }

    protected String getJobName(Endpoint aEndpoint) {
        return aEndpoint.getConnectorId() + ":" + Long.toString(aEndpoint.getId());
    }

    protected String getGroupName(Endpoint aEndpoint) {
        return aEndpoint.getConnectorId();
    }

    protected String getTriggerName(Endpoint aEndpoint) {
        return aEndpoint.getConnectorId() + ":" + Long.toString(aEndpoint.getId());
    }

    protected String getEndpointValueFor(Endpoint aEndpoint, String aConfigParamName) {
        ConfigParameter[] _configParams = aEndpoint.getConfigParameters();
        if (_configParams != null) {
            for (int i = 0; i < _configParams.length; ++i) {
                ConfigParameter _configParam = _configParams[i];
                if (!_configParam.getName().equals(aConfigParamName)) continue;
                return _configParam.getTextValue();
            }
        }
        return null;
    }

    protected void changeEndpoint(Endpoint aEndpoint, String aConfigParamName, String aValue) {
        ModifyEndpointInfo _endpointInfo = new ModifyEndpointInfo();
        _endpointInfo.setConfigParameterAsText(aConfigParamName, aValue);
        try {
            EndpointRegistry _epRegistry = DSContainer.getInstance().getEndpointRegistry();
            _epRegistry.modifyEndpoint(_endpointInfo);
        }
        catch (Exception _ex) {
            throw new RuntimeException(_ex);
        }
    }

    protected Object createJobDetail(Endpoint aEndpoint) {
        HashMap<String, Object> jobDetailMap = new HashMap<String, Object>();
        jobDetailMap.put("jobName", this.getJobName(aEndpoint));
        jobDetailMap.put("jobGroupName", this.getGroupName(aEndpoint));
        jobDetailMap.put("parameters", this.createInvocationRequest(aEndpoint));
        InvocationResponse _response = SchedulerUtils.callSchedulerService("createJobDetail", jobDetailMap);
        Object _jobData = null;
        if (_response != null) {
            _jobData = _response.getOutputParameters().get("job");
        }
        return _jobData;
    }

    protected Object createTrigger(Endpoint aEndpoint) {
        Object _trigger = null;
        SchedulerEndpointConfigProperties _sep = this.m_configHandler.getEndpointProperties(aEndpoint);
        String _cronExpression = _sep.getCronExpression();
        long _repeatInterval = _sep.getRepeatInterval();
        _repeatInterval *= 1000L;
        int _repeatCount = _sep.getRepeatCount();
        long _startDelay = _sep.getStartDelay();
        try {
            String _triggerName = this.getTriggerName(aEndpoint);
            String _triggerGroupName = this.getGroupName(aEndpoint);
            HashMap<String, Object> _triggerMap = new HashMap<String, Object>();
            InvocationResponse _response = null;
            if (_cronExpression != null && _cronExpression.length() > 0) {
                _triggerMap.put("triggerName", _triggerName);
                _triggerMap.put("triggerGrpName", _triggerGroupName);
                _triggerMap.put("cronExpression", _cronExpression);
                _response = SchedulerUtils.callSchedulerService("createCronTrigger", _triggerMap);
            } else if (_repeatInterval > 0L) {
                _triggerMap.put("triggerName", _triggerName);
                _triggerMap.put("triggerGrpName", _triggerGroupName);
                _triggerMap.put("repeatInterval", new Long(_repeatInterval));
                if (_repeatCount >= 0) {
                    _triggerMap.put("repeatCount", new Integer(_repeatCount));
                } else {
                    _triggerMap.put("repeatCount", new Integer(SimpleTrigger.REPEAT_INDEFINITELY));
                }
                long _start = System.currentTimeMillis();
                if (_startDelay > 0L) {
                    _start += _startDelay;
                }
                _triggerMap.put("startDate", new Date(_start));
                _triggerMap.put("endDate", null);
                _response = SchedulerUtils.callSchedulerService("createPeriodicTrigger", _triggerMap);
            } else {
                throw new IllegalArgumentException("Invalid trigger");
            }
            if (_response != null) {
                _trigger = _response.getOutputParameters().get("trigger");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the trigger");
        }
        return _trigger;
    }

    public abstract InvocationRequest createInvocationRequest(Endpoint var1);
}

