/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.scheduler;

import com.adobe.logging.AdobeLogger;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PathMatcher {
    private static final String PERIOD_PATTERN = ".*?\\.";
    private static final String ESCAPE_PERIOD_PATTERN = "\\.";
    private static final String WILDCARD_PATTERN = ".*?\\*";
    private static final String ESCAPE_WILDCARD_PATTERN = ".*";
    private static final String QUESTION_MARK_PATTERN = ".*?\\?";
    private static final String ESCAPE_QUESTION_MARK_PATTERN = ".";
    private static int SPECIAL_CHARACTER_PATTERN_INDEX = 0;
    private static int ESCAPE_CHARACTER_PATTERN_INDEX = 1;
    private static String[][] specialCharacterTable = new String[][]{{".*?\\.", "\\."}, {".*?\\*", ".*"}, {".*?\\?", "."}};
    private static AdobeLogger log = AdobeLogger.getAdobeLogger(PathMatcher.class);

    public static boolean match(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static String escapeSpecialCharacterInRegularExpression(String regex) {
        String result = regex;
        for (int i = 0; i < specialCharacterTable.length; ++i) {
            result = PathMatcher.escapeSpecialCharacterInRegularExpression(result, specialCharacterTable[i][SPECIAL_CHARACTER_PATTERN_INDEX], specialCharacterTable[i][ESCAPE_CHARACTER_PATTERN_INDEX]);
        }
        log.debug("Escaping regular expression: %1 result: %2", (Object)regex, (Object)result);
        return result;
    }

    private static String escapeSpecialCharacterInRegularExpression(String strPattern, String specialCharacter, String escapeCharacterPattern) {
        Pattern pattern = Pattern.compile(specialCharacter);
        Matcher matcher = pattern.matcher(strPattern);
        StringBuffer escapePattern = new StringBuffer();
        int endMatch = -1;
        while (matcher.find()) {
            endMatch = matcher.end();
            escapePattern.append(strPattern.substring(matcher.start(), endMatch - 1));
            escapePattern.append(escapeCharacterPattern);
        }
        if (endMatch > 0) {
            escapePattern.append(strPattern.substring(endMatch));
        } else {
            escapePattern.append(strPattern);
        }
        return escapePattern.toString();
    }

    public static void main(String[] argv) {
        String regex = null;
        String input = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader("C:/WatchedFolder/dev/main/core/src/com/adobe/watchedfolder/core/regex.txt"));
        }
        catch (FileNotFoundException fnfe) {
            log.debug("Cannot locate input file! %1", (Object)fnfe.getMessage());
            System.exit(0);
        }
        try {
            regex = br.readLine();
            input = br.readLine();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        log.debug("Current REGEX is: %1", (Object)regex);
        log.debug("Current INPUT is: %1", (Object)input);
        regex = PathMatcher.escapeSpecialCharacterInRegularExpression(regex);
        Boolean result = new Boolean(PathMatcher.match(regex, input));
        log.debug("Match input: %1", result);
    }
}

