/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.ejb;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.component.ComponentContext;
import com.adobe.idp.dsc.component.LifeCycle;
import com.adobe.idp.dsc.registry.ComponentNotFoundException;
import com.adobe.idp.dsc.registry.DuplicateConnectorException;
import com.adobe.idp.dsc.registry.ServiceNotFoundException;
import com.adobe.idp.dsc.registry.component.client.ComponentRegistryClient;
import com.adobe.idp.dsc.registry.connector.client.ConnectorRegistryClient;
import com.adobe.idp.dsc.registry.infomodel.Component;
import com.adobe.idp.dsc.registry.infomodel.Connector;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.infomodel.impl.ConnectorImpl;
import com.adobe.idp.dsc.registry.service.CreateServiceConfigurationInfo;
import com.adobe.idp.dsc.registry.service.client.ServiceRegistryClient;
import com.adobe.idp.dsc.util.DOMUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LifeCycleImpl
implements LifeCycle {
    private ComponentContext m_ctx;
    protected static final String SERVICES_ELM = "services";
    protected static final String SERVICE_ELM = "service";
    protected static final Element[] EMPTY_ELEMENT_ARRAY = new Element[0];
    protected static final String NAME_ATTR = "name";
    protected static final String COMPONENT_ID_ELEMENT = "component-id";
    private static final Logger log = Logger.getLogger(LifeCycleImpl.class.getName());

    public void setComponentContext(ComponentContext aContext) {
        this.m_ctx = aContext;
    }

    public void onStart() {
        block7: {
            ServiceClientFactory _svcClientFactory = this.getServiceClientFactory();
            try {
                ConnectorRegistryClient _connectorRegistry = null;
                Component _component = this.getComponent(_svcClientFactory);
                String[] _serviceNames = this.getServiceNames();
                for (int i = 0; i < _serviceNames.length; ++i) {
                    this.deployService(_svcClientFactory, _component, _serviceNames[i]);
                }
                String _connectorId = this.getConnectorName();
                Connector _connector = null;
                if (_connectorId == null) break block7;
                _connectorRegistry = new ConnectorRegistryClient(_svcClientFactory);
                try {
                    _connector = _connectorRegistry.getConnector(_connectorId);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (_connector == null) {
                    _connector = new ConnectorImpl();
                    ((ConnectorImpl)_connector).setId(_serviceNames[0]);
                    ((ConnectorImpl)_connector).setDisplayName(this.getComponentName());
                    ((ConnectorImpl)_connector).setSupportMultipleServiceEndpoints(false);
                    ((ConnectorImpl)_connector).setSupportEndpointCategory(false);
                    _connectorRegistry.create(_connector);
                }
            }
            catch (ComponentNotFoundException e) {
                log.log(Level.SEVERE, "LifeCycleImpl:onStart:ComponentNotFoundException:" + e.getMessage());
                throw new DSCRuntimeException(e);
            }
            catch (DuplicateConnectorException e) {
                log.log(Level.SEVERE, "LifeCycleImpl:onStart:DuplicateConnectorException:" + e.getMessage());
            }
        }
    }

    public void onStop() {
        log.entering("LifeCycleImpl", "onStop");
    }

    protected ServiceClientFactory getServiceClientFactory() {
        return ServiceClientFactory.createInstance();
    }

    protected Component getComponent(ServiceClientFactory aSvcClientFactory) throws ComponentNotFoundException {
        String _componentId = null;
        String _componentVersion = null;
        _componentId = this.m_ctx.getComponent().getComponentId();
        _componentVersion = this.m_ctx.getComponent().getVersion();
        ComponentRegistryClient _componentRegistry = new ComponentRegistryClient(aSvcClientFactory);
        return _componentRegistry.getComponent(_componentId, _componentVersion);
    }

    protected void deployService(ServiceClientFactory aSvcClientFactory, Component aComponent, String aServiceName) {
        try {
            ServiceConfiguration _serviceConfiguration = null;
            ServiceRegistryClient _svcRegClient = new ServiceRegistryClient(aSvcClientFactory);
            try {
                _serviceConfiguration = _svcRegClient.getHeadActiveConfiguration(aServiceName);
            }
            catch (ServiceNotFoundException ex) {
                // empty catch block
            }
            if (_serviceConfiguration == null) {
                Element _descriptor = aComponent.getServiceDescriptor(aServiceName);
                CreateServiceConfigurationInfo _configInfo = new CreateServiceConfigurationInfo();
                _configInfo.setComponentId(aComponent.getComponentId());
                _configInfo.setComponentVersion(aComponent.getVersion());
                _configInfo.setServiceId(aServiceName);
                _configInfo.setMajorVersion(1);
                _configInfo.setMinorVersion(0);
                _configInfo.setStartWithComponent(true);
                _configInfo.setDescriptor(DOMUtil.toString(_descriptor));
                _svcRegClient.createAndDeploy(_configInfo, null);
            }
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    protected void undeployService(ServiceClientFactory aSvcClientFactory, String aServiceName) throws DSCException {
        ServiceConfiguration _serviceConfiguration = null;
        ServiceRegistryClient _svcRegClient = new ServiceRegistryClient(aSvcClientFactory);
        try {
            _serviceConfiguration = _svcRegClient.getHeadActiveConfiguration(aServiceName);
            if (_serviceConfiguration != null) {
                _svcRegClient.undeploy(_serviceConfiguration);
            }
            ConnectorRegistryClient _connectorRegistry = new ConnectorRegistryClient(aSvcClientFactory);
            Connector _connector = _connectorRegistry.getConnector(this.getComponentName());
            _connectorRegistry.remove(_connector);
        }
        catch (ServiceNotFoundException ex) {
        }
        catch (Exception e) {
            if (e instanceof DSCException) {
                throw (DSCException)e;
            }
            throw new DSCRuntimeException(e);
        }
    }

    protected String getConnectorName() {
        Element[] _servicesElms = this.getServiceDescriptors();
        if (_servicesElms != null && _servicesElms.length > 0) {
            return DOMUtil.getTextForNode(_servicesElms[0].getAttributeNode(NAME_ATTR));
        }
        return null;
    }

    protected String[] getServiceNames() {
        Element[] _serviceElms = this.getServiceDescriptors();
        String[] _serviceNames = new String[_serviceElms.length];
        for (int i = 0; i < _serviceElms.length; ++i) {
            _serviceNames[i] = DOMUtil.getTextForNode(_serviceElms[i].getAttributeNode(NAME_ATTR));
        }
        return _serviceNames;
    }

    protected Element[] getServiceDescriptors() {
        Document _document = this.m_ctx.getComponent().getComponentDescriptor();
        Element _servicesElm = DOMUtil.getChildElement(_document.getDocumentElement(), SERVICES_ELM);
        if (_servicesElm != null) {
            return DOMUtil.getChildElements(_servicesElm, SERVICE_ELM);
        }
        return EMPTY_ELEMENT_ARRAY;
    }

    protected String getComponentId() {
        Document _document = this.m_ctx.getComponent().getComponentDescriptor();
        Element _root = _document.getDocumentElement();
        return DOMUtil.getRequiredTextForChild(_root, COMPONENT_ID_ELEMENT);
    }

    protected String getComponentName() {
        String _componentId = this.getComponentId();
        return _componentId.substring(_componentId.lastIndexOf(".") + 1);
    }
}

