/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.service.ejb;

import com.adobe.idp.dsc.component.Bootstrap;
import com.adobe.idp.dsc.component.BootstrapContext;
import com.adobe.idp.dsc.util.DOMUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BootstrapImpl
implements Bootstrap {
    private static final Logger log = Logger.getLogger(BootstrapImpl.class.getName());
    protected static final String COMPONENT_ID_ELEMENT = "component-id";
    private BootstrapContext m_ctx;

    public void setBootstrapContext(BootstrapContext aCtx) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Set bootstrap context: " + aCtx.getComponent().getComponentId());
        }
        this.m_ctx = aCtx;
    }

    public void onUnInstall() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Called onUnInstall: " + this.m_ctx.getComponent().getComponentId());
        }
    }

    public void onInstall() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Called onInstall: " + this.m_ctx.getComponent().getComponentId());
        }
    }

    protected String getComponentId() {
        Document _document = this.m_ctx.getComponent().getComponentDescriptor();
        Element _root = _document.getDocumentElement();
        return DOMUtil.getRequiredTextForChild(_root, COMPONENT_ID_ELEMENT);
    }

    protected String getComponentName() {
        String _componentId = this.getComponentId();
        return _componentId.substring(_componentId.lastIndexOf(".") + 1);
    }
}

