/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.impl.vm;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.InvocationContext;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties;
import com.adobe.idp.dsc.datatype.impl.NonManagedTypeConverter;
import com.adobe.idp.dsc.engine.impl.ServiceEngineImpl;
import com.adobe.idp.dsc.impl.InvocationRequestImpl;
import com.adobe.idp.dsc.impl.InvocationResponseImpl;
import com.adobe.idp.dsc.provider.impl.base.AbstractMessageDispatcher;
import com.adobe.idp.dsc.provider.impl.vm.VMMessageReceiver;
import com.adobe.idp.dsc.registry.infomodel.InputParameter;
import com.adobe.idp.dsc.registry.infomodel.Operation;
import com.adobe.idp.dsc.registry.infomodel.OutputParameter;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.util.IOUtil;
import com.adobe.idp.dsc.util.PerfMonitor;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.logging.AdobeLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VMMessageDispatcher
extends AbstractMessageDispatcher {
    protected static final Logger logger = AdobeLogger.getAdobeLogger(VMMessageDispatcher.class);
    private static VMMessageReceiver m_messageReceiver;

    public VMMessageDispatcher(String aEndpointURI) {
        super(aEndpointURI);
        if (m_messageReceiver == null) {
            m_messageReceiver = new VMMessageReceiver();
        }
    }

    public void doDispatch(InvocationRequest req) {
        throw new UnsupportedOperationException("doDispatch is not supported.");
    }

    public InvocationResponse doSend(InvocationRequest request) throws DSCException {
        Object _monitor = PerfMonitor.startPrimary(this.getClass().getName(), "doSend()");
        try {
            StringBuffer _msg;
            InvocationRequestImpl _request = (InvocationRequestImpl)request;
            InvocationContext _ctx = InvocationContext.getInstance();
            InvocationResponseImpl _response = null;
            String _passthroughStrategy = (String)request.getProperty(ServiceClientFactoryProperties.DSC_IN_VM_PASSTHROUGH_STRATEGY);
            if (TextUtil.isEmpty(_passthroughStrategy)) {
                _passthroughStrategy = ServiceClientFactoryProperties.DSC_DIRECT_PASSTHROUGH;
            }
            if (_passthroughStrategy.equals(ServiceClientFactoryProperties.DSC_PASSTHROUGH_BY_PROXY)) {
                Exception newEx;
                byte[] _buff;
                if (logger.isLoggable(Level.FINE)) {
                    _msg = new StringBuffer("VMMessageDispatcher:doSend(");
                    _msg.append(request.getServiceName());
                    _msg.append('.');
                    _msg.append(request.getOperationName());
                    _msg.append(',');
                    _msg.append("passthrough-strategy=");
                    _msg.append(_passthroughStrategy);
                    _msg.append(") ");
                    _msg.append("proxying parameters");
                    logger.log(Level.FINE, _msg.toString());
                }
                ServiceConfiguration _config = ServiceEngineImpl.resolveConfiguration((String)_request.getServiceName(), (String)_request.getServiceExplicitVersion(), (String)_request.getServiceOriginalVersion());
                _request.setTargetServiceConfiguration(_config);
                ClassLoader _cl = DSContainer.getInstance().getClassLoaderForServiceConfiguration(_config.getServiceId(), (int)_config.getMajorVersion(), (int)_config.getMinorVersion());
                Iterator _inKeysIter = _request.getInputParameters().keySet().iterator();
                Operation _op = _config.getOperation(_request.getOperationName());
                if (_ctx == null) {
                    HashMap<String, Object> _newInputParams = new HashMap<String, Object>(_request.getInputParameters().size());
                    while (_inKeysIter.hasNext()) {
                        String _key = (String)_inKeysIter.next();
                        InputParameter _param = _op.getInputParameter(_key);
                        String _type = _param.getType();
                        Class<?> _expectedType = null;
                        try {
                            _expectedType = _cl.loadClass(_type);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new DSCRuntimeException(ex);
                        }
                        Object _val = _request.getInputParameters().get(_key);
                        Object _proxiedVal = NonManagedTypeConverter.getInstance().convert(_expectedType, _val, _cl);
                        _newInputParams.put(_key, _proxiedVal);
                    }
                    _request.setInputParameters(_newInputParams);
                }
                try {
                    _response = (InvocationResponseImpl)m_messageReceiver.routeMessage(request);
                }
                catch (DSCException ex) {
                    _buff = IOUtil.writeObject2ByteArray(ex);
                    newEx = (DSCException)IOUtil.readObjectFromByteArray(_buff, Thread.currentThread().getContextClassLoader());
                    throw newEx;
                }
                catch (RuntimeException ex) {
                    _buff = IOUtil.writeObject2ByteArray(ex);
                    newEx = (RuntimeException)IOUtil.readObjectFromByteArray(_buff, Thread.currentThread().getContextClassLoader());
                    throw newEx;
                }
                Iterator _outKeysIter = _response.getOutputParameters().keySet().iterator();
                HashMap<String, Object> _newOutputParams = new HashMap<String, Object>(_response.getOutputParameters().size());
                while (_outKeysIter.hasNext()) {
                    String _key = (String)_outKeysIter.next();
                    OutputParameter _param = _op.getOutputParameter(_key);
                    String _type = _param.getType();
                    Class<?> _expectedType = null;
                    try {
                        _expectedType = Thread.currentThread().getContextClassLoader().loadClass(_type);
                    }
                    catch (ClassNotFoundException ex) {
                        throw new DSCRuntimeException(ex);
                    }
                    Object _val = _response.getOutputParameters().get(_key);
                    Object _proxiedVal = NonManagedTypeConverter.getInstance().convert(_expectedType, _val, Thread.currentThread().getContextClassLoader());
                    _newOutputParams.put(_key, _proxiedVal);
                }
                _response.setOutputParameters(_newOutputParams);
            } else if (_passthroughStrategy.equals(ServiceClientFactoryProperties.DSC_PASSTHROUGH_BY_SERIALIZATION)) {
                if (logger.isLoggable(Level.FINE)) {
                    _msg = new StringBuffer("VMMessageDispatcher:doSend(");
                    _msg.append(request.getServiceName());
                    _msg.append('.');
                    _msg.append(request.getOperationName());
                    _msg.append(',');
                    _msg.append("passthrough-strategy=");
                    _msg.append(_passthroughStrategy);
                    _msg.append(") ");
                    _msg.append("serializing/deserializing parameters");
                    logger.log(Level.FINE, _msg.toString());
                }
                byte[] _buff = IOUtil.writeObject2ByteArray(_request);
                ServiceConfiguration _config = ServiceEngineImpl.resolveConfiguration((String)_request.getServiceName(), (String)_request.getServiceExplicitVersion(), (String)_request.getServiceOriginalVersion());
                _request.setTargetServiceConfiguration(_config);
                ClassLoader _cl = DSContainer.getInstance().getClassLoaderForServiceConfiguration(_config.getServiceId(), (int)_config.getMajorVersion(), (int)_config.getMinorVersion());
                _request = (InvocationRequestImpl)IOUtil.readObjectFromByteArray(_buff, _cl);
                try {
                    _response = (InvocationResponseImpl)m_messageReceiver.routeMessage(_request);
                }
                catch (DSCException ex) {
                    _buff = IOUtil.writeObject2ByteArray(ex);
                    DSCException newEx = (DSCException)IOUtil.readObjectFromByteArray(_buff, Thread.currentThread().getContextClassLoader());
                    throw newEx;
                }
                catch (RuntimeException ex) {
                    _buff = IOUtil.writeObject2ByteArray(ex);
                    RuntimeException newEx = (RuntimeException)IOUtil.readObjectFromByteArray(_buff, Thread.currentThread().getContextClassLoader());
                    throw newEx;
                }
                _buff = IOUtil.writeObject2ByteArray(_response);
                _response = (InvocationResponseImpl)IOUtil.readObjectFromByteArray(_buff, Thread.currentThread().getContextClassLoader());
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    _msg = new StringBuffer("VMMessageDispatcher:doSend(");
                    _msg.append(request.getServiceName());
                    _msg.append('.');
                    _msg.append(request.getOperationName());
                    _msg.append(',');
                    _msg.append("passthrough-strategy=");
                    _msg.append(_passthroughStrategy);
                    _msg.append(") ");
                    _msg.append("direct passthrough");
                    logger.log(Level.FINE, _msg.toString());
                }
                _response = (InvocationResponseImpl)m_messageReceiver.routeMessage(request);
            }
            InvocationResponseImpl invocationResponseImpl = _response;
            return invocationResponseImpl;
        }
        catch (DSCException ex) {
            PerfMonitor.addException(_monitor, ex.getClass().getName());
            throw ex;
        }
        catch (RuntimeException ex) {
            PerfMonitor.addException(_monitor, ex.getClass().getName());
            throw ex;
        }
        finally {
            PerfMonitor.stop(_monitor);
        }
    }
}

