/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.impl.soap.axis.sdk;

import com.adobe.idp.DocumentManagerClient;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.net.DSCBindException;
import com.adobe.idp.dsc.net.DSCConnectException;
import com.adobe.idp.dsc.net.DSCHttpRetryException;
import com.adobe.idp.dsc.net.DSCMalformedURLException;
import com.adobe.idp.dsc.net.DSCNoRouteToHostException;
import com.adobe.idp.dsc.net.DSCPortUnreachableException;
import com.adobe.idp.dsc.net.DSCProtocolException;
import com.adobe.idp.dsc.net.DSCSocketException;
import com.adobe.idp.dsc.net.DSCSocketTimeoutException;
import com.adobe.idp.dsc.net.DSCURISyntaxException;
import com.adobe.idp.dsc.net.DSCUnknownHostException;
import com.adobe.idp.dsc.net.DSCUnknownServiceException;
import com.adobe.idp.dsc.provider.impl.base.AbstractMessageDispatcher;
import com.adobe.idp.dsc.provider.impl.soap.axis.sdk.SoapSdkBindingStubUtil;
import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.soap.SOAPConstants;

public class SoapAxisDispatcher
extends AbstractMessageDispatcher {
    protected boolean initialized;
    protected boolean disposed;
    private String m_soapProviderUrl;
    private static final String providerUrlRelContext = "soap/sdk";

    public SoapAxisDispatcher(String aEndpointURI) {
        super(aEndpointURI);
        if (aEndpointURI != null) {
            this.setSoapProviderUrl(aEndpointURI);
        }
    }

    private Call createAxisCall(String url) throws DSCException {
        Call call;
        try {
            call = new Call(url);
        }
        catch (MalformedURLException e) {
            throw new DSCMalformedURLException(e);
        }
        OperationDesc oper = new OperationDesc();
        oper.setName("invoke");
        ParameterDesc param = new ParameterDesc(new QName("", "in"), 1, new QName("http://schemas.xmlsoap.org/soap/encoding/", "base64Binary"), byte[].class, false, false);
        oper.addParameter(param);
        oper.setReturnType(new QName("http://schemas.xmlsoap.org/soap/encoding/", "base64Binary"));
        oper.setReturnClass(byte[].class);
        oper.setReturnQName(new QName("", "invokeReturn"));
        oper.setStyle(Style.RPC);
        oper.setUse(Use.ENCODED);
        call.setOperation(oper);
        call.setUseSOAPAction(true);
        call.setSOAPActionURI("");
        call.setSOAPVersion((SOAPConstants)SOAPConstants.SOAP11_CONSTANTS);
        call.setOperationName(new QName("http://sdk.axis.soap.impl.provider.dsc.idp.adobe.com", "invoke"));
        return call;
    }

    public InvocationResponse doSend(InvocationRequest request) throws DSCException {
        byte[] ret;
        if (this.disposed) {
            throw new IllegalStateException("Invalid state.  Dispatcher has been disposed.");
        }
        String providerUrl = this.getSoapProviderUrl();
        Call call = this.createAxisCall(providerUrl);
        byte[] serializedRequest = SoapSdkBindingStubUtil.serializeRequest(call, request);
        try {
            ret = (byte[])call.invoke(new Object[]{serializedRequest});
        }
        catch (RemoteException _ex) {
            this.throwExceptionHandler(_ex);
            throw new DSCRuntimeException(_ex);
        }
        return SoapSdkBindingStubUtil.deSerializeResponse(call, ret);
    }

    public void doDispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void doDispatch(InvocationRequest req) {
        throw new UnsupportedOperationException("doDispatch is not a supported method.");
    }

    public void setSoapProviderUrl(String soapProviderUrl) {
        String localProviderUrl = "";
        localProviderUrl = soapProviderUrl.endsWith("/") ? soapProviderUrl + providerUrlRelContext : soapProviderUrl + "/" + providerUrlRelContext;
        this.m_soapProviderUrl = localProviderUrl;
        DocumentManagerClient.setHttpRoot(soapProviderUrl);
    }

    public String getSoapProviderUrl() {
        if (this.m_soapProviderUrl == null) {
            throw new RuntimeException("Soap Axis Connector failed to get SOAP Provider URL");
        }
        return this.m_soapProviderUrl;
    }

    private void throwExceptionHandler(Throwable aThrowable) throws DSCRuntimeException {
        Throwable _ex2 = aThrowable.getCause();
        if (_ex2 != null) {
            if (_ex2 instanceof BindException) {
                throw new DSCBindException(_ex2);
            }
            if (_ex2 instanceof ConnectException) {
                throw new DSCConnectException(_ex2);
            }
            if (_ex2 instanceof HttpRetryException) {
                throw new DSCHttpRetryException(_ex2);
            }
            if (_ex2 instanceof MalformedURLException) {
                throw new DSCMalformedURLException(_ex2);
            }
            if (_ex2 instanceof NoRouteToHostException) {
                throw new DSCNoRouteToHostException(_ex2);
            }
            if (_ex2 instanceof PortUnreachableException) {
                throw new DSCPortUnreachableException(_ex2);
            }
            if (_ex2 instanceof ProtocolException) {
                throw new DSCProtocolException(_ex2);
            }
            if (_ex2 instanceof SocketException) {
                throw new DSCSocketException(_ex2);
            }
            if (_ex2 instanceof SocketTimeoutException) {
                throw new DSCSocketTimeoutException(_ex2);
            }
            if (_ex2 instanceof UnknownHostException) {
                throw new DSCUnknownHostException(_ex2);
            }
            if (_ex2 instanceof UnknownServiceException) {
                throw new DSCUnknownServiceException(_ex2);
            }
            if (_ex2 instanceof URISyntaxException) {
                throw new DSCURISyntaxException(_ex2);
            }
        }
        throw new DSCRuntimeException(aThrowable);
    }
}

