/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.impl.ejb;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.InvocationContext;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.engine.impl.ServiceEngineImpl;
import com.adobe.idp.dsc.net.DSCIllegalStateException;
import com.adobe.idp.dsc.net.DSCNamingException;
import com.adobe.idp.dsc.provider.impl.base.AbstractMessageDispatcher;
import com.adobe.idp.dsc.provider.impl.base.AbstractMessageReceiver;
import com.adobe.idp.dsc.provider.impl.ejb.EjbRequestHolder;
import com.adobe.idp.dsc.provider.impl.ejb.EjbResponseHolder;
import com.adobe.idp.dsc.provider.impl.ejb.receiver.Invocation;
import com.adobe.idp.dsc.provider.impl.ejb.receiver.InvocationHome;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.idp.dsc.util.ClassLoaderAwareObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class EjbMessageDispatcher
extends AbstractMessageDispatcher {
    protected boolean initialized;
    protected boolean disposed;
    protected Invocation invocationRemote;
    protected Method invokedMethod;
    private static final String DEFAULT_INVOKE_SERVICE_NAME = "ejb/Invocation";
    private static final String DEFAULT_INVOKE_METHOD_NAME = "invoke";
    private static final Class[] DEFAULT_INVOKE_PARAMETER_TYPES = new Class[]{EjbRequestHolder.class};
    private String m_jndiInitialFactory;
    private String m_jndiUrlPkgPrefixes;
    private String m_jndiProviderUrl;
    private Context m_jndiContext;
    private static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public EjbMessageDispatcher(String aEndpointURI) {
        super(aEndpointURI);
    }

    protected void initialise(InvocationRequest request) throws IOException, NotBoundException, NoSuchMethodException, ClassNotFoundException, NamingException {
        if (!this.initialized) {
            try {
                Context context = this.getJndiContext();
                Object ref = context.lookup(DEFAULT_INVOKE_SERVICE_NAME);
                InvocationHome theHome = (InvocationHome)PortableRemoteObject.narrow((Object)ref, InvocationHome.class);
                this.invocationRemote = theHome.create();
            }
            catch (IllegalStateException e) {
                throw new DSCIllegalStateException(31, (Throwable)e);
            }
            catch (NamingException e) {
                throw new DSCNamingException(31, (Throwable)e);
            }
            catch (Exception e) {
                throw new RemoteException("Remote EJBObject lookup failed for 'ejb/Invocation'", e);
            }
            this.initialized = true;
        }
    }

    private Object invoke(Class clazz, Object theRemote, String methodName) throws IllegalAccessException, InvocationTargetException {
        Method[] methods = clazz.getMethods();
        String name = null;
        Object result = null;
        for (int i = 0; i < methods.length; ++i) {
            name = methods[i].getName();
            if (!name.startsWith(methodName)) continue;
            Class<?>[] parameterTypes = methods[i].getParameterTypes();
            result = methods[i].invoke(theRemote, null);
        }
        return result;
    }

    public InvocationResponse doSend(InvocationRequest request) throws DSCException {
        if (this.disposed) {
            throw new IllegalStateException("Invalid state.  Dispatcher has been disposed.");
        }
        try {
            this.initialise(request);
            ByteArrayOutputStream _serializedRequest = new ByteArrayOutputStream();
            ObjectOutputStream _out = new ObjectOutputStream(_serializedRequest);
            _out.writeObject(request);
            _out.flush();
            _out.close();
            EjbRequestHolder _requestHolder = new EjbRequestHolder(request.getServiceName(), request.getOperationName(), request.getServiceExplicitVersion(), request.getServiceOriginalVersion(), _serializedRequest.toByteArray());
            EjbResponseHolder _responseHolder = this.invocationRemote.invoke(_requestHolder);
            ClassLoader _dscClassLoader = Thread.currentThread().getContextClassLoader();
            if (InvocationContext.getInstance() != null) {
                ServiceConfiguration _sc = ServiceEngineImpl.resolveConfiguration((String)_requestHolder.getServiceName(), (String)_requestHolder.getTargetVersion(), (String)_requestHolder.getCompatibleVersion());
                _dscClassLoader = AbstractMessageReceiver.getClassAwareClassLoader(_sc);
            }
            _responseHolder.handleException(_dscClassLoader);
            ByteArrayInputStream _serializedResponse = new ByteArrayInputStream(_responseHolder.getInvocationResponseByteArray());
            ClassLoaderAwareObjectInputStream _in = new ClassLoaderAwareObjectInputStream(_serializedResponse, _dscClassLoader);
            return (InvocationResponse)_in.readObject();
        }
        catch (DSCException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (RemoteException _ex) {
            throw new DSCRuntimeException(_ex);
        }
        catch (Throwable ex) {
            throw new DSCException(ex);
        }
    }

    public void doDispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void doDispatch(InvocationRequest req) {
        throw new UnsupportedOperationException("doDispatch is not a supported method.");
    }

    private boolean inContainer() {
        Class _cls = null;
        try {
            _cls = ClassHelper.loadClass("com.adobe.idp.dsc.DSContainer", this.getClass());
            Method _method = _cls.getMethod("isAvailable", EMPTY_CLASS_ARRAY);
            Boolean _available = (Boolean)_method.invoke((Object)_cls, EMPTY_OBJECT_ARRAY);
            return _available;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    protected void initJndiContext() throws NamingException {
        if (null == this.m_jndiContext) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (null != this.m_jndiInitialFactory) {
                props.put("java.naming.factory.initial", this.m_jndiInitialFactory);
            }
            if (this.m_jndiProviderUrl != null) {
                props.put("java.naming.provider.url", this.m_jndiProviderUrl);
            }
            if (this.m_jndiUrlPkgPrefixes != null) {
                props.put("java.naming.factory.url.pkgs", this.m_jndiUrlPkgPrefixes);
            }
            this.m_jndiContext = new InitialContext(props);
            Document.setInitialContext((InitialContext)this.m_jndiContext);
        }
    }

    public Context getJndiContext(String jndiProviderUrl) throws NamingException {
        this.setJndiProviderUrl(jndiProviderUrl);
        return this.getJndiContext();
    }

    public Context getJndiContext() throws NamingException {
        this.initJndiContext();
        return this.m_jndiContext;
    }

    public void setJndiContext(Context jndiContext) {
        this.m_jndiContext = jndiContext;
    }

    public void setJndiInitialFactory(String jndiInitialFactory) {
        this.m_jndiInitialFactory = jndiInitialFactory;
    }

    public String getJndiInitialFactory() {
        return this.m_jndiInitialFactory;
    }

    public void setJndiUrlPkgPrefixes(String jndiUrlPkgPrefixes) {
        this.m_jndiUrlPkgPrefixes = jndiUrlPkgPrefixes;
    }

    public String getJndiUrlPkgPrefixes() {
        return this.m_jndiUrlPkgPrefixes;
    }

    public String getJndiProviderUrl() {
        return this.m_jndiProviderUrl;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.m_jndiProviderUrl = jndiProviderUrl;
    }
}

