/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.impl.base;

import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCNotSerializableException;
import com.adobe.idp.dsc.ExceptionStackTrace;
import com.adobe.idp.dsc.util.ClassLoaderAwareObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.ServerException;

public abstract class AbstractResponseHolder
implements Serializable {
    public static final long serialVersionUID = 8695146383723654671L;
    private byte[] m_content;
    private String m_exceptionStackTrace;

    public boolean containsThrowable() {
        return this.m_exceptionStackTrace != null;
    }

    public boolean containsInvocationResponse() {
        return this.m_exceptionStackTrace == null;
    }

    public byte[] getInvocationResponseByteArray() {
        return this.containsInvocationResponse() ? this.m_content : null;
    }

    public void setInvocationResponseByteArray(byte[] aBuff) {
        this.m_content = aBuff;
    }

    public byte[] getThrowableByteArray() {
        return this.containsThrowable() ? this.m_content : null;
    }

    public String getThrowableStackTrace() {
        return this.m_exceptionStackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThrowable(Throwable aException) throws IOException {
        ByteArrayOutputStream _out = null;
        try {
            _out = new ByteArrayOutputStream();
            ObjectOutputStream _oout = new ObjectOutputStream(_out);
            _oout.writeObject(aException);
            _oout.flush();
            _oout.close();
            this.m_content = _out.toByteArray();
            this.m_exceptionStackTrace = new ExceptionStackTrace(aException).getStackTrace();
        }
        finally {
            if (_out != null) {
                _out.close();
            }
        }
    }

    public void handleException(ClassLoader aClassLoader) throws DSCException {
        try {
            if (this.containsThrowable()) {
                try {
                    ByteArrayInputStream _serializedResponse = new ByteArrayInputStream(this.getThrowableByteArray());
                    ClassLoaderAwareObjectInputStream _in = new ClassLoaderAwareObjectInputStream(_serializedResponse, aClassLoader);
                    Throwable _throwable = (Throwable)_in.readObject();
                    throw _throwable;
                }
                catch (ClassNotFoundException _ex) {
                    throw new DSCNotSerializableException(this.getThrowableStackTrace());
                }
            }
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof ServerException) {
                cause = ((ServerException)cause).getCause();
            }
            if (cause instanceof DSCException) {
                DSCException _dscEx = (DSCException)cause;
                throw _dscEx;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new DSCException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (DSCException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new DSCException(ex);
        }
    }
}

