/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.provider.impl.base;

import com.adobe.idp.Context;
import com.adobe.idp.dsc.DSCAuthenticationException;
import com.adobe.idp.dsc.DSCError;
import com.adobe.idp.dsc.DSCException;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.DSContainer;
import com.adobe.idp.dsc.InvocationContext;
import com.adobe.idp.dsc.InvocationRequest;
import com.adobe.idp.dsc.InvocationResponse;
import com.adobe.idp.dsc.authentication.Credential;
import com.adobe.idp.dsc.authentication.PasswordCredential;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactoryProperties;
import com.adobe.idp.dsc.impl.InvocationRequestImpl;
import com.adobe.idp.dsc.provider.MessageReceiver;
import com.adobe.idp.dsc.provider.impl.base.AbstractResponseHolder;
import com.adobe.idp.dsc.registry.EndpointNotEnabledException;
import com.adobe.idp.dsc.registry.endpoint.EndpointRegistry;
import com.adobe.idp.dsc.registry.infomodel.Endpoint;
import com.adobe.idp.dsc.registry.infomodel.Operation;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.routing.Router;
import com.adobe.idp.dsc.util.PerfMonitor;
import com.adobe.idp.dsc.util.TextUtil;
import com.adobe.idp.um.api.AuthenticationManager;
import com.adobe.idp.um.api.UMException;
import com.adobe.idp.um.api.UMFactory;
import com.adobe.idp.um.api.infomodel.AuthResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;

public abstract class AbstractMessageReceiver
implements MessageReceiver {
    private static String[] m_defaultProviderIds = new String[]{"EJB", "SOAP"};

    public final InvocationResponse routeMessage(InvocationRequest aRequest) throws DSCException {
        if (InvocationContext.getInstance() == null || aRequest.getInvocationContext() == null) {
            AbstractMessageReceiver.authenticate(aRequest);
        }
        InvocationResponse _response = new Router().routeRequest(aRequest);
        Context _ctx = aRequest.getInvocationContext();
        if (_ctx != null) {
            _response.setProperty(ServiceClientFactoryProperties.DSC_CONTEXT, _ctx);
        }
        return _response;
    }

    public static final void authenticate(InvocationRequest aRequest) throws DSCException {
        AuthResult _ar = null;
        Credential _credential = null;
        Context _ctx = null;
        Object _monitor = PerfMonitor.start("com.adobe.idp.dsc.provider.impl.base.AbstractMessageReceiver", "authenticate()");
        try {
            _credential = (Credential)aRequest.getProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL);
            _ctx = aRequest.getInvocationContext();
            if (_ctx != null) {
                UMFactory _fact = UMFactory.getLocalInstance();
                AuthenticationManager _am = _fact.getAuthenticationManager();
                _ctx = _am.validateAssertion(_ctx);
            } else if (_credential != null) {
                int _type = _credential.getCredentialType();
                switch (_type) {
                    case 0: {
                        UMFactory _fact = UMFactory.getLocalInstance();
                        AuthenticationManager _am = _fact.getAuthenticationManager();
                        _ctx = new Context();
                        PasswordCredential pCred = (PasswordCredential)_credential;
                        _ar = _am.authenticate(pCred.getUserName(), pCred.getPassword().getBytes());
                        break;
                    }
                    default: {
                        throw new DSCException(new DSCError(211));
                    }
                }
                if (_ar == null) {
                    throw new DSCAuthenticationException(215);
                }
                _ctx.initPrincipal(_ar);
                aRequest.setProperty("DSC_CONTEXT", _ctx);
            }
        }
        catch (UMException e) {
            throw new DSCAuthenticationException(215, (Throwable)e);
        }
        finally {
            PerfMonitor.stop(_monitor);
        }
    }

    public static ClassLoader getClassAwareClassLoader(String aServiceId) throws DSCException {
        ServiceConfiguration _config = DSContainer.getInstance().getInternalServiceRegistry().getHeadActiveConfiguration(aServiceId);
        return DSContainer.getInstance().getClassLoaderForServiceConfiguration(_config.getServiceId(), (int)_config.getMajorVersion(), (int)_config.getMinorVersion());
    }

    public static ClassLoader getClassAwareClassLoader(ServiceConfiguration aConfig) throws DSCException {
        return DSContainer.getInstance().getClassLoaderForComponent(aConfig.getComponentId(), aConfig.getComponentVersion());
    }

    public static void validateEndpoint(ServiceConfiguration aServiceConfig, String aOperationName, String aConnectorType) throws DSCException {
        boolean _supportedConnector;
        String _serviceId;
        block6: {
            String[] _supportedConnectorIds;
            block8: {
                block7: {
                    String _operationName;
                    _serviceId = aServiceConfig.getServiceId();
                    _supportedConnector = false;
                    boolean _isDefaultProvider = AbstractMessageReceiver.isDefaultProvider(aConnectorType);
                    String string = _operationName = _isDefaultProvider ? "*" : aOperationName;
                    if (_serviceId.equalsIgnoreCase("system.service_registry") || _serviceId.equalsIgnoreCase("system.component_registry") || _serviceId.equalsIgnoreCase("system.property_editor_registry") || _serviceId.equalsIgnoreCase("system.data_type_registry") || _serviceId.equalsIgnoreCase("system.security_profile_manager") || _serviceId.equalsIgnoreCase("system.endpoint_registry") || _serviceId.equalsIgnoreCase("system.connector_registry") || _serviceId.equalsIgnoreCase("DSC_ComponentRegistry") || _serviceId.equalsIgnoreCase("DSC_ServiceRegistry")) {
                        _supportedConnector = true;
                    } else {
                        String[] _supportedConnectorIds2;
                        String _validateEndpointSetting;
                        DSContainer _container = DSContainer.getInstance();
                        EndpointRegistry _endpointRegistry = _container.getEndpointRegistry();
                        List _endpoints = _endpointRegistry.getServiceConnectorEndpoints(_serviceId, _operationName, aConnectorType, null);
                        for (Endpoint _endpoint : _endpoints) {
                            if (!_endpoint.getConnectorId().equalsIgnoreCase(aConnectorType) || !_endpoint.isEnabled()) continue;
                            _supportedConnector = true;
                            break;
                        }
                        if (_endpoints.size() == 0 && !TextUtil.isEmpty(_validateEndpointSetting = System.getProperty("com.adobe.idp.dsc.provider.endpointValidation")) && (_supportedConnectorIds2 = aServiceConfig.getSupportedConnectorIds()) != null && _supportedConnectorIds2.length == 0) {
                            boolean bl = _supportedConnector = !Boolean.parseBoolean(_validateEndpointSetting);
                        }
                    }
                    if (!_supportedConnector || !_isDefaultProvider || aOperationName == null) break block6;
                    Operation _operation = aServiceConfig.getOperation(aOperationName);
                    _supportedConnectorIds = _operation.getSupportedConnectorIds();
                    if (_supportedConnectorIds != null) break block7;
                    _supportedConnector = true;
                    break block6;
                }
                if (_supportedConnectorIds.length != 0) break block8;
                String _validateEndpointSetting = System.getProperty("com.adobe.idp.dsc.provider.endpointValidation");
                _supportedConnector = false;
                if (TextUtil.isEmpty(_validateEndpointSetting)) break block6;
                _supportedConnector = !Boolean.parseBoolean(_validateEndpointSetting);
                break block6;
            }
            _supportedConnector = false;
            int _count = _supportedConnectorIds.length;
            for (int j = 0; j < _count; ++j) {
                if (!_supportedConnectorIds[j].equals(aConnectorType)) continue;
                _supportedConnector = true;
                break;
            }
        }
        if (!_supportedConnector) {
            throw new EndpointNotEnabledException(aConnectorType, _serviceId);
        }
    }

    private static boolean isDefaultProvider(String aConnectorId) {
        for (int i = 0; i < m_defaultProviderIds.length; ++i) {
            if (!aConnectorId.endsWith(m_defaultProviderIds[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean invoke(ObjectInputStream reqis, Router router, ByteArrayOutputStream bout, ObjectOutputStream oout, AbstractResponseHolder response, ServiceConfiguration aConfig) throws DSCException {
        InvocationRequestImpl _request;
        try {
            _request = (InvocationRequestImpl)reqis.readObject();
            if (aConfig != null) {
                _request.setTargetServiceConfiguration(aConfig);
            }
            reqis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new DSCRuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            throw new DSCRuntimeException(ex);
        }
        InvocationResponse _response = null;
        try {
            AbstractMessageReceiver.authenticate(_request);
            _response = router.routeRequest(_request);
            if (_request.getInvocationContext() != null && _request.getProperty(ServiceClientFactoryProperties.DSC_CREDENTIAL) != null) {
                _response.setProperty(ServiceClientFactoryProperties.DSC_CONTEXT, _request.getInvocationContext());
            }
        }
        catch (Throwable ex) {
            try {
                response.setThrowable(ex);
                return false;
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
                throw new DSCRuntimeException(ioEx);
            }
        }
        try {
            oout.writeObject(_response);
            oout.flush();
            oout.close();
            response.setInvocationResponseByteArray(bout.toByteArray());
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
            throw new DSCRuntimeException(ioEx);
        }
        return true;
    }
}

