/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.system;

import com.adobe.idp.Document;
import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.datatype.TextSerializer;
import com.adobe.idp.dsc.propertyeditor.PropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.UIComponent;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyEditorComponentImpl;
import com.adobe.idp.dsc.propertyeditor.system.CheckBoxPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.ComboBoxPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.DSServiceInfoPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.DatePropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.DocumentPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.EnumPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.HiddenPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.IntegerPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.ListPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.LongPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.PasswordPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.RadioButtonPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.RepositoryPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.ShortPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.SpinnerPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.TextAreaPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.TextPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.UserPropertyEditorComponent;
import com.adobe.idp.dsc.propertyeditor.system.XMLPropertyEditorComponent;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SystemPropertyEditorRegistry {
    protected static SystemPropertyEditorRegistry instance;
    protected ClassLoader m_defaultClassloader;
    protected Map m_componentsByType;
    protected Map m_componentsById;
    protected static com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent DEFAULT_COMPONENT;
    protected static com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent SPINNER_COMPONENT;

    public static synchronized SystemPropertyEditorRegistry getInstance() {
        if (instance == null) {
            instance = new SystemPropertyEditorRegistry();
        }
        return instance;
    }

    protected SystemPropertyEditorRegistry() {
        this.registerDefaultEditors();
    }

    private void registerDefaultEditors() {
        CheckBoxPropertyEditorComponent _comp = new CheckBoxPropertyEditorComponent();
        this.registerSystemEditorForType("boolean", _comp);
        this.registerSystemEditorForType(Boolean.class.getName(), _comp);
        this.registerSystemEditorForType("string", DEFAULT_COMPONENT);
        this.registerSystemEditorForType(String.class.getName(), DEFAULT_COMPONENT);
        this.registerSystemEditorForType(Document.class.getName(), new DocumentPropertyEditorComponent());
        this.registerSystemEditor(new TextAreaPropertyEditorComponent());
        this.registerSystemEditor(new XMLPropertyEditorComponent());
        this.registerSystemEditor(new ComboBoxPropertyEditorComponent());
        this.registerSystemEditor(new RadioButtonPropertyEditorComponent());
        this.registerSystemEditorForType(Date.class.getName(), new DatePropertyEditorComponent());
        this.registerSystemEditor(new DatePropertyEditorComponent());
        this.registerSystemEditor(new DSServiceInfoPropertyEditorComponent());
        this.registerSystemEditor(new ListPropertyEditorComponent());
        this.registerSystemEditor(new PasswordPropertyEditorComponent());
        this.registerSystemEditor(new RepositoryPropertyEditorComponent());
        this.registerSystemEditor(new UserPropertyEditorComponent());
        this.registerSystemEditor(new EnumPropertyEditorComponent());
        this.registerSystemEditor(new HiddenPropertyEditorComponent());
        this.registerSystemEditorForType("byte", SPINNER_COMPONENT);
        this.registerSystemEditorForType(Byte.class.getName(), SPINNER_COMPONENT);
        this.registerSystemEditorForType(Integer.class.getName(), new IntegerPropertyEditorComponent());
        this.registerSystemEditorForType("int", new IntegerPropertyEditorComponent());
        this.registerSystemEditorForType("integer", new IntegerPropertyEditorComponent());
        this.registerSystemEditorForType("short", new ShortPropertyEditorComponent());
        this.registerSystemEditorForType(Short.class.getName(), new ShortPropertyEditorComponent());
        this.registerSystemEditorForType("long", new LongPropertyEditorComponent());
        this.registerSystemEditorForType(Long.class.getName(), new LongPropertyEditorComponent());
        this.registerSystemEditorForType(BigInteger.class.getName(), SPINNER_COMPONENT);
        this.registerSystemEditorForType(org.w3c.dom.Document.class.getName(), new XMLPropertyEditorComponent());
        this.m_defaultClassloader = this.getClass().getClassLoader();
    }

    private Map getComponentsByTypeMap() {
        if (this.m_componentsByType == null) {
            this.m_componentsByType = new HashMap();
        }
        return this.m_componentsByType;
    }

    private Map getComponentsByIdMap() {
        if (this.m_componentsById == null) {
            this.m_componentsById = new HashMap();
        }
        return this.m_componentsById;
    }

    public void registerSystemEditorForType(String aType, com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent aComp) {
        this.getComponentsByTypeMap().put(aType, aComp);
        this.getComponentsByIdMap().put(aComp.getId(), aComp);
    }

    public void registerSystemEditor(com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent aComponent) {
        this.getComponentsByIdMap().put(aComponent.getId(), aComponent);
    }

    public PropertyEditorComponent getPropertyEditorByType(String aDataType) {
        com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent _comp = (com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent)this.getComponentsByTypeMap().get(aDataType);
        if (_comp == null) {
            _comp = DEFAULT_COMPONENT;
        }
        return new PropertyEditorComponentImpl(_comp, null);
    }

    public PropertyEditorComponent getPropertyEditorById(String aId) {
        com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent _comp = (com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent)this.getComponentsByIdMap().get(aId);
        if (_comp == null) {
            return null;
        }
        return new PropertyEditorComponentImpl(_comp, null);
    }

    public TextSerializer getConverterByType(String aType) {
        PropertyEditorComponent _component = this.getPropertyEditorByType(aType);
        TextSerializer _converter = null;
        try {
            Class<?> _converterClass = this.m_defaultClassloader.loadClass(_component.getSerializerClass());
            _converter = (TextSerializer)_converterClass.newInstance();
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
        return _converter;
    }

    public TextSerializer getConverterById(String aEditorId) {
        PropertyEditorComponent _component = this.getPropertyEditorById(aEditorId);
        if (_component == null) {
            return null;
        }
        TextSerializer _converter = null;
        try {
            Class<?> _converterClass = this.m_defaultClassloader.loadClass(_component.getSerializerClass());
            _converter = (TextSerializer)_converterClass.newInstance();
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
        return _converter;
    }

    public UIComponent getUIComponentByType(String aDataType, String aUIType) {
        PropertyEditorComponent _component = this.getPropertyEditorByType(aDataType);
        if (_component == null) {
            return null;
        }
        UIComponent _ui = null;
        try {
            Class<?> _uiClass = this.m_defaultClassloader.loadClass(_component.getUIComponentClass(aUIType));
            _ui = (UIComponent)_uiClass.newInstance();
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
        return _ui;
    }

    public UIComponent getUIComponentById(String aEditorId, String aUIType) {
        PropertyEditorComponent _component = this.getPropertyEditorById(aEditorId);
        if (_component == null) {
            return null;
        }
        UIComponent _ui = null;
        try {
            Class<?> _uiClass = this.m_defaultClassloader.loadClass(_component.getUIComponentClass(aUIType));
            _ui = (UIComponent)_uiClass.newInstance();
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
        return _ui;
    }

    public boolean isPropertyEditorForTypeRegistered(String aDataType) {
        Object _comp = this.getComponentsByTypeMap().get(aDataType);
        return _comp != null;
    }

    public void setDefaultClassLoader(ClassLoader clToUse) {
        try {
            String classToVerify = this.getClass().getName();
            Class<?> clz1 = clToUse.loadClass(classToVerify);
            Class<?> clz2 = this.m_defaultClassloader.loadClass(classToVerify);
            if (clz1 != clz2) {
                throw new IllegalArgumentException();
            }
            this.m_defaultClassloader = clToUse;
        }
        catch (ClassNotFoundException cnfe) {
            IllegalArgumentException iae = new IllegalArgumentException();
            iae.initCause(cnfe);
        }
    }

    public ClassLoader getDefaultClassLoader() {
        return this.m_defaultClassloader;
    }

    static {
        DEFAULT_COMPONENT = new TextPropertyEditorComponent();
        SPINNER_COMPONENT = new SpinnerPropertyEditorComponent();
    }
}

