/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.system;

import com.adobe.idp.dsc.propertyeditor.PropertyEditorMode;
import com.adobe.idp.dsc.propertyeditor.eclipse.EclipseUIComponent;
import com.adobe.idp.dsc.propertyeditor.impl.AbstractUIComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public abstract class NumberEclipseComponent
extends AbstractUIComponent
implements EclipseUIComponent {
    private Text m_control;

    public void renderComponent(Composite aContainer, long aMinValue, long aMaxValue) {
        Composite _container = aContainer;
        int _style = 18432;
        this.m_control = new Text(_container, _style);
        if (this.getPropertyContext().getPropertyEditorMode() != PropertyEditorMode.EDIT) {
            this.m_control.setEnabled(false);
        }
        long _paramMax = this.getParameterValue("maxValue", aMinValue);
        long _paramMin = this.getParameterValue("minValue", aMaxValue);
        long _max = Math.max(_paramMin, _paramMax);
        long _min = Math.min(_paramMin, _paramMax);
        final long _minimum = Math.max(_min, aMinValue);
        final long _maximum = Math.min(_max, aMaxValue);
        this.m_control.setLayoutData((Object)new GridData(1808));
        this.m_control.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                try {
                    long _longResult;
                    String _current = NumberEclipseComponent.this.m_control.getText();
                    String _start = _current.substring(0, e.start);
                    String _end = _current.substring(e.end);
                    String _result = _start + e.text + _end;
                    e.doit = _result.length() == 0 ? true : (_result.equals("-") && _minimum < 0L ? true : (_longResult = Long.parseLong(_result)) >= _minimum && _longResult <= _maximum);
                }
                catch (NumberFormatException aNumberFormatException) {
                    e.doit = false;
                }
            }
        });
        this.m_control.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String _textValue = NumberEclipseComponent.this.m_control.getText().trim();
                if (_textValue.length() == 0 || _textValue.equals("-")) {
                    _textValue = "0";
                }
                NumberEclipseComponent.this.getPropertyContext().getCurrentProperty().setValue(_textValue);
            }
        });
        String _value = (String)this.getPropertyContext().getCurrentProperty().getValue();
        if (_value == null) {
            _value = "0";
        }
        this.m_control.setText(_value);
    }

    private long getParameterValue(String aParameterName, long aDefaultValue) {
        long _result = aDefaultValue;
        String _parameterValue = this.m_ctx.getParameter(aParameterName);
        try {
            _result = Long.parseLong(_parameterValue);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return _result;
    }
}

