/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.system;

import com.adobe.idp.dsc.propertyeditor.Property;
import com.adobe.idp.dsc.propertyeditor.PropertyEditorMode;
import com.adobe.idp.dsc.propertyeditor.UIComponent;
import com.adobe.idp.dsc.propertyeditor.eclipse.EclipseUIComponent;
import com.adobe.idp.dsc.propertyeditor.impl.AbstractUIComponent;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyImpl;
import com.adobe.idp.dsc.propertyeditor.impl.PropertySheetImpl;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ListEclipseComponent
extends AbstractUIComponent
implements EclipseUIComponent {
    private Composite container;
    private Button btn_add;
    private Button btn_edit;
    private Button btn_delete;
    private TableViewer mtblviewer_listContents;
    private Table mtbl_listContent;
    private ListContentProvider m_listEntryDataModel;
    private TableColumn m_expressionColumn;

    public void renderComponent(Composite parent) {
        this.container = new Composite(parent, 0x1000000);
        GridData gd = new GridData(1808);
        this.container.setLayoutData((Object)gd);
        this.container.setLayout((Layout)new FormLayout());
        this.btn_add = new Button(this.container, 0x800008);
        this.btn_add.setToolTipText("Add a list entry");
        this.btn_add.setImage(this.getImage("list_addentry.png"));
        this.btn_add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object _newListEntry;
                ListEntryDialog _listEntryDialog = new ListEntryDialog(Display.getCurrent().getActiveShell(), ListEclipseComponent.this.m_ctx.getParameter("ListSubTypeEditorID"), (PropertyImpl)ListEclipseComponent.this.getPropertyContext().getCurrentProperty());
                _listEntryDialog.open();
                if (!_listEntryDialog.userCanceled() && (_newListEntry = _listEntryDialog.getListEntry()) != null) {
                    ListEclipseComponent.this.m_listEntryDataModel.addListEntry(_newListEntry);
                    ListEclipseComponent.this.mtblviewer_listContents.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.btn_edit = new Button(this.container, 0x800008);
        this.btn_edit.setToolTipText("Edit selected list entry");
        this.btn_edit.setImage(this.getImage("list_editentry.png"));
        this.btn_edit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ListEclipseComponent.this.editCurrentSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.btn_delete = new Button(this.container, 0x800008);
        this.btn_delete.setToolTipText("Delete selected list entry");
        this.btn_delete.setImage(this.getImage("list_deleteentry.png"));
        this.btn_delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection _selection = (IStructuredSelection)ListEclipseComponent.this.mtblviewer_listContents.getSelection();
                Object _listEntry = _selection.getFirstElement();
                if (_listEntry != null) {
                    ListEclipseComponent.this.m_listEntryDataModel.removeListentry(_listEntry);
                    ListEclipseComponent.this.mtblviewer_listContents.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.mtblviewer_listContents = new TableViewer(this.container, 65540);
        this.mtbl_listContent = this.mtblviewer_listContents.getTable();
        this.mtbl_listContent.setLinesVisible(true);
        this.mtbl_listContent.setHeaderVisible(false);
        this.mtbl_listContent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ListEclipseComponent.this.m_expressionColumn != null && !ListEclipseComponent.this.m_expressionColumn.isDisposed()) {
                    ListEclipseComponent.this.m_expressionColumn.setWidth(((ListEclipseComponent)ListEclipseComponent.this).mtbl_listContent.getClientArea().width);
                }
            }
        });
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.mtbl_listContent.setLayoutData((Object)gridData);
        this.m_expressionColumn = new TableColumn(this.mtbl_listContent, 0x1000000, 0);
        this.m_expressionColumn.setWidth(50);
        if (this.getPropertyContext().getPropertyEditorMode() == PropertyEditorMode.EDIT) {
            this.mtblviewer_listContents.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection _selection = (IStructuredSelection)event.getSelection();
                    Object _listEntry = _selection.getFirstElement();
                    if (_listEntry != null) {
                        ListEclipseComponent.this.btn_delete.setEnabled(true);
                        ListEclipseComponent.this.btn_edit.setEnabled(true);
                    } else {
                        ListEclipseComponent.this.btn_delete.setEnabled(false);
                        ListEclipseComponent.this.btn_edit.setEnabled(false);
                    }
                }
            });
        }
        this.mtblviewer_listContents.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ListEclipseComponent.this.editCurrentSelection();
            }
        });
        this.m_listEntryDataModel = new ListContentProvider(this.getPropertyContext().getCurrentProperty());
        this.mtblviewer_listContents.setContentProvider((IContentProvider)this.m_listEntryDataModel);
        this.mtblviewer_listContents.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.mtblviewer_listContents.setInput((Object)this.getPropertyContext().getCurrentProperty());
        this.mtblviewer_listContents.refresh();
        FormData _deleteFormData = new FormData();
        _deleteFormData.right = new FormAttachment(100, -5);
        _deleteFormData.top = new FormAttachment(0, 10);
        this.btn_delete.setLayoutData((Object)_deleteFormData);
        FormData _editFormData = new FormData();
        _editFormData.right = new FormAttachment((Control)this.btn_delete, -5);
        _editFormData.top = new FormAttachment(0, 10);
        this.btn_edit.setLayoutData((Object)_editFormData);
        FormData _addFormData = new FormData();
        _addFormData.right = new FormAttachment((Control)this.btn_edit, -5);
        _addFormData.top = new FormAttachment(0, 10);
        this.btn_add.setLayoutData((Object)_addFormData);
        FormData _tableFormData = new FormData();
        _tableFormData.top = new FormAttachment((Control)this.btn_edit, 5);
        _tableFormData.left = new FormAttachment(0, 5);
        _tableFormData.right = new FormAttachment((Control)this.btn_delete, 0, 131072);
        _tableFormData.height = 200;
        this.mtbl_listContent.setLayoutData((Object)_tableFormData);
        if (this.getPropertyContext().getPropertyEditorMode() == PropertyEditorMode.EDIT) {
            this.btn_delete.setEnabled(false);
            this.btn_edit.setEnabled(false);
        } else {
            this.mtblviewer_listContents.getTable().setEnabled(false);
            this.btn_add.setEnabled(false);
            this.btn_delete.setEnabled(false);
            this.btn_edit.setEnabled(false);
        }
    }

    private void editCurrentSelection() {
        IStructuredSelection _selection = (IStructuredSelection)this.mtblviewer_listContents.getSelection();
        Object _listEntry = _selection.getFirstElement();
        if (_listEntry != null) {
            ListEntryDialog _listEntryDialog = new ListEntryDialog(Display.getCurrent().getActiveShell(), _listEntry, this.m_ctx.getParameter("ListSubTypeEditorID"), (PropertyImpl)this.getPropertyContext().getCurrentProperty());
            _listEntryDialog.open();
            if (!_listEntryDialog.userCanceled()) {
                Object _modifiedListEntry = _listEntryDialog.getListEntry();
                this.m_listEntryDataModel.replaceListEntry(_listEntry, _modifiedListEntry);
                this.mtblviewer_listContents.refresh();
            }
        }
    }

    public Image getImage(String aImageName) {
        ImageDescriptor imgDscptr = ListEclipseComponent.getImageDescriptor(aImageName);
        return imgDscptr.createImage();
    }

    public static ImageDescriptor getImageDescriptor(String aImageName) {
        return ImageDescriptor.createFromURL((URL)ListEclipseComponent.class.getResource(aImageName));
    }

    public class ListEntryDialog
    extends Dialog {
        private String m_editorID;
        private boolean m_userCancelled;
        private PropertyImpl m_property;
        private PropertyImpl m_parentProperty;

        public ListEntryDialog(Shell parentShell, Object inputValue, String editorID, PropertyImpl property) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
            this.m_editorID = editorID;
            this.m_parentProperty = property;
            this.init(inputValue);
        }

        public ListEntryDialog(Shell parentShell, String editorID, PropertyImpl property) {
            super(parentShell);
            this.m_editorID = editorID;
            this.m_parentProperty = property;
            this.init(null);
        }

        private void init(Object inputValue) {
            this.m_property = new PropertyImpl((PropertySheetImpl)ListEclipseComponent.this.m_ctx.getPropertySheet(), null);
            this.m_property.setName("list entry");
            this.m_property.setTitle("list entry");
            this.m_property.setComponentId(this.m_parentProperty.getComponentId());
            this.m_property.setComponentVersion(this.m_parentProperty.getComponentVersion());
            this.m_property.setType(ListEclipseComponent.this.m_ctx.getParameter("ListSubType"));
            this.m_property.setEditorId(this.m_editorID);
            if (inputValue != null) {
                this.m_property.setValue(inputValue);
            }
            ((PropertySheetImpl)ListEclipseComponent.this.m_ctx.getPropertySheet()).addProperty(this.m_property);
        }

        protected void cancelPressed() {
            this.m_userCancelled = true;
            super.cancelPressed();
        }

        protected void okPressed() {
            this.m_userCancelled = false;
            super.okPressed();
        }

        public boolean userCanceled() {
            return this.m_userCancelled;
        }

        protected void configureShell(Shell newShell) {
            newShell.setText("Edit Table Item");
            super.configureShell(newShell);
        }

        protected Control createDialogArea(Composite parent) {
            Composite _container = new Composite(parent, 2048);
            GridLayout _layout = new GridLayout();
            _layout.numColumns = 1;
            _container.setLayout((Layout)_layout);
            _container.setLayoutData((Object)new GridData(1808));
            Composite _comp = new Composite(_container, 0x1000000);
            _comp.setLayoutData((Object)new GridData(1808));
            GridLayout _editorLayout = new GridLayout(2, false);
            _comp.setLayout((Layout)_editorLayout);
            Label _label = new Label(_comp, 16384);
            _label.setText(this.m_property.getName() + ":");
            _label.setLayoutData((Object)new GridData(34));
            UIComponent _uiComp = this.m_property.getUIComponent("eclipse");
            if (_uiComp != null) {
                EclipseUIComponent _eclipseComp = (EclipseUIComponent)_uiComp;
                _eclipseComp.renderComponent(_comp);
            }
            return _container;
        }

        public Object getListEntry() {
            return this.m_property.getValue();
        }
    }

    public class ListContentProvider
    implements IStructuredContentProvider {
        private List m_list;
        Property m_property;

        public ListContentProvider(Property aProperty) {
            this.m_property = aProperty;
            this.m_list = (List)this.m_property.getValue();
            if (this.m_list == null) {
                this.m_list = new ArrayList();
                this.updatePropertyValue();
            }
        }

        public Object[] getElements(Object arg0) {
            return this.m_list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public void removeListentry(Object aListEntry) {
            this.m_list.remove(aListEntry);
            this.updatePropertyValue();
        }

        public void replaceListEntry(Object existingListEntry, Object newListEntry) {
            int index = this.m_list.indexOf(existingListEntry);
            if (index != -1) {
                this.m_list.set(index, newListEntry);
                this.updatePropertyValue();
            }
        }

        public void addListEntry(Object listEntry) {
            this.m_list.add(listEntry);
            this.updatePropertyValue();
        }

        private void updatePropertyValue() {
            this.m_property.setValue(this.m_list);
        }
    }

    public class ListLabelProvider
    implements ITableLabelProvider {
        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object arg0, int arg1) {
            return arg0.toString();
        }
    }
}

