/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.system;

import com.adobe.idp.Context;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.propertyeditor.PropertyEditorMode;
import com.adobe.idp.dsc.propertyeditor.eclipse.EclipseUIComponent;
import com.adobe.idp.dsc.propertyeditor.impl.AbstractUIComponent;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.datatype.client.DataTypeRegistryClient;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.service.client.ServiceRegistryClient;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class EnumEclipseComponent
extends AbstractUIComponent
implements EclipseUIComponent {
    private Combo m_control;
    private Class m_enumClz;
    private String[] m_displayableChoices = new String[0];
    private String[] m_logicalValues = new String[0];
    private Object[] m_enumObjs = new Object[0];
    private String enumClassString = null;
    private static ServiceRegistryClient src_ = null;
    private static Context ctx_ = null;

    public void renderComponent(Composite aContainer) {
        Composite _container = aContainer;
        this.m_control = new Combo(_container, 18440);
        if (this.getPropertyContext().getPropertyEditorMode() != PropertyEditorMode.EDIT) {
            this.m_control.setEnabled(false);
        }
        this.initialize();
        String[] displayChoices = this.getDisplayableEnumChoices();
        String _propertyValue = (String)this.getPropertyContext().getCurrentProperty().getValue();
        for (int i = 0; i < displayChoices.length; ++i) {
            String trimmed = displayChoices[i];
            this.m_control.add(trimmed);
            if (_propertyValue != null) continue;
            _propertyValue = this.getLogicalNameFromDisplayName(trimmed);
            this.getPropertyContext().getCurrentProperty().setValue(_propertyValue);
        }
        if (_propertyValue != null) {
            this.m_control.setText(this.getDisplayableEnumChoice(_propertyValue));
        }
        this.m_control.setLayoutData((Object)new GridData(1808));
        this.m_control.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent aEvent) {
                this.updateValue();
            }

            public void widgetDefaultSelected(SelectionEvent aEvent) {
                this.updateValue();
            }

            private void updateValue() {
                String curTextValue = EnumEclipseComponent.this.m_control.getText();
                String newVal = EnumEclipseComponent.this.getLogicalNameFromDisplayName(curTextValue);
                EnumEclipseComponent.this.getPropertyContext().getCurrentProperty().setValue(newVal);
            }
        });
    }

    private String[] getDisplayableEnumChoices() {
        return this.m_displayableChoices;
    }

    private String getDisplayableEnumChoice(String logicalEnumName) {
        for (int i = 0; i < this.m_logicalValues.length; ++i) {
            if (!this.m_logicalValues[i].equals(logicalEnumName)) continue;
            return this.m_displayableChoices[i];
        }
        throw new IllegalArgumentException(logicalEnumName);
    }

    private String getLogicalNameFromDisplayName(String displayName) {
        for (int i = 0; i < this.m_logicalValues.length; ++i) {
            if (!this.m_displayableChoices[i].equals(displayName)) continue;
            return this.m_logicalValues[i];
        }
        throw new IllegalArgumentException(displayName);
    }

    private void initialize() {
        if (this.m_enumClz != null) {
            return;
        }
        this.m_enumClz = Enum.class;
        Exception trouble = null;
        try {
            ServiceConfiguration sc;
            ClassLoader theCl;
            this.enumClassString = this.getPropertyContext().getCurrentProperty().getType();
            ServiceClientFactory scf = this.getPropertyContext().getServiceClientFactory();
            if (scf == null) {
                scf = ServiceClientFactory.createInstance();
            }
            if ((theCl = this.fetchClassLoader(scf, sc = this.getPropertyContext().getServiceConfiguration())) == null) {
                return;
            }
            try {
                this.m_enumClz = theCl.loadClass(this.enumClassString);
            }
            catch (ClassNotFoundException cnfe) {
                ClassLoader _theCl = this.fetchClassLoader(scf, null);
                this.m_enumClz = _theCl.loadClass(this.enumClassString);
            }
            if (this.m_enumClz.isEnum()) {
                this.m_enumObjs = this.m_enumClz.getEnumConstants();
                if (this.m_enumObjs != null) {
                    this.m_logicalValues = new String[this.m_enumObjs.length];
                    this.m_displayableChoices = new String[this.m_enumObjs.length];
                    for (int i = 0; i < this.m_enumObjs.length; ++i) {
                        Enum enumObj = (Enum)this.m_enumObjs[i];
                        this.m_logicalValues[i] = enumObj.name();
                        this.m_displayableChoices[i] = enumObj.toString();
                    }
                } else {
                    this.m_enumObjs = new Object[0];
                    this.m_displayableChoices = new String[0];
                    this.m_logicalValues = this.m_displayableChoices;
                }
            } else {
                ArrayList<String> displayNames = new ArrayList<String>();
                ArrayList<String> logicalNames = new ArrayList<String>();
                ArrayList<Object> enumObjects = new ArrayList<Object>();
                Field[] allFields = this.m_enumClz.getFields();
                int finalPublicStatiModifiers = 0;
                for (int i = 0; i < allFields.length; ++i) {
                    String thisConstantName;
                    Object obj;
                    Field thisField = allFields[i];
                    if ((thisField.getModifiers() & finalPublicStatiModifiers) != finalPublicStatiModifiers || thisField.getDeclaringClass() != this.m_enumClz || !this.m_enumClz.isAssignableFrom((obj = thisField.get(null)).getClass())) continue;
                    try {
                        Method dispNameMethod = this.m_enumClz.getMethod("getDisplayName", this.m_enumClz);
                        thisConstantName = (String)dispNameMethod.invoke(null, obj);
                        displayNames.add(thisConstantName);
                        logicalNames.add(obj.toString());
                        enumObjects.add(obj);
                        continue;
                    }
                    catch (NoSuchMethodException nsme) {
                        thisConstantName = obj.toString();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                this.m_displayableChoices = displayNames.toArray(new String[displayNames.size()]);
                this.m_logicalValues = logicalNames.toArray(new String[logicalNames.size()]);
                this.m_enumObjs = enumObjects.toArray(new Object[enumObjects.size()]);
            }
        }
        catch (IllegalArgumentException e) {
            trouble = e;
        }
        catch (IllegalAccessException e) {
            trouble = e;
        }
        catch (ClassNotFoundException e) {
            trouble = e;
        }
        catch (RegistryException e) {
            trouble = e;
        }
        if (trouble != null) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(trouble);
            throw ise;
        }
    }

    private ClassLoader fetchClassLoader(ServiceClientFactory scf, ServiceConfiguration sc) throws RegistryException {
        if (sc != null) {
            if (src_ == null || ctx_ != scf.getContext()) {
                ctx_ = scf.getContext();
                src_ = new ServiceRegistryClient(scf);
            }
            return src_.getClientClassLoader(this.getClass().getClassLoader(), sc);
        }
        DataTypeRegistryClient _dtc = new DataTypeRegistryClient(scf);
        return _dtc.getClientClassLoader(this.getClass().getClassLoader(), this.enumClassString);
    }
}

