/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.system;

import com.adobe.idp.dsc.propertyeditor.PropertyEditorMode;
import com.adobe.idp.dsc.propertyeditor.eclipse.EclipseUIComponent;
import com.adobe.idp.dsc.propertyeditor.impl.AbstractUIComponent;
import com.adobe.idp.dsc.propertyeditor.system.DocumentPropertyVO;
import com.adobe.idp.dsc.util.IOUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DocumentEclipseComponent
extends AbstractUIComponent
implements EclipseUIComponent {
    public static final String EDITOR_ID = "com.adobe.idp.dsc.propertyeditor.system.DocumentPropertyEditorComponent";
    private Text m_control;
    private Button m_browseButton;

    public void renderComponent(Composite aContainer) {
        Composite _propertyContainer = new Composite(aContainer, 0x1000000);
        _propertyContainer.setLayoutData((Object)new GridData(1808));
        GridLayout _editorLayout = new GridLayout(2, false);
        _propertyContainer.setLayout((Layout)_editorLayout);
        this.m_control = new Text(_propertyContainer, 18432);
        this.m_control.setEditable(false);
        this.m_control.setLayoutData((Object)new GridData(1808));
        DocumentPropertyVO _val = (DocumentPropertyVO)this.getPropertyContext().getCurrentProperty().getValue();
        this.setText(_val);
        this.m_browseButton = new Button(_propertyContainer, 0x1000000);
        this.m_browseButton.setLayoutData((Object)new GridData(258));
        if (this.getPropertyContext().getPropertyEditorMode() != PropertyEditorMode.EDIT) {
            this.m_browseButton.setEnabled(false);
        }
        this.m_browseButton.setText("...");
        this.m_browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                File _file;
                Shell _currentShell = null;
                Display _currentDisplay = Display.getCurrent();
                if (_currentDisplay != null) {
                    _currentShell = _currentDisplay.getActiveShell();
                }
                FileDialog dialog = new FileDialog(_currentShell, 4096);
                dialog.setFilterExtensions(new String[]{"*.*"});
                String _currentFileName = dialog.open();
                if (!TextUtil.isEmpty(_currentFileName) && (_file = new File(_currentFileName)).exists() && _file.isFile()) {
                    byte[] _buff = null;
                    try {
                        FileInputStream _fin = new FileInputStream(_file);
                        _buff = IOUtil.readByteArrayFromStream(_fin);
                        DocumentPropertyVO _document = new DocumentPropertyVO();
                        _document.setFileName(_file.getName());
                        _document.setFileSize(_buff.length);
                        _document.setLoadTime(new Date());
                        _document.setContent(_buff);
                        DocumentEclipseComponent.this.getPropertyContext().getCurrentProperty().setValue(_document);
                        DocumentEclipseComponent.this.setText(_document);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void setText(DocumentPropertyVO aDoc) {
        if (aDoc != null) {
            this.m_control.setText("File=" + aDoc.getFileName() + ", Size=" + aDoc.getFileSize() + ", Created: " + SimpleDateFormat.getDateInstance(3).format(aDoc.getLoadTime()));
        } else {
            this.m_control.setText("");
        }
    }
}

