/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.system;

import com.adobe.idp.dsc.datatype.Convertable;
import com.adobe.idp.dsc.datatype.TextSerializer;
import com.adobe.idp.dsc.datatype.impl.DefaultTextSerializer;
import com.adobe.idp.dsc.propertyeditor.Property;
import com.adobe.idp.dsc.propertyeditor.impl.PropertySheetImpl;
import com.adobe.idp.dsc.propertyeditor.system.ComplexEditorAttributeInfo;
import com.adobe.idp.dsc.propertyeditor.system.ComplexEditorParseException;
import com.adobe.idp.dsc.propertyeditor.system.ComplexEditorVOConverter;
import com.adobe.idp.dsc.propertyeditor.system.ComplexEditorVOProperty;
import com.adobe.idp.dsc.propertyeditor.system.SystemPropertyEditorRegistry;
import com.adobe.idp.dsc.registry.infomodel.CompositeEditorAttribute;
import com.adobe.idp.dsc.registry.infomodel.CompositeEditorObject;
import com.adobe.idp.dsc.registry.infomodel.CompositeEditorSimpleAttribute;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.ListOrderedMap;

public class ComplexEditorVO
implements Serializable,
Convertable {
    static final long serialVersionUID = -4640699480032699468L;
    private Map values = null;
    private transient Map attributes = null;
    private transient PropertySheetImpl propertySheet;
    private transient Property parentProperty;

    public ComplexEditorVO() {
        this.values = new HashMap();
        this.attributes = null;
        this.propertySheet = null;
        this.parentProperty = null;
    }

    public ComplexEditorVO(Property parentProperty, PropertySheetImpl parentPropertySheet, ComplexEditorVO initialValue) {
        this.attributes = new ListOrderedMap();
        this.values = initialValue != null ? initialValue.values : new HashMap();
        this.propertySheet = parentPropertySheet;
        this.parentProperty = parentProperty;
    }

    public Property getParentProperty() {
        return this.parentProperty;
    }

    public Map getValues() {
        return this.values;
    }

    public Object getValue(ClassLoader loader, String xPath) {
        try {
            Object _result = null;
            ComplexValue _complexValue = (ComplexValue)this.values.get(xPath);
            if (_complexValue != null) {
                TextSerializer _seri = DefaultTextSerializer.getDefaultInstance();
                Class<?> _type = loader.loadClass(_complexValue.typeName);
                _result = _seri.deserializeValue(_type, _complexValue.valueAsString, loader);
            }
            return _result;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String[] getXPaths() {
        Set _keySet = this.values.keySet();
        String[] _result = new String[_keySet.size()];
        _keySet.toArray(_result);
        return _result;
    }

    public void setValue(String xPath, Object value) {
        ComplexValue _complexValue = null;
        if (value != null) {
            if (value instanceof ComplexValue) {
                _complexValue = (ComplexValue)value;
            } else {
                TextSerializer _seri = DefaultTextSerializer.getDefaultInstance();
                String _stringValue = _seri.serializeValue(value);
                _complexValue = new ComplexValue();
                _complexValue.typeName = value.getClass().getName();
                _complexValue.valueAsString = _stringValue;
            }
        }
        this.values.put(xPath, _complexValue);
        this.parentProperty.setValue(this);
    }

    public static ComplexEditorVO constructFromClass(Property parentProperty, PropertySheetImpl parentPropertySheet, Class aClass, List attributeList, ComplexEditorVO initialValue) throws ComplexEditorParseException {
        try {
            ComplexEditorVO result = new ComplexEditorVO(parentProperty, parentPropertySheet, initialValue);
            SystemPropertyEditorRegistry _registry = SystemPropertyEditorRegistry.getInstance();
            if (attributeList != null && attributeList.size() > 0) {
                result.constructFromAttributes(parentProperty.getID(), aClass, _registry, attributeList);
            } else {
                result.constructFromClass(parentProperty.getID(), aClass, attributeList, _registry);
            }
            return result;
        }
        catch (Throwable t) {
            throw new ComplexEditorParseException("parsing error", t);
        }
    }

    private void constructFromClass(String parentPath, Class aClass, List attributeList, SystemPropertyEditorRegistry _registry) {
        PropertyDescriptor[] properties = PropertyUtils.getPropertyDescriptors((Class)aClass);
        this.parseClass(0, "/", properties, _registry, attributeList);
    }

    private void constructFromAttributes(String xPath, Class aClass, SystemPropertyEditorRegistry _registry, List attributeList) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (attributeList == null || attributeList.size() == 0) {
            return;
        }
        Iterator attributesIterator = attributeList.iterator();
        Map propertyDescriptors = this.loadPropertyDescriptors(aClass);
        while (attributesIterator.hasNext()) {
            CompositeEditorAttribute _attribute = (CompositeEditorAttribute)attributesIterator.next();
            if (_attribute instanceof CompositeEditorObject) {
                CompositeEditorObject _compositeObjectAttribute = (CompositeEditorObject)_attribute;
                String newXPath = xPath + "/" + _compositeObjectAttribute.getName();
                String _propertyName = _compositeObjectAttribute.getProperty();
                if (_propertyName == null || _propertyName.length() == 0) {
                    _propertyName = _compositeObjectAttribute.getName();
                }
                PropertyDescriptor subDesc = (PropertyDescriptor)propertyDescriptors.get(_propertyName);
                this.constructFromAttributes(newXPath, subDesc.getPropertyType(), _registry, _compositeObjectAttribute.getAttributes());
                continue;
            }
            CompositeEditorSimpleAttribute _simpleAttribute = (CompositeEditorSimpleAttribute)_attribute;
            String _propertyName = _simpleAttribute.getProperty();
            if (_propertyName == null || _propertyName.length() == 0) {
                _propertyName = _simpleAttribute.getName();
            }
            PropertyDescriptor _classPropertyDescriptor = (PropertyDescriptor)propertyDescriptors.get(_propertyName);
            String _propertyXPath = xPath + "/" + _classPropertyDescriptor.getName();
            ComplexEditorVOProperty _newProperty = new ComplexEditorVOProperty(this.propertySheet, this);
            String name = _simpleAttribute.getTitle();
            _newProperty.setName(name);
            _newProperty.setTitle(_simpleAttribute.getTitle());
            _newProperty.setXPath(_propertyXPath);
            _newProperty.setEditorId(_simpleAttribute.getPropertyEditor().getEditorId());
            _newProperty.setParameters(_simpleAttribute.getPropertyEditor().getParameters());
            _newProperty.setPropertySheet(this.propertySheet);
            _newProperty.setType(_classPropertyDescriptor.getPropertyType().getName());
            _newProperty.setValue(this.values.get(_propertyXPath));
            _newProperty.setHint(_simpleAttribute.getHint());
            this.addProperty(_propertyXPath, new ComplexEditorAttributeInfo(_newProperty));
        }
    }

    private void addProperty(String xPath, ComplexEditorAttributeInfo value) {
        this.attributes.put(xPath, value);
        this.propertySheet.addProperty(value.getProperty());
    }

    private Map loadPropertyDescriptors(Class aClass) {
        HashMap<String, PropertyDescriptor> result = new HashMap<String, PropertyDescriptor>();
        PropertyDescriptor[] _pd = PropertyUtils.getPropertyDescriptors((Class)aClass);
        for (int index = 0; index < _pd.length; ++index) {
            result.put(_pd[index].getName(), _pd[index]);
        }
        return result;
    }

    private void parseClass(int level, String parentExpression, PropertyDescriptor[] properties, SystemPropertyEditorRegistry aSystemPropertyEditorRegistry, List attributeList) {
        for (int index = 0; index < properties.length; ++index) {
            Class<?> _class = properties[index].getPropertyType();
            if (_class == Class.class) continue;
            String xPath = parentExpression + properties[index].getName();
            if (aSystemPropertyEditorRegistry.isPropertyEditorForTypeRegistered(_class.getName())) {
                PropertyDescriptor _classPropertyDescriptor = properties[index];
                String _propertyXPath = xPath + "/" + _classPropertyDescriptor.getName();
                ComplexEditorVOProperty _newProperty = new ComplexEditorVOProperty(this.propertySheet, this);
                String name = properties[index].getDisplayName();
                if (name == null || name.length() == 0) {
                    name = properties[index].getName();
                }
                _newProperty.setName(name);
                _newProperty.setXPath(_propertyXPath);
                _newProperty.setPropertySheet(this.propertySheet);
                _newProperty.setType(_classPropertyDescriptor.getPropertyType().getName());
                _newProperty.setValue(this.values.get(_propertyXPath));
                this.addProperty(xPath, new ComplexEditorAttributeInfo(_newProperty));
                continue;
            }
            PropertyDescriptor[] containedValue = PropertyUtils.getPropertyDescriptors(_class);
            this.parseClass(level + 1, xPath + "/", containedValue, aSystemPropertyEditorRegistry, attributeList);
        }
    }

    public void initializeValues(ComplexEditorVO currentValue) {
    }

    public Object convert(Class aType) {
        ComplexEditorVOConverter _voConverter = new ComplexEditorVOConverter();
        return _voConverter.convert(aType, this, aType.getClassLoader());
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public class ComplexValue
    implements Serializable {
        public String typeName;
        public String valueAsString;
    }
}

