/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.jsp.forms.rules;

import com.adobe.idp.dsc.propertyeditor.jsp.forms.Field;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Form;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.ValidationError;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.AbstractValidationRule;
import java.util.Collection;

public class ShortRule
extends AbstractValidationRule {
    public static final String SHORT_TYPE = "Short";

    public ShortRule(String fieldName, String errorMessage) {
        super(fieldName, SHORT_TYPE, errorMessage);
    }

    public void validate(Form form, Collection validationErrors) {
        String valueString;
        Field field = form.getField(this.getFieldName());
        Object value = field.getProperty("value", null);
        if (null != value && !(value instanceof Short) && !"".equals(valueString = value.toString())) {
            try {
                Short.parseShort(valueString);
            }
            catch (NumberFormatException e) {
                ValidationError validationError = new ValidationError(this.getFieldName(), this.getErrorMessage());
                validationErrors.add(validationError);
            }
        }
    }

    public String getValidationPostFix() {
        return "ShortValidations";
    }
}

