/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.jsp.forms.rules;

import com.adobe.idp.dsc.propertyeditor.jsp.forms.Field;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Form;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.ValidationError;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.AbstractValidationRule;
import java.text.MessageFormat;
import java.util.Collection;

public class IntRangeRule
extends AbstractValidationRule {
    public static final String INT_RANGE_TYPE = "IntRange";
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;

    public IntRangeRule(String fieldName, int min, int max, String errorMessage) {
        super(fieldName, "Integer", errorMessage);
        this.min = min;
        this.max = max;
    }

    public String getValidationPostFix() {
        return null;
    }

    public void validate(Form form, Collection validationErrors) {
        String valueString;
        Field field = form.getField(this.getFieldName());
        Object value = field.getProperty("value", null);
        if (null != value && !(value instanceof Integer) && !"".equals(valueString = value.toString())) {
            try {
                int intValue = Integer.parseInt(valueString);
                if (intValue < this.min || intValue > this.max) {
                    ValidationError validationError = new ValidationError(this.getFieldName(), MessageFormat.format(this.getErrorMessage(), this.min, this.max));
                    validationErrors.add(validationError);
                }
            }
            catch (NumberFormatException e) {
                ValidationError validationError = new ValidationError(this.getFieldName(), this.getErrorMessage());
                validationErrors.add(validationError);
            }
        }
    }
}

