/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.jsp.forms.rules;

import com.adobe.idp.dsc.propertyeditor.jsp.forms.Field;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Form;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.ValidationError;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.AbstractValidationRule;
import java.util.Collection;

public class ByteRule
extends AbstractValidationRule {
    public static final String BYTE_TYPE = "Byte";

    public ByteRule(String fieldName, String errorMessage) {
        super(fieldName, BYTE_TYPE, errorMessage);
    }

    public void validate(Form form, Collection validationErrors) {
        String valueString;
        Field field = form.getField(this.getFieldName());
        Object value = field.getProperty("value", null);
        if (null != value && !(value instanceof Byte) && !"".equals(valueString = value.toString())) {
            try {
                Byte.parseByte(valueString);
            }
            catch (NumberFormatException e) {
                ValidationError validationError = new ValidationError(this.getFieldName(), this.getErrorMessage());
                validationErrors.add(validationError);
            }
        }
    }

    public String getValidationPostFix() {
        return "ByteValidations";
    }
}

