/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.jsp.forms;

import com.adobe.idp.dsc.propertyeditor.jsp.forms.Form;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.ValidationRule;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.ByteRule;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.IntRangeRule;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.IntegerRule;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.MaskRule;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.RequiredRule;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.rules.ShortRule;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class FormValidator
implements Serializable {
    private static final long serialVersionUID = 7526471155622776147L;
    private Map ruleTypes = new LinkedHashMap();

    private void addRule(ValidationRule validationRule) {
        Vector<ValidationRule> validationRules = (Vector<ValidationRule>)this.ruleTypes.get(validationRule.getType());
        if (null == validationRules) {
            validationRules = new Vector<ValidationRule>();
            this.ruleTypes.put(validationRule.getType(), validationRules);
        }
        validationRules.add(validationRule);
    }

    public RequiredRule addRequiredRule(String fieldName, String errorMessage) {
        RequiredRule requiredRule = new RequiredRule(fieldName, errorMessage);
        this.addRule(requiredRule);
        return requiredRule;
    }

    public RequiredRule addRequiredRule(String fieldName, String filterField, String filterValue, String errorMessage) {
        RequiredRule requiredRule = new RequiredRule(fieldName, filterField, filterValue, errorMessage);
        this.addRule(requiredRule);
        return requiredRule;
    }

    public IntegerRule addIntegerRule(String fieldName, String errorMessage) {
        IntegerRule integerRule = new IntegerRule(fieldName, errorMessage);
        this.addRule(integerRule);
        return integerRule;
    }

    public ShortRule addShortRule(String fieldName, String errorMessage) {
        ShortRule shortRule = new ShortRule(fieldName, errorMessage);
        this.addRule(shortRule);
        return shortRule;
    }

    public ByteRule addByteRule(String fieldName, String errorMessage) {
        ByteRule byteRule = new ByteRule(fieldName, errorMessage);
        this.addRule(byteRule);
        return byteRule;
    }

    public IntRangeRule addIntRangeRule(String fieldName, int min, int max, String errorMessage) {
        IntRangeRule rangeRule = new IntRangeRule(fieldName, min, max, errorMessage);
        this.addRule(rangeRule);
        return rangeRule;
    }

    public MaskRule addMaskRule(String fieldName, String errorMessage, String mask) {
        return null;
    }

    public Map getRulesMap() {
        return this.ruleTypes;
    }

    public Collection validateForm(Form form) {
        Vector errors = new Vector();
        for (Collection rules : this.ruleTypes.values()) {
            for (ValidationRule rule : rules) {
                rule.validate(form, errors);
            }
        }
        return errors;
    }
}

