/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.jsp.forms;

import com.adobe.idp.dsc.propertyeditor.jsp.forms.DefaultFieldRenderer;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Field;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldContainer;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldRenderer;
import java.util.HashMap;
import java.util.Map;

public class FieldSet
extends FieldContainer
implements Field {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final FieldRenderer DEFAULT_FIELD_RENDERER = new DefaultFieldRenderer(2);
    private String name;
    protected FieldRenderer fieldRenderer = null;
    private Map properties;

    public FieldSet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setWeight(short weight) {
        this.setShortProperty("weight", weight);
    }

    public short getWeight() {
        return this.getShortProperty("weight", (short)0);
    }

    private void initProperties() {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
    }

    private boolean hasProperty(String name) {
        boolean hasProperty = false;
        if (null != this.properties) {
            hasProperty = this.properties.containsKey(name);
        }
        return hasProperty;
    }

    public void setIntProperty(String name, int value) {
        this.initProperties();
        this.properties.put(new Integer(value), name);
    }

    public int getIntProperty(String name, int defaultValue) {
        int result = defaultValue;
        if (this.hasProperty(name)) {
            result = (Integer)this.properties.get(name);
        }
        return result;
    }

    public void setStringProperty(String name, String value) {
        this.initProperties();
        this.properties.put(name, value);
    }

    public String getStringProperty(String name, String defaultValue) {
        return (String)this.getProperty(name, defaultValue);
    }

    public void setShortProperty(String name, short value) {
        this.setProperty(name, new Short(value));
    }

    public short getShortProperty(String name, short defaultValue) {
        short result = defaultValue;
        if (this.hasProperty(name)) {
            result = (Short)this.properties.get(name);
        }
        return result;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.setProperty(name, new Boolean(value));
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        boolean result = defaultValue;
        if (this.hasProperty(name)) {
            result = (Boolean)this.properties.get(name);
        }
        return result;
    }

    public void setProperty(String name, Object value) {
        this.initProperties();
        this.properties.put(name, value);
    }

    public Object getProperty(String name, Object defaultValue) {
        Object result = defaultValue;
        if (this.hasProperty(name)) {
            result = this.properties.get(name);
        }
        return result;
    }

    public void setFieldRenderer(FieldRenderer fieldRenderer) {
        this.fieldRenderer = fieldRenderer;
    }

    public boolean getRequired() {
        return this.getBooleanProperty("required", false);
    }

    public FieldRenderer getFieldRenderer() {
        FieldRenderer result = this.fieldRenderer;
        if (null == result) {
            result = DEFAULT_FIELD_RENDERER;
        }
        return result;
    }
}

