/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.jsp.forms;

import com.adobe.idp.dsc.propertyeditor.jsp.forms.AbstractField;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.CheckBox;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.CheckBoxes;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Field;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldComparator;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldRenderer;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldSet;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Password;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.RadioButtons;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.TextArea;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.TextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class FieldContainer
extends AbstractField {
    private static final long serialVersionUID = 7526471155622776147L;
    private Map fields = new LinkedHashMap();
    protected List sortedFields = null;

    protected FieldContainer() {
    }

    public FieldContainer(FieldRenderer defaultFieldRenderer, String name) {
        super(defaultFieldRenderer, name);
    }

    public Field getField(String name) {
        Field field = (Field)this.fields.get(name);
        if (null == field) {
            Iterator fieldsIt = this.fields.values().iterator();
            while (null == field && fieldsIt.hasNext()) {
                Field curField = (Field)fieldsIt.next();
                if (!(curField instanceof FieldContainer)) continue;
                FieldContainer container = (FieldContainer)curField;
                field = container.getField(name);
            }
        }
        return field;
    }

    public void addField(Field field) {
        this.fields.put(field.getName(), field);
        field.setParent(this);
        this.sortedFields = null;
    }

    public Collection getFields() {
        return this.fields.values();
    }

    public List getSortedFields() {
        if (null == this.sortedFields) {
            this.sortedFields = new ArrayList();
            this.sortedFields.addAll(this.fields.values());
            Collections.sort(this.sortedFields, this.getFieldComparator());
        }
        return this.sortedFields;
    }

    protected Comparator getFieldComparator() {
        return new FieldComparator();
    }

    public CheckBox addCheckBox(String name) {
        CheckBox checkbox = new CheckBox(name);
        this.addField(checkbox);
        return checkbox;
    }

    public CheckBoxes addCheckBoxes(String name) {
        CheckBoxes checkBoxes = new CheckBoxes(name);
        this.addField(checkBoxes);
        return checkBoxes;
    }

    public FieldSet addFieldSet(String name) {
        FieldSet fieldSet = new FieldSet(name);
        this.addField(fieldSet);
        return fieldSet;
    }

    public Password addPassword(String name) {
        Password password = new Password(name);
        this.addField(password);
        return password;
    }

    public RadioButtons addRadioButtons(String name) {
        RadioButtons radioButtons = new RadioButtons(name);
        this.addField(radioButtons);
        return radioButtons;
    }

    public TextArea addTextArea(String name) {
        TextArea textArea = new TextArea(name);
        this.addField(textArea);
        return textArea;
    }

    public TextField addTextField(String name) {
        TextField textField = new TextField(name);
        this.addField(textField);
        return textField;
    }
}

