/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.jsp.forms;

import com.adobe.idp.dsc.propertyeditor.jsp.forms.CheckBox;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.ComboBox;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Field;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldRenderer;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldSet;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Form;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.RadioButton;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.RadioButtons;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.ValueFilter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultFieldRenderer
implements FieldRenderer {
    private static final long serialVersionUID = 7526471155622776147L;
    public static final int TYPE_CHECKBOX = 1;
    public static final int TYPE_FIELD_SET = 2;
    public static final int TYPE_PASSWORD = 3;
    public static final int TYPE_RADIO_BUTTON = 4;
    public static final int TYPE_RADIO_BUTTONS = 5;
    public static final int TYPE_TEXT_AREA = 6;
    public static final int TYPE_TEXT_FIELD = 7;
    public static final int TYPE_CHECKBOXES = 8;
    public static final int TYPE_COMBO_BOX = 9;
    public static final int TYPE_FILE = 10;
    public static final int TYPE_HIDDEN = 11;
    private int fieldType;
    private boolean addFocusAndBlurJavascript = false;
    protected boolean showLabel = true;
    private ValueFilter valueFilter = null;

    public DefaultFieldRenderer() {
        this(7, false);
    }

    public DefaultFieldRenderer(int fieldType) {
        this(fieldType, false);
    }

    public DefaultFieldRenderer(int fieldType, boolean addFocusAndBlurJavascript) {
        this.fieldType = fieldType;
        this.addFocusAndBlurJavascript = addFocusAndBlurJavascript;
    }

    public int getType() {
        return this.fieldType;
    }

    public String filter(String value) {
        String result;
        if (null != this.valueFilter && null != value) {
            result = this.valueFilter.filter(value);
            if (-1 != result.indexOf("&amp;#39;")) {
                result = result.replaceAll("&amp;#39;", "&#39;");
            }
        } else {
            result = value;
        }
        return result;
    }

    public void setAddFocusAndBlur(boolean addFocusAndBlurJavascript) {
        this.addFocusAndBlurJavascript = addFocusAndBlurJavascript;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
    }

    public void setValueFilter(ValueFilter valueFilter) {
        this.valueFilter = valueFilter;
    }

    public String render(Field field, Form form) {
        StringBuffer output = new StringBuffer(128);
        this.render(field, form, output);
        return output.toString();
    }

    public void render(Field field, Form form, StringBuffer output) {
        switch (this.fieldType) {
            case 9: {
                this.renderComboBox(output, field);
                break;
            }
            case 1: {
                this.renderCheckBox(output, field);
                break;
            }
            case 2: {
                this.renderFieldSet(output, field, form);
                break;
            }
            case 3: {
                this.renderPassword(output, field);
                break;
            }
            case 4: {
                this.renderRadioButton(output, field);
                break;
            }
            case 5: {
                this.renderRadioButtons(output, field);
                break;
            }
            case 6: {
                this.renderTextArea(output, field);
                break;
            }
            case 7: {
                this.renderTextField(output, field);
                break;
            }
            case 8: {
                this.renderCheckBoxes(output, field);
                break;
            }
            case 10: {
                this.renderFile(output, field);
                break;
            }
            case 11: {
                this.renderHidden(output, field);
                break;
            }
            default: {
                this.renderTextField(output, field);
            }
        }
    }

    protected void renderCheckBox(StringBuffer output, Field field) {
        boolean enabled;
        String name = this.filter(field.getName());
        output.append("<input type='checkbox' value='true' id='");
        output.append(name);
        output.append("' name='");
        output.append(name);
        output.append("' ");
        String fieldClass = field.getStringProperty("class", "checkRadio");
        if (null != fieldClass) {
            output.append(" class='");
            output.append(this.filter(fieldClass));
            output.append("'");
        }
        if (!(enabled = field.isEnabled())) {
            output.append(" disabled='true'");
        }
        this.addFocusAndBlurJavaScript(output, field);
        CheckBox checkBox = (CheckBox)field;
        boolean checked = checkBox.isChecked();
        if (checked) {
            output.append(" checked='true'");
        }
        output.append("/>\n<input type='hidden' name='");
        output.append(name);
        output.append("' value='false'/>");
    }

    protected void addFocusAndBlurJavaScript(StringBuffer output, Field field) {
        if (this.addFocusAndBlurJavascript) {
            Field parentField = field.getParent();
            String groupFieldName = null;
            if (null != parentField) {
                if (parentField instanceof Form) {
                    parentField = field;
                }
                groupFieldName = this.filter(parentField.getName());
            } else {
                groupFieldName = this.filter(field.getStringProperty("groupMembership", null));
            }
            if (null != groupFieldName) {
                output.append(" onfocus=\"$('__row_");
                output.append(groupFieldName);
                output.append("').style.backgroundColor='#EDF2F5'\" onblur=\"$('__row_");
                output.append(groupFieldName);
                output.append("').style.backgroundColor='#FFFFFF'\"");
            }
        }
    }

    protected void renderCheckBoxes(StringBuffer output, Field field) {
    }

    protected void renderFieldSet(StringBuffer output, Field field, Form form) {
        FieldSet fieldSet = (FieldSet)field;
        List fields = fieldSet.getSortedFields();
        for (Field childField : fields) {
            FieldRenderer fieldRenderer = childField.getFieldRenderer();
            output.append(fieldRenderer.render(childField, form));
        }
    }

    protected void renderPassword(StringBuffer output, Field field) {
        int maxlength;
        String value;
        boolean enabled;
        String name = this.filter(field.getName());
        output.append("<input type='password' name='");
        output.append(name);
        output.append("' id='");
        output.append(name);
        output.append("'");
        String cssClass = field.getStringProperty("class", "formTextFieldLarge");
        if (null != cssClass) {
            output.append(" class='");
            output.append(this.filter(cssClass));
            output.append("'");
        }
        if (!(enabled = field.isEnabled())) {
            output.append(" disabled='true'");
        }
        this.addFocusAndBlurJavaScript(output, field);
        int size = field.getIntProperty("size", -1);
        if (-1 != size) {
            output.append(" size='");
            output.append(size);
            output.append("'");
        }
        if (null != (value = field.getStringProperty("value", null)) && !"".equals(value)) {
            output.append(" value='");
            output.append("________");
            output.append("'");
        }
        if (-1 != (maxlength = field.getIntProperty("maxlength", -1))) {
            output.append(" maxlength='");
            output.append(maxlength);
            output.append("'");
        }
        output.append("/>");
    }

    protected void renderRadioButton(StringBuffer output, Field field) {
        boolean enabled;
        String name = this.filter(field.getName());
        output.append("<input type='radio' name='");
        output.append(name);
        output.append("' id='");
        output.append(name);
        output.append("' value='");
        output.append(this.filter(field.getStringProperty("value", "")));
        output.append("'");
        if (field.getBooleanProperty("selected", false)) {
            output.append(" checked='true'");
        }
        if (!(enabled = field.isEnabled())) {
            output.append(" disabled='true'");
        }
        this.addFocusAndBlurJavaScript(output, field);
        output.append("/>");
    }

    protected void renderRadioButtons(StringBuffer output, Field field) {
        RadioButtons radioButtonsGroup = (RadioButtons)field;
        Collection radioButtons = radioButtonsGroup.getRadioButtons();
        Iterator radioButtonsIt = radioButtons.iterator();
        String value = radioButtonsGroup.getStringProperty("value", "");
        while (radioButtonsIt.hasNext()) {
            RadioButton radioButton = (RadioButton)radioButtonsIt.next();
            if (null != value) {
                radioButton.setSelected(value.equals(radioButton.getStringProperty("value", null)));
            }
            this.renderRadioButton(output, radioButton);
            output.append("<br/>");
        }
    }

    protected void renderComboBox(StringBuffer output, Field field) {
        String onChange;
        boolean enabled;
        String name = this.filter(field.getName());
        ComboBox comboBox = (ComboBox)field;
        output.append("<select name='");
        output.append(name);
        output.append("' id='");
        output.append(name);
        String cssClass = field.getStringProperty("class", "formListMenuLarge");
        if (null != cssClass) {
            output.append("' class='");
            output.append(this.filter(cssClass));
            output.append("'");
        }
        if (!(enabled = field.isEnabled())) {
            output.append(" disabled='true'");
        }
        if (null != (onChange = field.getStringProperty("onChange", null))) {
            output.append(" onChange=\"");
            output.append(this.filter(onChange));
            output.append("\"");
        }
        this.addFocusAndBlurJavaScript(output, field);
        output.append(">");
        Collection<ComboBox.Option> options = comboBox.getOptions();
        for (ComboBox.Option option : options) {
            if (!option.isVisible()) continue;
            String value = option.getValue();
            String filteredValue = this.filter(value);
            String label = this.filter(option.getLabel());
            output.append("<option value='");
            output.append(filteredValue);
            if (option.isSelected()) {
                output.append("' selected='true'>");
            } else {
                output.append("'>");
            }
            output.append(label);
            output.append("</option>\n");
        }
        output.append("</select>");
    }

    protected void renderTextArea(StringBuffer output, Field textArea) {
        int cols;
        boolean enabled;
        String name = this.filter(textArea.getName());
        output.append("<textarea name='");
        output.append(name);
        output.append("' id='");
        output.append(name);
        output.append("'");
        String cssClass = textArea.getStringProperty("class", "formTextFieldLarge");
        if (null != cssClass) {
            output.append(" class='");
            output.append(this.filter(cssClass));
            output.append("'");
        }
        if (!(enabled = textArea.isEnabled())) {
            output.append(" disabled='true'");
        }
        this.addFocusAndBlurJavaScript(output, textArea);
        int rows = textArea.getIntProperty("rows", -1);
        if (-1 != rows) {
            output.append(" rows='");
            output.append(rows);
            output.append("'");
        }
        if (-1 != (cols = textArea.getIntProperty("cols", -1))) {
            output.append(" cols='");
            output.append(cols);
            output.append("'");
        }
        output.append(">");
        String value = textArea.getStringProperty("value", "");
        if (null != value) {
            output.append(this.filter(value));
        }
        output.append("</textarea>");
    }

    protected void renderHidden(StringBuffer output, Field hiddenField) {
        String cssClass;
        String name = this.filter(hiddenField.getName());
        output.append("<input type='hidden' name='");
        output.append(name);
        output.append("' id='");
        output.append(name);
        output.append("'");
        String value = hiddenField.getStringProperty("value", "");
        if (null != value) {
            output.append(" value='");
            output.append(this.filter(value));
            output.append("'");
        }
        if (null != (cssClass = hiddenField.getStringProperty("class", "formTextFieldLarge"))) {
            output.append(" class='");
            output.append(this.filter(cssClass));
            output.append("'");
        }
        output.append("/>");
    }

    protected void renderTextField(StringBuffer output, Field textField) {
        int maxlength;
        String cssClass;
        boolean enabled;
        String name = this.filter(textField.getName());
        output.append("<input type='text' name='");
        output.append(name);
        output.append("' id='");
        output.append(name);
        output.append("'");
        String value = textField.getStringProperty("value", "");
        if (null != value) {
            output.append(" value='");
            output.append(this.filter(value));
            output.append("'");
        }
        if (!(enabled = textField.isEnabled())) {
            output.append(" disabled='true'");
        }
        if (null != (cssClass = textField.getStringProperty("class", "formTextFieldLarge"))) {
            output.append(" class='");
            output.append(this.filter(cssClass));
            output.append("'");
        }
        this.addFocusAndBlurJavaScript(output, textField);
        int size = textField.getIntProperty("size", -1);
        if (-1 != size) {
            output.append(" size='");
            output.append(size);
            output.append("'");
        }
        if (-1 != (maxlength = textField.getIntProperty("maxlength", -1))) {
            output.append(" maxlength='");
            output.append(maxlength);
            output.append("'");
        }
        output.append("/>");
    }

    protected void renderFile(StringBuffer output, Field field) {
        int maxlength;
        boolean enabled;
        String name = this.filter(field.getName());
        output.append("<input type='file' name='");
        output.append(name);
        output.append("' id='");
        output.append(name);
        String cssClass = field.getStringProperty("class", "formTextFieldLarge");
        if (null != cssClass) {
            output.append("' class='");
            output.append(this.filter(cssClass));
            output.append("'");
        }
        if (!(enabled = field.isEnabled())) {
            output.append(" disabled='true'");
        }
        this.addFocusAndBlurJavaScript(output, field);
        int size = field.getIntProperty("size", -1);
        if (-1 != size) {
            output.append(" size='");
            output.append(size);
            output.append("'");
        }
        if (-1 != (maxlength = field.getIntProperty("maxlength", -1))) {
            output.append("' maxlength='");
            output.append(maxlength);
            output.append("'");
        }
        output.append("/>");
    }
}

