/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.jsp.forms;

import com.adobe.idp.dsc.propertyeditor.jsp.forms.DefaultFieldRenderer;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.Field;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldContainer;
import com.adobe.idp.dsc.propertyeditor.jsp.forms.FieldRenderer;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractField
implements Field {
    private static final long serialVersionUID = 7526471155622776147L;
    private Map properties = new HashMap();
    private static final FieldRenderer DEFAULT_FIELD_RENDERER = new DefaultFieldRenderer(7);
    protected FieldRenderer fieldRenderer = null;
    private FieldContainer parent = null;

    public AbstractField() {
        this("");
    }

    public AbstractField(String name) {
        this(DEFAULT_FIELD_RENDERER, name);
    }

    public AbstractField(FieldRenderer defaultFieldRenderer, String name) {
        this.setStringProperty("name", name);
        this.fieldRenderer = defaultFieldRenderer;
    }

    public String getName() {
        return this.getStringProperty("name", "");
    }

    public void setWeight(short weight) {
        this.setShortProperty("weight", weight);
    }

    public short getWeight() {
        return this.getShortProperty("weight", (short)0);
    }

    public boolean getRequired() {
        return this.getBooleanProperty("required", false);
    }

    public void setRequired(boolean required) {
        this.setBooleanProperty("required", required);
    }

    private void initProperties() {
        if (null == this.properties) {
            this.properties = new HashMap();
        }
    }

    private boolean hasProperty(String name) {
        boolean hasProperty = false;
        if (null != this.properties) {
            hasProperty = this.properties.containsKey(name);
        }
        return hasProperty;
    }

    public void setIntProperty(String name, int value) {
        this.initProperties();
        this.properties.put(name, new Integer(value));
    }

    public int getIntProperty(String name, int defaultValue) {
        int result = defaultValue;
        if (this.hasProperty(name)) {
            Object property = this.getProperty(name, new Integer(defaultValue));
            if (property instanceof Integer) {
                result = (Integer)property;
            } else if (null != property) {
                try {
                    result = Integer.parseInt(property.toString());
                }
                catch (NumberFormatException nfe) {
                    result = defaultValue;
                }
            } else {
                result = defaultValue;
            }
        }
        return result;
    }

    public void setStringProperty(String name, String value) {
        this.initProperties();
        this.properties.put(name, value);
    }

    public String getStringProperty(String name, String defaultValue) {
        String result = null;
        Object value = this.getProperty(name, defaultValue);
        if (value instanceof String) {
            result = (String)value;
        } else if (null != value) {
            result = value.toString();
        }
        return result;
    }

    public void setShortProperty(String name, short value) {
        this.setProperty(name, new Short(value));
    }

    public short getShortProperty(String name, short defaultValue) {
        short result = defaultValue;
        if (this.hasProperty(name)) {
            result = (Short)this.getProperty(name, new Short(defaultValue));
        }
        return result;
    }

    public void setBooleanProperty(String name, boolean value) {
        this.setProperty(name, new Boolean(value));
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        boolean result = defaultValue;
        if (this.hasProperty(name)) {
            result = (Boolean)this.getProperty(name, defaultValue);
        }
        return result;
    }

    public void setProperty(String name, Object value) {
        this.initProperties();
        this.properties.put(name, value);
    }

    public Object getProperty(String name, Object defaultValue) {
        Object result = defaultValue;
        if (this.hasProperty(name)) {
            result = this.properties.get(name);
        } else {
            this.properties.put(name, defaultValue);
        }
        return result;
    }

    public FieldRenderer getFieldRenderer() {
        return this.fieldRenderer;
    }

    public void setFieldRenderer(FieldRenderer fieldRenderer) {
        this.fieldRenderer = fieldRenderer;
    }

    public FieldContainer getParent() {
        return this.parent;
    }

    public void setParent(FieldContainer parent) {
        if (this.parent != parent) {
            if (null == this.parent) {
                this.parent = parent;
                if (null == this.parent.getField(this.getName())) {
                    this.parent.addField(this);
                }
            } else {
                throw new RuntimeException("A Field may only be added to a single parent");
            }
        }
    }

    public void setInFieldSet(boolean inFieldSet) {
        this.setBooleanProperty("inFieldSet", inFieldSet);
    }

    public boolean isInFieldSet() {
        return this.getBooleanProperty("inFieldSet", false);
    }

    public void setValue(Object value) {
        this.setProperty("value", value);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty("enabled", true);
    }

    public void setEnabled(boolean enabled) {
        this.setBooleanProperty("enabled", enabled);
    }
}

