/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.impl;

import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.propertyeditor.Property;
import com.adobe.idp.dsc.propertyeditor.PropertyEditorMode;
import com.adobe.idp.dsc.propertyeditor.PropertySheet;
import com.adobe.idp.dsc.registry.propertyeditor.PropertyEditorRegistry;
import com.adobe.idp.dsc.registry.propertyeditor.client.PropertyEditorRegistryClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;

public class PropertySheetImpl
implements PropertySheet {
    protected OrderedMap m_properties;
    protected Map m_propertiesByID;
    protected List m_propList;
    protected ClassLoader m_parentClassLoader;
    private int last_id;
    protected PropertyEditorRegistry m_propEditorRegistry;
    private ServiceClientFactory m_serviceClientFactory;
    private PropertyEditorMode m_propertyEditorMode = PropertyEditorMode.EDIT;

    public PropertySheetImpl(ServiceClientFactory aServiceClientFactory) {
        this.m_serviceClientFactory = aServiceClientFactory;
        this.last_id = 0;
        this.m_propertyEditorMode = PropertyEditorMode.EDIT;
    }

    public void setClassLoader(ClassLoader aClassLoader) {
        this.m_parentClassLoader = aClassLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.m_parentClassLoader == null) {
            this.m_parentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.m_parentClassLoader;
    }

    public PropertySheetImpl(ServiceClientFactory aServiceClientFactory, List aProperties) {
        this.m_serviceClientFactory = aServiceClientFactory;
        this.m_properties = new ListOrderedMap();
        this.m_propertiesByID = new HashMap();
        for (Property _prop : aProperties) {
            this.m_properties.put((Object)_prop.getName(), (Object)_prop);
            this.m_propertiesByID.put(this.getPropertyID(_prop), _prop);
        }
    }

    private Object getPropertyID(Property _prop) {
        String id = _prop.getID();
        if (id != null && id.length() > 0) {
            return id;
        }
        return "prop" + this.last_id++;
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        if (this.m_propEditorRegistry == null) {
            this.m_propEditorRegistry = this.m_serviceClientFactory != null ? new PropertyEditorRegistryClient(this.m_serviceClientFactory) : new PropertyEditorRegistryClient(ServiceClientFactory.createInstance());
        }
        return this.m_propEditorRegistry;
    }

    public void addProperty(Property aProp) {
        if (this.m_properties == null) {
            this.m_properties = new ListOrderedMap();
            this.m_propertiesByID = new HashMap();
        }
        this.m_propList = null;
        this.m_properties.put((Object)aProp.getName(), (Object)aProp);
        this.m_propertiesByID.put(this.getPropertyID(aProp), aProp);
    }

    public Property getProperty(String aPropName) {
        Property _result = (Property)this.m_properties.get((Object)aPropName);
        if (_result == null && (_result = (Property)this.m_properties.get((Object)("*" + aPropName))) == null && aPropName.startsWith("*")) {
            _result = (Property)this.m_properties.get((Object)aPropName.substring(1));
        }
        return _result;
    }

    public Property getPropertyByID(String aID) {
        return (Property)this.m_propertiesByID.get(aID);
    }

    public List getProperties() {
        if (this.m_properties == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.m_propList == null) {
            this.m_propList = new ArrayList(this.m_properties.values());
        }
        return this.m_propList;
    }

    public void setPropertyEditorMode(PropertyEditorMode aPropertyEditorMode) {
        this.m_propertyEditorMode = aPropertyEditorMode;
    }

    public PropertyEditorMode getPropertyEditorMode() {
        return this.m_propertyEditorMode;
    }
}

