/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.impl;

import com.adobe.idp.dsc.datatype.TextSerializer;
import com.adobe.idp.dsc.propertyeditor.Property;
import com.adobe.idp.dsc.propertyeditor.PropertyChangeListener;
import com.adobe.idp.dsc.propertyeditor.PropertySheet;
import com.adobe.idp.dsc.propertyeditor.impl.AbstractProperty;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyChangeEventImpl;
import com.adobe.idp.dsc.propertyeditor.impl.PropertySheetImpl;
import com.adobe.idp.dsc.registry.component.ComponentRegistry;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.propertyeditor.PropertyEditorRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PropertyImpl
extends AbstractProperty
implements Property {
    protected ComponentRegistry m_registry;
    protected String m_name;
    protected String m_title;
    protected String m_type;
    protected String m_editorId;
    protected String m_componentId;
    protected String m_componentVersion;
    protected String m_parameterHint;
    protected Object m_value;
    protected Map m_parameters;
    protected PropertySheetImpl m_propSheet;
    protected ServiceConfiguration m_serviceConfig;
    private String m_id;
    private List<PropertyChangeListener> m_propertyChangeListeners;

    public PropertyImpl(PropertySheetImpl aPropSheet, ServiceConfiguration sc) {
        this.m_propSheet = aPropSheet;
        this.m_serviceConfig = sc;
    }

    public String getEditorId() {
        return this.m_editorId;
    }

    public void setComponentId(String aId) {
        this.m_componentId = aId;
    }

    public String getComponentId() {
        return this.m_componentId;
    }

    public void setComponentVersion(String aVersion) {
        this.m_componentVersion = aVersion;
    }

    public String getComponentVersion() {
        return this.m_componentVersion;
    }

    public void setEditorId(String aEditorId) {
        this.m_editorId = aEditorId;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String aName) {
        this.m_name = aName;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String aTitle) {
        this.m_title = aTitle;
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String aType) {
        this.m_type = aType;
    }

    public void setValue(Object aValue) {
        this.m_value = aValue;
        this.notifyChangeListeners();
    }

    public Object getValue() {
        return this.m_value;
    }

    public void setValueAsText(String aText) {
        TextSerializer _Text_serializer = this.getSerializer();
        Class _configTypeClass = this.getConfigurationTypeClass();
        this.m_value = _Text_serializer.deserializeValue(_configTypeClass, aText, this.getClassLoader());
        this.notifyChangeListeners();
    }

    public String getValueAsText() {
        TextSerializer _Text_serializer = this.getSerializer();
        return _Text_serializer.serializeValue(this.m_value);
    }

    public Map getParameters() {
        return this.m_parameters;
    }

    public void setParameters(Map aParams) {
        this.m_parameters = aParams;
    }

    public PropertySheet getPropertySheet() {
        return this.m_propSheet;
    }

    public void setPropertySheet(PropertySheet aSheet) {
        this.m_propSheet = (PropertySheetImpl)aSheet;
    }

    public String getID() {
        return this.m_id;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.m_propSheet.getPropertyEditorRegistry();
    }

    public ServiceConfiguration getServiceConfiguration() {
        return this.m_serviceConfig;
    }

    public void setServiceConfiguration(ServiceConfiguration newVal) {
        this.m_serviceConfig = newVal;
    }

    public void setHint(String aNewHint) {
        this.m_parameterHint = aNewHint;
    }

    public String getHint() {
        return this.m_parameterHint;
    }

    public synchronized void addChangeListener(PropertyChangeListener aChangeListener) {
        if (this.m_propertyChangeListeners == null) {
            this.m_propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        }
        this.m_propertyChangeListeners.add(aChangeListener);
    }

    public synchronized void removeChangeListener(PropertyChangeListener aChangeListener) {
        if (this.m_propertyChangeListeners == null) {
            return;
        }
        this.m_propertyChangeListeners.remove(aChangeListener);
    }

    protected void notifyChangeListeners() {
        if (this.m_propertyChangeListeners == null) {
            return;
        }
        for (PropertyChangeListener _listener : this.m_propertyChangeListeners) {
            _listener.propertyChanged(new PropertyChangeEventImpl(this));
        }
    }
}

