/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.impl;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.datatype.TextSerializer;
import com.adobe.idp.dsc.datatype.impl.DefaultTextSerializer;
import com.adobe.idp.dsc.propertyeditor.Property;
import com.adobe.idp.dsc.propertyeditor.PropertySheet;
import com.adobe.idp.dsc.propertyeditor.UIComponent;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyContextImpl;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyEditorComponentClassLoader;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyEditorComponentImpl;
import com.adobe.idp.dsc.propertyeditor.system.SystemPropertyEditorRegistry;
import com.adobe.idp.dsc.registry.infomodel.PropertyEditorComponent;
import com.adobe.idp.dsc.registry.infomodel.ServiceConfiguration;
import com.adobe.idp.dsc.registry.propertyeditor.PropertyEditorRegistry;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.idp.dsc.util.TextUtil;
import java.util.Map;

public abstract class AbstractProperty
implements Property {
    protected TextSerializer m_converter;
    protected Class m_configurationTypeClass;
    protected UIComponent m_uiComponent;
    protected PropertySheet m_propSheet;
    protected ClassLoader m_classLoader;
    protected PropertyEditorComponent m_comp;

    public PropertyEditorComponent getPropertyEditorComponent() {
        try {
            if (this.m_comp == null) {
                if (TextUtil.isEmpty(this.getEditorId())) {
                    PropertyEditorComponentImpl _depComp = (PropertyEditorComponentImpl)SystemPropertyEditorRegistry.getInstance().getPropertyEditorByType(this.getType());
                    if (_depComp != null) {
                        this.m_comp = _depComp.getPropertyEditorComponent();
                    }
                } else {
                    PropertyEditorComponentImpl _depComp = (PropertyEditorComponentImpl)SystemPropertyEditorRegistry.getInstance().getPropertyEditorById(this.getEditorId());
                    if (_depComp != null) {
                        this.m_comp = _depComp.getPropertyEditorComponent();
                    }
                }
                if (this.m_comp == null) {
                    this.m_comp = this.getPropertyEditorRegistry().getHeadPropertyEditor(this.getEditorId());
                }
            }
            return this.m_comp;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    public ClassLoader getClassLoader() {
        try {
            if (this.m_classLoader == null) {
                if (TextUtil.isEmpty(this.getEditorId())) {
                    this.m_classLoader = SystemPropertyEditorRegistry.getInstance().getDefaultClassLoader();
                } else if (SystemPropertyEditorRegistry.getInstance().getPropertyEditorById(this.getEditorId()) != null) {
                    this.m_classLoader = SystemPropertyEditorRegistry.getInstance().getDefaultClassLoader();
                } else {
                    PropertyEditorComponent _comp = this.getPropertyEditorComponent();
                    this.m_classLoader = new PropertyEditorComponentClassLoader(this.getPropertySheet().getClassLoader(), _comp, this.getPropertyEditorRegistry().getClientLibAsMap(_comp.getId(), _comp.getMajorVersion(), _comp.getMinorVersion()));
                }
            }
            return this.m_classLoader;
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    protected TextSerializer getSerializer() {
        try {
            PropertyEditorComponent _comp;
            if (this.m_converter == null && (_comp = this.getPropertyEditorComponent()) != null && !TextUtil.isEmpty(_comp.getSerializerClass())) {
                this.m_converter = (TextSerializer)this.getClassLoader().loadClass(_comp.getSerializerClass()).newInstance();
            }
            if (this.m_converter == null) {
                this.m_converter = DefaultTextSerializer.getDefaultInstance();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DSCRuntimeException(ex);
        }
        return this.m_converter;
    }

    protected Class getConfigurationTypeClass() {
        try {
            if (this.m_configurationTypeClass == null) {
                this.m_configurationTypeClass = ClassHelper.forName(this.getPropertyEditorComponent().getConfigurationType(), this.getClassLoader());
            }
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
        return this.m_configurationTypeClass;
    }

    public UIComponent getUIComponent(String aUIType) {
        try {
            if (this.m_uiComponent == null) {
                if (TextUtil.isEmpty(this.getEditorId())) {
                    this.m_uiComponent = SystemPropertyEditorRegistry.getInstance().getUIComponentByType(this.getType(), aUIType);
                } else {
                    this.m_uiComponent = SystemPropertyEditorRegistry.getInstance().getUIComponentById(this.getEditorId(), aUIType);
                    if (this.m_uiComponent == null) {
                        this.m_uiComponent = (UIComponent)this.getClassLoader().loadClass(this.getPropertyEditorComponent().getUIComponentClass(aUIType)).newInstance();
                    }
                }
                PropertyContextImpl _ctx = this.getNewPropertyContextImpl();
                _ctx.setCurrentPropert(this);
                _ctx.setPropertySheet(this.getPropertySheet());
                _ctx.setParameters(this.getParameters());
                _ctx.setServiceConfiguration(this.getServiceConfiguration());
                this.m_uiComponent.setPropertyContext(_ctx);
            }
        }
        catch (Exception ex) {
            throw new DSCRuntimeException(ex);
        }
        return this.m_uiComponent;
    }

    public PropertyContextImpl getNewPropertyContextImpl() {
        return new PropertyContextImpl();
    }

    public abstract String getEditorId();

    public abstract String getType();

    public abstract String getComponentId();

    public abstract String getComponentVersion();

    public abstract PropertyEditorRegistry getPropertyEditorRegistry();

    public abstract PropertySheet getPropertySheet();

    public abstract Map getParameters();

    public abstract ServiceConfiguration getServiceConfiguration();
}

