/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.eclipse.ui.shared;

import com.adobe.idp.dsc.propertyeditor.eclipse.ui.shared.CalendarDialog;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DateWidget
extends Composite {
    private Date date = null;
    private Text dateTextField = null;
    private Button calendarBtn = null;

    public DateWidget(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, false));
        this.dateTextField = new Text((Composite)this, 2056);
        this.calendarBtn = new Button((Composite)this, 8);
        Image _img = DateWidget.loadImage(Display.getCurrent(), DateWidget.class, "calendar.png");
        this.calendarBtn.setImage(_img);
        this.calendarBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DateWidget.this.showCalendarDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.updateText();
    }

    public void setDate(Date date) {
        this.date = date;
        this.updateText();
    }

    private void updateText() {
        if (this.date != null && this.dateTextField != null && !this.dateTextField.isDisposed()) {
            this.dateTextField.setText(this.date.toLocaleString());
        }
    }

    public Date getDate() {
        return this.date;
    }

    private void showCalendarDialog() {
        CalendarDialog _dlg = new CalendarDialog(Display.getCurrent().getActiveShell(), this.getDate());
        _dlg.open();
        if (_dlg.getSelectedDate() != null) {
            this.setDate(_dlg.getSelectedDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image loadImage(Display display, Class clazz, String string) {
        InputStream stream = clazz.getResourceAsStream(string);
        if (stream == null) {
            return null;
        }
        Image image = null;
        try {
            image = new Image((Device)display, stream);
        }
        catch (SWTException ex) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {}
        }
        return image;
    }

    public void addModifyListener(ModifyListener modifyListener) {
        if (this.dateTextField != null && !this.dateTextField.isDisposed()) {
            this.dateTextField.addModifyListener(modifyListener);
        }
    }
}

