/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.eclipse.ui.shared;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class CalendarWidget
extends Composite {
    private static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private Date date = new Date();
    private Combo monthsCombo;
    private Spinner yearSpinner;
    private Label[] m_dayLabel;
    private int firstLabelIndex;
    private int lastLabelIndex;
    private Color darkGrayColor;
    private Color lightGrayColor;
    private Group groupPanel;

    public CalendarWidget(Composite parent) {
        super(parent, 0x1000000);
        this.renderComponent(this);
        this.setValues();
        this.setBounds(0, 0, 223, 210);
    }

    private void setValues() {
        if (this.date != null && this.monthsCombo != null && this.yearSpinner != null && !this.isDisposed()) {
            this.selectMonth();
            this.setYearInSpinner();
            this.updateDays();
        }
    }

    private void updateDays() {
        Calendar now = Calendar.getInstance();
        if (this.date != null) {
            now.setTime(this.date);
        }
        Calendar working = (Calendar)now.clone();
        working.set(5, 1);
        int firstDayOfWeek = working.get(7);
        int lastDay = working.getActualMaximum(5);
        this.firstLabelIndex = --firstDayOfWeek;
        this.lastLabelIndex = this.firstLabelIndex + lastDay - 1;
        for (int labelIndex = 0; labelIndex < 42; ++labelIndex) {
            this.m_dayLabel[labelIndex].setBackground(this.lightGrayColor);
            if (labelIndex < this.firstLabelIndex || labelIndex > this.lastLabelIndex) {
                this.m_dayLabel[labelIndex].setText("");
                continue;
            }
            this.m_dayLabel[labelIndex].setText(Integer.toString(labelIndex - this.firstLabelIndex + 1));
        }
        int selectedDay = this.date.getDate();
        this.m_dayLabel[selectedDay + this.firstLabelIndex - 1].setBackground(this.darkGrayColor);
    }

    private void selectMonth() {
        this.monthsCombo.select(this.date.getMonth());
    }

    private void setYearInSpinner() {
        this.yearSpinner.setSelection(1900 + this.date.getYear());
    }

    public void setDate(Date date) {
        this.date = date;
        this.setValues();
    }

    public Date getDate() {
        return this.date;
    }

    public void renderComponent(Composite aContainer) {
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new GridLayout(1, true));
        this.lightGrayColor = aContainer.getBackground();
        this.darkGrayColor = new Color((Device)aContainer.getDisplay(), this.lightGrayColor.getRed() / 2, this.lightGrayColor.getRed() / 2, this.lightGrayColor.getRed() / 2);
        this.groupPanel = new Group(aContainer, 0);
        this.groupPanel.setText("Date");
        this.groupPanel.setLayoutData((Object)new GridData(1808));
        this.groupPanel.setLayout((Layout)new GridLayout(1, true));
        Composite _infoPanel = new Composite((Composite)this.groupPanel, 2048);
        _infoPanel.setLayoutData((Object)new GridData(768));
        _infoPanel.setLayout((Layout)new GridLayout(2, false));
        this.monthsCombo = new Combo(_infoPanel, 0x1000008);
        this.monthsCombo.setLayoutData((Object)new GridData(768));
        this.fillMonthsCombo();
        this.yearSpinner = new Spinner(_infoPanel, 2048);
        this.yearSpinner.setLayoutData((Object)new GridData(768));
        this.yearSpinner.setMinimum(1900);
        this.yearSpinner.setMaximum(3000);
        Composite _calendarPanel = new Composite((Composite)this.groupPanel, 2048);
        _calendarPanel.setLayoutData((Object)new GridData(1808));
        _calendarPanel.setLayout((Layout)new GridLayout(7, true));
        String[] WeekdaysName = new String[]{"S", "M", "T", "W", "T", "F", "S"};
        for (int index = 0; index < WeekdaysName.length; ++index) {
            Label _lbl = new Label(_calendarPanel, 0x1000000);
            _lbl.setLayoutData((Object)new GridData(768));
            _lbl.setText(WeekdaysName[index]);
        }
        this.m_dayLabel = new Label[42];
        for (int labelIndex = 0; labelIndex < 42; ++labelIndex) {
            this.m_dayLabel[labelIndex] = new Label(_calendarPanel, 0x1000000);
            this.m_dayLabel[labelIndex].setLayoutData((Object)new GridData(768));
            this.m_dayLabel[labelIndex].addMouseListener((MouseListener)new DayLabelMouseAdapter(labelIndex));
        }
        this.monthsCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CalendarWidget.this.date.setMonth(CalendarWidget.this.monthsCombo.getSelectionIndex());
                CalendarWidget.this.setValues();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.yearSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int spinnerValue = CalendarWidget.this.yearSpinner.getSelection() - 1900;
                if (CalendarWidget.this.date.getYear() != spinnerValue) {
                    CalendarWidget.this.date.setYear(spinnerValue);
                    CalendarWidget.this.setValues();
                }
            }
        });
    }

    private void fillMonthsCombo() {
        for (int index = 0; index < MONTH_NAMES.length; ++index) {
            this.monthsCombo.add(MONTH_NAMES[index]);
        }
    }

    public void dispose() {
        this.darkGrayColor.dispose();
        super.dispose();
    }

    class DayLabelMouseAdapter
    extends MouseAdapter {
        private int labelIndex;

        public DayLabelMouseAdapter(int labelIndex) {
            this.labelIndex = labelIndex;
        }

        public void mouseUp(MouseEvent e) {
            if (this.labelIndex < CalendarWidget.this.firstLabelIndex) {
                return;
            }
            if (this.labelIndex > CalendarWidget.this.lastLabelIndex) {
                return;
            }
            Label _srcLabel = (Label)e.getSource();
            CalendarWidget.this.date.setDate(Integer.parseInt(_srcLabel.getText()));
            CalendarWidget.this.setValues();
        }
    }

    class DateSelectionListener
    implements SelectionListener {
        private CalendarWidget m_calendarPanel;
        private Calendar m_calendar;

        public DateSelectionListener(CalendarWidget owner, Calendar working, int day) {
            this.m_calendarPanel = owner;
            this.m_calendar = (Calendar)working.clone();
            this.m_calendar.set(5, day);
        }

        public void widgetSelected(SelectionEvent e) {
            this.m_calendarPanel.setDate(this.m_calendar.getTime());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

