/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.composite;

import com.adobe.idp.dsc.datatype.TextSerializer;
import com.adobe.idp.dsc.propertyeditor.Property;
import com.adobe.idp.dsc.propertyeditor.composite.AttributeMapping;
import com.adobe.idp.dsc.propertyeditor.composite.CompositeObjectMappingProperty;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyImpl;
import com.adobe.idp.dsc.propertyeditor.impl.PropertySheetImpl;
import com.adobe.idp.dsc.util.ClassHelper;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;

public class CompositeProperty
extends PropertyImpl
implements Serializable {
    static final long serialVersionUID = -7014142598770989041L;
    private Property m_parent;
    private Property m_root;
    private AttributeMapping m_mapping;
    private Class m_type;

    public CompositeProperty(Property aParentProperty, AttributeMapping aMapping) {
        super((PropertySheetImpl)aParentProperty.getPropertySheet(), null);
        this.m_parent = aParentProperty;
        this.m_mapping = aMapping;
        Class _parentType = null;
        try {
            _parentType = ClassHelper.forName(aParentProperty.getType(), aParentProperty.getClassLoader());
            PropertyDescriptor[] _descriptors = PropertyUtils.getPropertyDescriptors((Class)_parentType);
            for (int i = 0; i < _descriptors.length; ++i) {
                if (!_descriptors[i].getName().equals(aMapping.getPropertyName())) continue;
                this.m_type = _descriptors[i].getPropertyType();
                break;
            }
            if (this.m_type == null) {
                this.m_type = aParentProperty.getClassLoader().loadClass(this.getClassName(aMapping.getPropertyType()));
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getClassName(String aClassName) {
        if (aClassName.equals("int")) {
            return "java.lang.Integer";
        }
        return aClassName;
    }

    public ClassLoader getClassLoader() {
        if (this.m_parent != null) {
            return this.m_parent.getClassLoader();
        }
        return super.getClassLoader();
    }

    public Object getValue() {
        TextSerializer _serializer = this.getSerializer();
        return _serializer.deserializeValue(this.getConfigurationTypeClass(), this.m_mapping.getValue(), this.getClassLoader());
    }

    public void setValue(Object aValue) {
        TextSerializer _serializer = this.getSerializer();
        this.m_mapping.setValue(_serializer.serializeValue(aValue));
        super.notifyChangeListeners();
        this.getRoot().setValue(this.getRoot().getValue());
    }

    public void setValueAsText(String aText) {
        this.m_mapping.setValue(aText);
        super.notifyChangeListeners();
        this.getRoot().setValue(this.getRoot().getValue());
    }

    public String getValueAsText() {
        return this.m_mapping.getValue();
    }

    public String getType() {
        return this.m_type.getName();
    }

    public String getEditorId() {
        return this.m_mapping.getPropertyEditorId();
    }

    public Map getParameters() {
        return this.m_mapping.getPropertyEditorParameters();
    }

    public String getName() {
        return this.m_mapping.getPropertyName();
    }

    public String[] getSupportedExpressionTypes() {
        return this.m_mapping.getSupportedExpressionTypes();
    }

    public String getHint() {
        return this.m_mapping.getHint();
    }

    public String getTitle() {
        return this.m_mapping.getTitle();
    }

    public String getSelectedExpressionType() {
        return this.m_mapping.getExpressionType();
    }

    public void setSelectedExpressionType(String aType) {
        this.m_mapping.setExpressionType(aType);
        this.getRoot().setValue(this.getRoot().getValue());
    }

    public Property getParent() {
        return this.m_parent;
    }

    public Property getRoot() {
        if (this.m_root == null) {
            Property _prop = this.getParent();
            if (_prop instanceof CompositeProperty) {
                this.m_root = ((CompositeProperty)_prop).getRoot();
            }
            this.m_root = _prop instanceof CompositeObjectMappingProperty ? ((CompositeObjectMappingProperty)_prop).getRoot() : _prop;
        }
        return this.m_root;
    }
}

