/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.composite;

import com.adobe.idp.dsc.propertyeditor.Property;
import com.adobe.idp.dsc.propertyeditor.composite.CompositeProperty;
import com.adobe.idp.dsc.propertyeditor.composite.ObjectMapping;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyImpl;
import com.adobe.idp.dsc.propertyeditor.impl.PropertySheetImpl;
import com.adobe.idp.dsc.util.ClassHelper;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import org.apache.commons.beanutils.PropertyUtils;

public class CompositeObjectMappingProperty
extends PropertyImpl
implements Serializable {
    static final long serialVersionUID = -7014142598770989041L;
    private Property m_parent;
    private Property m_root;
    private ObjectMapping m_mapping;
    private Class m_type;

    public CompositeObjectMappingProperty(Property aParentProperty, ObjectMapping aPropertyMapping) {
        super((PropertySheetImpl)aParentProperty.getPropertySheet(), null);
        this.m_parent = aParentProperty;
        this.m_mapping = aPropertyMapping;
        Class _parentType = null;
        try {
            _parentType = ClassHelper.forName(aParentProperty.getType(), aParentProperty.getClassLoader());
            PropertyDescriptor[] _descriptors = PropertyUtils.getPropertyDescriptors((Class)_parentType);
            for (int i = 0; i < _descriptors.length; ++i) {
                if (!_descriptors[i].getName().equals(aPropertyMapping.getPropertyName())) continue;
                this.m_type = _descriptors[i].getPropertyType();
                break;
            }
            if (this.m_type == null) {
                this.m_type = aParentProperty.getClassLoader().loadClass(aPropertyMapping.getPropertyType());
            }
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ClassLoader getClassLoader() {
        if (this.m_parent != null) {
            return this.m_parent.getClassLoader();
        }
        return super.getClassLoader();
    }

    public String getType() {
        return this.m_type.getName();
    }

    public String getName() {
        return this.m_mapping.getPropertyName();
    }

    public Property getParent() {
        return this.m_parent;
    }

    public Property getRoot() {
        if (this.m_root == null) {
            Property _prop = this.getParent();
            if (_prop instanceof CompositeProperty) {
                this.m_root = ((CompositeProperty)_prop).getRoot();
            }
            this.m_root = _prop instanceof CompositeObjectMappingProperty ? ((CompositeObjectMappingProperty)_prop).getRoot() : _prop;
        }
        return this.m_root;
    }
}

