/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.composite;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.datatype.TextSerializer;
import com.adobe.idp.dsc.datatype.impl.DefaultTextSerializer;
import com.adobe.idp.dsc.propertyeditor.composite.AbstractObjectMapping;
import com.adobe.idp.dsc.propertyeditor.composite.AttributeMapping;
import com.adobe.idp.dsc.propertyeditor.composite.CompositeConfiguration;
import com.adobe.idp.dsc.propertyeditor.composite.NestedObjectMapping;
import com.adobe.idp.dsc.propertyeditor.composite.ObjectMapping;
import com.adobe.idp.dsc.propertyeditor.composite.PropertyMapping;
import com.adobe.idp.dsc.propertyeditor.system.ComplexEditorVO;
import com.adobe.idp.dsc.util.DOMUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class CompositeConfigurationTextSerializer
implements TextSerializer {
    private static final CompositeConfigurationTextSerializer INSTANCE = new CompositeConfigurationTextSerializer();

    public static final CompositeConfigurationTextSerializer getDefaultInstance() {
        return INSTANCE;
    }

    public String serializeValue(Object aValue) {
        if (aValue == null) {
            return null;
        }
        try {
            CompositeConfiguration _config = (CompositeConfiguration)aValue;
            PropertyMapping[] _mappings = _config.getMappings();
            Document _doc = DOMUtil.newDocument();
            Element _elm = _doc.createElement("composite");
            _doc.appendChild(_elm);
            this.createMappingElements(_elm, _mappings);
            return DOMUtil.toString(_elm);
        }
        catch (ParserConfigurationException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    private void createMappingElements(Element aParent, PropertyMapping[] aMappings) {
        for (int i = 0; i < aMappings.length; ++i) {
            Element _mappingElm;
            PropertyMapping _mapping = aMappings[i];
            if (_mapping instanceof AttributeMapping) {
                AttributeMapping _attrMapping = (AttributeMapping)_mapping;
                _mappingElm = aParent.getOwnerDocument().createElement("mapping");
                _mappingElm.setAttribute("property", _attrMapping.getPropertyName());
                _mappingElm.setAttribute("expr-type", _attrMapping.getExpressionType());
                DOMUtil.setNodeText(_mappingElm, _attrMapping.getValue());
                aParent.appendChild(_mappingElm);
                continue;
            }
            NestedObjectMapping _objMapping = (NestedObjectMapping)_mapping;
            _mappingElm = aParent.getOwnerDocument().createElement("composite");
            _mappingElm.setAttribute("property", _objMapping.getPropertyName());
            aParent.appendChild(_mappingElm);
            this.createMappingElements(_mappingElm, _objMapping.getMappings());
        }
    }

    public Object deserializeValue(Class aTargetType, String aValue, ClassLoader aClassLoader) {
        if (aValue == null) {
            return null;
        }
        try {
            Document _doc = DOMUtil.parseDocumentFromString(aValue);
            if (_doc.getDocumentElement() == null) {
                return null;
            }
            if (_doc.getDocumentElement().getTagName().equals("composite")) {
                CompositeConfiguration _config = new CompositeConfiguration();
                Element _root = _doc.getDocumentElement();
                if (_root == null) {
                    return _config;
                }
                this.initializeObjectMapping(_config, _root);
                return _config;
            }
            CompositeConfiguration _composite = new CompositeConfiguration();
            ComplexEditorVO _vo = (ComplexEditorVO)DefaultTextSerializer.getDefaultInstance().deserializeValue(ComplexEditorVO.class, aValue, aClassLoader);
            Map _complexVoMap = _vo.getValues();
            Iterator _complexVoIter = _complexVoMap.keySet().iterator();
            HashMap<String, NestedObjectMapping> _objectMappings = new HashMap<String, NestedObjectMapping>();
            while (_complexVoIter.hasNext()) {
                String _path = (String)_complexVoIter.next();
                ComplexEditorVO.ComplexValue _complexValue = (ComplexEditorVO.ComplexValue)_complexVoMap.get(_path);
                String[] _paths = TextUtil.split(_path, '/');
                AbstractObjectMapping _objMapping = _composite;
                String _objPath = "";
                for (int i = 2; i < _paths.length - 1; ++i) {
                    NestedObjectMapping _nestedObjMapping = (NestedObjectMapping)_objectMappings.get(_objPath = _objPath + _paths[i]);
                    if (_nestedObjMapping != null) {
                        _objMapping = _nestedObjMapping;
                        continue;
                    }
                    _nestedObjMapping = new NestedObjectMapping();
                    _nestedObjMapping.setPropertyName(_paths[i]);
                    PropertyMapping[] _mappings = _objMapping.getMappings();
                    PropertyMapping[] _newMappings = new PropertyMapping[_mappings.length + 1];
                    System.arraycopy(_mappings, 0, _newMappings, 0, _mappings.length);
                    _newMappings[_mappings.length] = _nestedObjMapping;
                    _objectMappings.put(_objPath, _nestedObjMapping);
                    _objMapping.setMappings(_newMappings);
                    _objMapping = _nestedObjMapping;
                }
                PropertyMapping[] _mappings = _objMapping.getMappings();
                PropertyMapping[] _newMappings = new PropertyMapping[_mappings.length + 1];
                System.arraycopy(_mappings, 0, _newMappings, 0, _mappings.length);
                AttributeMapping _attrMapping = new AttributeMapping();
                _attrMapping.setPropertyName(_paths[_paths.length - 1]);
                _attrMapping.setExpressionType("LITERAL");
                if (_complexValue != null) {
                    _attrMapping.setValue(_complexValue.valueAsString);
                }
                _newMappings[_mappings.length] = _attrMapping;
                _objMapping.setMappings(_newMappings);
            }
            return _composite;
        }
        catch (ParserConfigurationException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (SAXException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    private void initializeObjectMapping(ObjectMapping aMapping, Element aElm) {
        Element[] _elements = DOMUtil.getChildElements(aElm);
        ArrayList<PropertyMapping> _mappingsLst = new ArrayList<PropertyMapping>(_elements.length);
        for (int i = 0; i < _elements.length; ++i) {
            Element _elm = _elements[i];
            if (_elm.getTagName().equals("mapping")) {
                AttributeMapping _mapping = new AttributeMapping();
                _mapping.setPropertyName(_elm.getAttribute("property"));
                _mapping.setExpressionType(_elm.getAttribute("expr-type"));
                _mapping.setValue(DOMUtil.getTextForNode(_elm));
                _mappingsLst.add(_mapping);
                continue;
            }
            if (!_elm.getTagName().equals("composite")) continue;
            NestedObjectMapping _nestedMapping = new NestedObjectMapping();
            _nestedMapping.setPropertyName(_elm.getAttribute("property"));
            this.initializeObjectMapping(_nestedMapping, _elm);
            _mappingsLst.add(_nestedMapping);
        }
        PropertyMapping[] _mappings = new PropertyMapping[_mappingsLst.size()];
        _mappingsLst.toArray(_mappings);
        aMapping.setMappings(_mappings);
    }
}

