/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.composite;

import com.adobe.idp.dsc.DSCRuntimeException;
import com.adobe.idp.dsc.clientsdk.ServiceClientFactory;
import com.adobe.idp.dsc.datatype.Convertable;
import com.adobe.idp.dsc.datatype.Converter;
import com.adobe.idp.dsc.datatype.TextSerializer;
import com.adobe.idp.dsc.datatype.impl.DefaultTextSerializer;
import com.adobe.idp.dsc.propertyeditor.composite.AttributeMapping;
import com.adobe.idp.dsc.propertyeditor.composite.CompositeConfiguration;
import com.adobe.idp.dsc.propertyeditor.composite.CompositeConfigurationTextSerializer;
import com.adobe.idp.dsc.propertyeditor.composite.NestedObjectMapping;
import com.adobe.idp.dsc.propertyeditor.composite.PropertyMapping;
import com.adobe.idp.dsc.propertyeditor.impl.PropertyEditorComponentImpl;
import com.adobe.idp.dsc.propertyeditor.system.SystemPropertyEditorRegistry;
import com.adobe.idp.dsc.registry.RegistryException;
import com.adobe.idp.dsc.registry.infomodel.CompositeEditorComponent;
import com.adobe.idp.dsc.registry.propertyeditor.client.PropertyEditorRegistryClient;
import com.adobe.idp.dsc.util.ClassHelper;
import com.adobe.idp.dsc.util.CoercionUtil;
import com.adobe.idp.dsc.util.TextUtil;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.PropertyUtils;

public class CompositeConfigurationConverter
implements Converter {
    public Object convert(Class aType, Object aValue, ClassLoader aClassLoader) {
        if (aValue == null || !(aValue instanceof CompositeConfiguration)) {
            return aValue;
        }
        try {
            CompositeConfiguration _config = (CompositeConfiguration)aValue;
            if (_config.getEditorComponent() == null) {
                return null;
            }
            Object _val = ClassHelper.forName(_config.getEditorComponent().getCompositeType(), aClassLoader).newInstance();
            PropertyMapping[] _mappings = _config.getMappings();
            this.processMapping(_val, _mappings, aClassLoader);
            return _val;
        }
        catch (ClassNotFoundException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new DSCRuntimeException(ex);
        }
    }

    private void processMapping(Object aVal, PropertyMapping[] aMappings, ClassLoader aRuntimeClassLoader) {
        try {
            for (int i = 0; i < aMappings.length; ++i) {
                PropertyMapping _mapping = aMappings[i];
                Object _val = null;
                if (_mapping instanceof AttributeMapping) {
                    AttributeMapping _attrMapping = (AttributeMapping)_mapping;
                    if (_attrMapping.getExpressionType() == null || !_attrMapping.getExpressionType().equals("LITERAL")) continue;
                    PropertyEditorRegistryClient _perClient = new PropertyEditorRegistryClient(ServiceClientFactory.createInstance());
                    PropertyEditorComponentImpl _peComp = null;
                    if (TextUtil.isEmpty(_attrMapping.getPropertyEditorId())) {
                        _peComp = (PropertyEditorComponentImpl)SystemPropertyEditorRegistry.getInstance().getPropertyEditorByType(_attrMapping.getPropertyType());
                    } else {
                        _peComp = (PropertyEditorComponentImpl)SystemPropertyEditorRegistry.getInstance().getPropertyEditorById(_attrMapping.getPropertyEditorId());
                        if (_peComp == null) {
                            _perClient = new PropertyEditorRegistryClient(ServiceClientFactory.createInstance());
                            _peComp = new PropertyEditorComponentImpl(_perClient.getHeadPropertyEditor(_attrMapping.getPropertyEditorId()), null);
                        }
                    }
                    ClassLoader _peClassLoader = _perClient.getClientClassLoader(Thread.currentThread().getContextClassLoader(), _peComp.getPropertyEditorComponent().getId(), _peComp.getPropertyEditorComponent().getMajorVersion(), _peComp.getPropertyEditorComponent().getMinorVersion());
                    Class<?> _propertyEditorType = _peClassLoader.loadClass(_peComp.getConfigurationType());
                    if (_propertyEditorType == CompositeConfiguration.class) {
                        CompositeEditorComponent _compEditor = (CompositeEditorComponent)_peComp.getPropertyEditorComponent();
                        CompositeConfiguration _compositeConfig = (CompositeConfiguration)CompositeConfigurationTextSerializer.getDefaultInstance().deserializeValue(_propertyEditorType, _attrMapping.getValue(), _peClassLoader);
                        _compositeConfig.applyMappingsForEditor(_compEditor);
                        this.processMapping(_compositeConfig, _compositeConfig.getMappings(), aRuntimeClassLoader);
                    } else if (TextUtil.isEmpty(_peComp.getSerializerClass())) {
                        _val = DefaultTextSerializer.getDefaultInstance().deserializeValue(_propertyEditorType, _attrMapping.getValue(), _peClassLoader);
                    } else {
                        Class<?> _serializerClass = _peClassLoader.loadClass(_peComp.getSerializerClass());
                        TextSerializer _serializer = (TextSerializer)_serializerClass.newInstance();
                        _val = _serializer.deserializeValue(_propertyEditorType, _attrMapping.getValue(), _peClassLoader);
                    }
                    Class _convertToType = ClassHelper.forName(_mapping.getPropertyType(), aRuntimeClassLoader);
                    if (_val instanceof Convertable) {
                        Convertable _convertable = (Convertable)_val;
                        _val = _convertable.convert(_convertToType);
                    } else if (!TextUtil.isEmpty(_peComp.getConverterClass())) {
                        Class<?> _converterClass = _peClassLoader.loadClass(_peComp.getConverterClass());
                        Converter _converter = (Converter)_converterClass.newInstance();
                        _val = _converter.convert(_convertToType, _val, aRuntimeClassLoader);
                    } else {
                        _val = CoercionUtil.toType(_convertToType, _val, aRuntimeClassLoader);
                    }
                    PropertyUtils.setSimpleProperty((Object)aVal, (String)_mapping.getPropertyName(), (Object)_val);
                    continue;
                }
                NestedObjectMapping _nestedMapping = (NestedObjectMapping)_mapping;
                Class<?> _nestedType = aRuntimeClassLoader.loadClass(_mapping.getPropertyType());
                Object _nestedVal = _nestedType.newInstance();
                PropertyUtils.setSimpleProperty((Object)aVal, (String)_mapping.getPropertyName(), _nestedVal);
                PropertyMapping[] _mappings = _nestedMapping.getMappings();
                this.processMapping(_val, _mappings, aRuntimeClassLoader);
            }
        }
        catch (IllegalAccessException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (RegistryException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new DSCRuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new DSCRuntimeException(ex);
        }
    }
}

