/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.composite;

import com.adobe.idp.dsc.propertyeditor.composite.PropertyMapping;
import com.adobe.idp.dsc.registry.infomodel.CompositeEditorSimpleAttribute;
import com.adobe.idp.dsc.util.TextUtil;
import java.io.Serializable;
import java.util.Map;

public class AttributeMapping
implements PropertyMapping,
Serializable {
    static final long serialVersionUID = 7220054589300079629L;
    public static final String XPATH_EXPR_TYPE = "XPATH";
    public static final String LITERAL_EXPR_TYPE = "LITERAL";
    public static final String VARIABLE_EXPR_TYPE = "VARIABLE";
    public static final String TEMPLATE_EXPR_TYPE = "TEMPLATE";
    private static final String[] EXPR_TYPES = new String[]{"XPATH", "LITERAL", "VARIABLE", "TEMPLATE"};
    private String m_propertyName;
    private String m_expressionType;
    private String m_value;
    private CompositeEditorSimpleAttribute m_attr;

    public AttributeMapping() {
    }

    public AttributeMapping(CompositeEditorSimpleAttribute aAttr) {
        this.setCompositeEditorSimpleAttribute(aAttr);
    }

    public void setCompositeEditorSimpleAttribute(CompositeEditorSimpleAttribute aAttr) {
        this.m_attr = aAttr;
        this.m_propertyName = aAttr.getProperty();
    }

    public void setPropertyName(String aPropName) {
        this.m_propertyName = aPropName;
    }

    public String getPropertyName() {
        return this.m_propertyName;
    }

    public String getPropertyType() {
        if (this.m_attr == null) {
            return null;
        }
        return this.m_attr.getType();
    }

    public void setExpressionType(String aExprType) {
        this.m_expressionType = aExprType;
    }

    public String getExpressionType() {
        if (TextUtil.isEmpty(this.m_expressionType)) {
            String[] _supportedExprTypes = this.getSupportedExpressionTypes();
            if (_supportedExprTypes == null || _supportedExprTypes.length == 0) {
                return LITERAL_EXPR_TYPE;
            }
            return _supportedExprTypes[0];
        }
        return this.m_expressionType;
    }

    public void setValue(String aValue) {
        this.m_value = aValue;
    }

    public String getValue() {
        return this.m_value;
    }

    public String getPropertyEditorId() {
        if (this.m_attr == null || this.m_attr.getPropertyEditor() == null) {
            return null;
        }
        return this.m_attr.getPropertyEditor().getEditorId();
    }

    public Map getPropertyEditorParameters() {
        if (this.m_attr == null || this.m_attr.getPropertyEditor() == null) {
            return null;
        }
        return this.m_attr.getPropertyEditor().getParameters();
    }

    public String getTitle() {
        if (this.m_attr == null) {
            return this.getPropertyName();
        }
        return this.m_attr.getTitle();
    }

    public String[] getSupportedExpressionTypes() {
        if (this.m_attr == null || this.m_attr.getSupportedExpressionTypes() == null || this.m_attr.getSupportedExpressionTypes().length == 0) {
            return EXPR_TYPES;
        }
        return this.m_attr.getSupportedExpressionTypes();
    }

    public String getHint() {
        if (this.m_attr == null) {
            return null;
        }
        return this.m_attr.getHint();
    }
}

