/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.idp.dsc.propertyeditor.composite;

import com.adobe.idp.dsc.propertyeditor.composite.AttributeMapping;
import com.adobe.idp.dsc.propertyeditor.composite.NestedObjectMapping;
import com.adobe.idp.dsc.propertyeditor.composite.PropertyMapping;
import com.adobe.idp.dsc.registry.infomodel.CompositeEditorAttribute;
import com.adobe.idp.dsc.registry.infomodel.CompositeEditorObject;
import com.adobe.idp.dsc.registry.infomodel.CompositeEditorSimpleAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractObjectMapping
implements Serializable {
    static final long serialVersionUID = -756003520275029866L;
    private PropertyMapping[] m_mappings;
    private static final PropertyMapping[] EMPTY_MAPPINGS = new PropertyMapping[0];

    public PropertyMapping[] getMappings() {
        if (this.m_mappings == null) {
            return EMPTY_MAPPINGS;
        }
        return this.m_mappings;
    }

    public void setMappings(PropertyMapping[] aMappings) {
        this.m_mappings = aMappings;
    }

    protected void applyMappingsFromAttributes(List aAttributes) {
        ArrayList<PropertyMapping> _mappingsList = new ArrayList<PropertyMapping>(aAttributes.size());
        HashMap<String, PropertyMapping> _mappingsMap = null;
        if (this.m_mappings == null || this.m_mappings.length == 0) {
            _mappingsMap = Collections.EMPTY_MAP;
        } else {
            _mappingsMap = new HashMap<String, PropertyMapping>(this.m_mappings.length);
            for (int i = 0; i < this.m_mappings.length; ++i) {
                _mappingsMap.put(this.m_mappings[i].getPropertyName(), this.m_mappings[i]);
            }
        }
        Iterator _attrsIter = aAttributes.iterator();
        int i = 0;
        while (_attrsIter.hasNext()) {
            CompositeEditorAttribute _attribute = (CompositeEditorAttribute)_attrsIter.next();
            PropertyMapping _mapping = (PropertyMapping)_mappingsMap.get(_attribute.getName());
            if (_mapping != null) {
                if (_mapping instanceof AttributeMapping) {
                    AttributeMapping _attrMapping = (AttributeMapping)_mapping;
                    _attrMapping.setCompositeEditorSimpleAttribute((CompositeEditorSimpleAttribute)_attribute);
                } else if (_mapping instanceof NestedObjectMapping) {
                    NestedObjectMapping _objMapping = (NestedObjectMapping)_mapping;
                    _objMapping.setCompositeEditorObject((CompositeEditorObject)_attribute);
                }
            } else if (_attribute instanceof CompositeEditorObject) {
                CompositeEditorObject _compositeObjectAttribute = (CompositeEditorObject)_attribute;
                _mapping = new NestedObjectMapping(_compositeObjectAttribute);
            } else {
                CompositeEditorSimpleAttribute _simpleAttribute = (CompositeEditorSimpleAttribute)_attribute;
                _mapping = new AttributeMapping(_simpleAttribute);
            }
            _mappingsList.add(_mapping);
            ++i;
        }
        this.m_mappings = new PropertyMapping[_mappingsList.size()];
        _mappingsList.toArray(this.m_mappings);
    }
}

